/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.SystemUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;

public final class Vector3fa {
    public static final Codec<Vector3fa> a = Codec.FLOAT.listOf().comapFlatMap(vec2 -> SystemUtils.a(vec2, 3).map(vec -> new Vector3fa(((Float)vec.get(0)).floatValue(), ((Float)vec.get(1)).floatValue(), ((Float)vec.get(2)).floatValue())), vec -> ImmutableList.of((Object)Float.valueOf(vec.i), (Object)Float.valueOf(vec.j), (Object)Float.valueOf(vec.k)));
    public static Vector3fa b = new Vector3fa(-1.0f, 0.0f, 0.0f);
    public static Vector3fa c = new Vector3fa(1.0f, 0.0f, 0.0f);
    public static Vector3fa d = new Vector3fa(0.0f, -1.0f, 0.0f);
    public static Vector3fa e = new Vector3fa(0.0f, 1.0f, 0.0f);
    public static Vector3fa f = new Vector3fa(0.0f, 0.0f, -1.0f);
    public static Vector3fa g = new Vector3fa(0.0f, 0.0f, 1.0f);
    public static Vector3fa h = new Vector3fa(0.0f, 0.0f, 0.0f);
    private float i;
    private float j;
    private float k;

    public Vector3fa() {
    }

    public Vector3fa(float x2, float y2, float z2) {
        this.i = x2;
        this.j = y2;
        this.k = z2;
    }

    public Vector3fa(Vector4f vec) {
        this(vec.a(), vec.b(), vec.c());
    }

    public Vector3fa(Vec3D other) {
        this((float)other.b, (float)other.c, (float)other.d);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Vector3fa vector3f = (Vector3fa)object;
        if (Float.compare(vector3f.i, this.i) != 0) {
            return false;
        }
        if (Float.compare(vector3f.j, this.j) != 0) {
            return false;
        }
        return Float.compare(vector3f.k, this.k) == 0;
    }

    @Override
    public int hashCode() {
        int i2 = Float.floatToIntBits(this.i);
        i2 = 31 * i2 + Float.floatToIntBits(this.j);
        i2 = 31 * i2 + Float.floatToIntBits(this.k);
        return i2;
    }

    public float a() {
        return this.i;
    }

    public float b() {
        return this.j;
    }

    public float c() {
        return this.k;
    }

    public void a(float scale) {
        this.i *= scale;
        this.j *= scale;
        this.k *= scale;
    }

    public void a(float x2, float y2, float z2) {
        this.i *= x2;
        this.j *= y2;
        this.k *= z2;
    }

    public void a(Vector3fa min, Vector3fa max) {
        this.i = MathHelper.a(this.i, min.a(), max.a());
        this.j = MathHelper.a(this.j, min.a(), max.b());
        this.k = MathHelper.a(this.k, min.c(), max.c());
    }

    public void a(float min, float max) {
        this.i = MathHelper.a(this.i, min, max);
        this.j = MathHelper.a(this.j, min, max);
        this.k = MathHelper.a(this.k, min, max);
    }

    public void b(float x2, float y2, float z2) {
        this.i = x2;
        this.j = y2;
        this.k = z2;
    }

    public void a(Vector3fa vec) {
        this.i = vec.i;
        this.j = vec.j;
        this.k = vec.k;
    }

    public void c(float x2, float y2, float z2) {
        this.i += x2;
        this.j += y2;
        this.k += z2;
    }

    public void b(Vector3fa vector) {
        this.i += vector.i;
        this.j += vector.j;
        this.k += vector.k;
    }

    public void c(Vector3fa other) {
        this.i -= other.i;
        this.j -= other.j;
        this.k -= other.k;
    }

    public float d(Vector3fa other) {
        return this.i * other.i + this.j * other.j + this.k * other.k;
    }

    public boolean d() {
        float f2 = this.i * this.i + this.j * this.j + this.k * this.k;
        if ((double)f2 < 1.0E-5) {
            return false;
        }
        float g2 = MathHelper.i(f2);
        this.i *= g2;
        this.j *= g2;
        this.k *= g2;
        return true;
    }

    public void e(Vector3fa vector) {
        float f2 = this.i;
        float g2 = this.j;
        float h2 = this.k;
        float i2 = vector.a();
        float j2 = vector.b();
        float k2 = vector.c();
        this.i = g2 * k2 - h2 * j2;
        this.j = h2 * i2 - f2 * k2;
        this.k = f2 * j2 - g2 * i2;
    }

    public void a(Matrix3f matrix) {
        float f2 = this.i;
        float g2 = this.j;
        float h2 = this.k;
        this.i = matrix.a * f2 + matrix.b * g2 + matrix.c * h2;
        this.j = matrix.d * f2 + matrix.e * g2 + matrix.f * h2;
        this.k = matrix.g * f2 + matrix.h * g2 + matrix.i * h2;
    }

    public void a(Quaternion rotation) {
        Quaternion quaternion = new Quaternion(rotation);
        quaternion.a(new Quaternion(this.a(), this.b(), this.c(), 0.0f));
        Quaternion quaternion2 = new Quaternion(rotation);
        quaternion2.i();
        quaternion.a(quaternion2);
        this.b(quaternion.e(), quaternion.f(), quaternion.g());
    }

    public void a(Vector3fa vector, float delta) {
        float f2 = 1.0f - delta;
        this.i = this.i * f2 + vector.i * delta;
        this.j = this.j * f2 + vector.j * delta;
        this.k = this.k * f2 + vector.k * delta;
    }

    public Quaternion b(float angle) {
        return new Quaternion(this, angle, false);
    }

    public Quaternion c(float angle) {
        return new Quaternion(this, angle, true);
    }

    public Vector3fa e() {
        return new Vector3fa(this.i, this.j, this.k);
    }

    public void a(Float2FloatFunction function) {
        this.i = function.get(this.i);
        this.j = function.get(this.j);
        this.k = function.get(this.k);
    }

    @Override
    public String toString() {
        return "[" + this.i + ", " + this.j + ", " + this.k + "]";
    }
}

