/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io.chunk;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.PrioritizedTaskQueue;
import com.destroystokyo.paper.io.chunk.ChunkTask;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;

public final class ChunkSaveTask
extends ChunkTask {
    public final ChunkRegionLoader.AsyncSaveData asyncSaveData;
    public final IChunkAccess chunk;
    public final CompletableFuture<NBTTagCompound> onComplete = new CompletableFuture();
    private final AtomicInteger attemptedPriority;

    public ChunkSaveTask(WorldServer world, int chunkX, int chunkZ, int priority, ChunkTaskManager taskManager, ChunkRegionLoader.AsyncSaveData asyncSaveData, IChunkAccess chunk) {
        super(world, chunkX, chunkZ, priority, taskManager);
        this.chunk = chunk;
        this.asyncSaveData = asyncSaveData;
        this.attemptedPriority = new AtomicInteger(priority);
    }

    @Override
    public void run() {
        NBTTagCompound compound;
        try (Timing ignored = this.world.timings.chunkUnloadDataSave.startTimingIfSync();){
            compound = ChunkRegionLoader.saveChunk(this.world, this.chunk, this.asyncSaveData);
        }
        catch (Throwable ex) {
            PaperFileIOThread.LOGGER.error("Failed to serialize unloading chunk data for task: " + this.toString() + ", falling back to a synchronous execution", ex);
            ChunkTaskManager.queueChunkWaitTask(() -> {
                try (Timing ignored = this.world.timings.chunkUnloadDataSave.startTiming();){
                    NBTTagCompound data = PaperFileIOThread.FAILURE_VALUE;
                    try {
                        data = ChunkRegionLoader.saveChunk(this.world, this.chunk, this.asyncSaveData);
                        PaperFileIOThread.LOGGER.info("Successfully serialized chunk data for task: " + this.toString() + " synchronously");
                    }
                    catch (Throwable ex1) {
                        PaperFileIOThread.LOGGER.error("Failed to synchronously serialize unloading chunk data for task: " + this.toString() + "! Chunk data will be lost", ex1);
                    }
                    this.complete(data);
                }
            });
            return;
        }
        this.complete(compound);
    }

    @Override
    public boolean raisePriority(int priority) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalStateException("Invalid priority: " + priority);
        }
        int curr = this.attemptedPriority.get();
        while (curr > priority && !this.attemptedPriority.compareAndSet(curr, priority)) {
            curr = this.attemptedPriority.get();
        }
        return super.raisePriority(priority);
    }

    @Override
    public boolean updatePriority(int priority) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalStateException("Invalid priority: " + priority);
        }
        this.attemptedPriority.set(priority);
        return super.updatePriority(priority);
    }

    private void complete(NBTTagCompound compound) {
        try {
            this.onComplete.complete(compound);
        }
        catch (Throwable thr) {
            PaperFileIOThread.LOGGER.error("Failed to complete chunk data for task: " + this.toString(), thr);
        }
        if (compound != PaperFileIOThread.FAILURE_VALUE) {
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.world, this.chunkX, this.chunkZ, null, compound, this.attemptedPriority.get());
        }
        this.taskManager.chunkSaveTasks.compute(IOUtil.getCoordinateKey(this.chunkX, this.chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap != this) {
                throw new IllegalStateException("Expected this task to be scheduled, but another was! Other: " + valueInMap + ", this: " + this);
            }
            return null;
        });
    }
}

