/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private final EntityInsentient entity;

    public PaperPathfinder(EntityInsentient entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return this.entity.getBukkitMob();
    }

    public void stopPathfinding() {
        this.entity.D().n();
    }

    public boolean hasPath() {
        return this.entity.D().j() != null;
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        PathEntity path = this.entity.D().j();
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Validate.notNull((Object)loc, (String)"Location can not be null");
        PathEntity path = this.entity.D().a(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Validate.notNull((Object)target, (String)"Target can not be null");
        PathEntity path = this.entity.D().a((Entity)((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Validate.notNull((Object)path, (String)"PathResult can not be null");
        PathEntity pathEntity = ((PaperPathResult)path).path;
        return this.entity.D().a(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.D().t.d.e();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.D().t.d.b(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.D().t.d.d();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.D().t.d.a(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.D().t.d.f();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.D().t.d.c(canFloat);
    }

    private Location toLoc(PathPoint point) {
        return new Location((World)this.entity.s.getWorld(), (double)point.a, (double)point.b, (double)point.c);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final PathEntity path;

        PaperPathResult(PathEntity path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            PathPoint point = this.path.d();
            return point != null ? PaperPathfinder.this.toLoc(point) : null;
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (PathPoint point : this.path.a) {
                points.add(PaperPathfinder.this.toLoc(point));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.f();
        }

        @Nullable
        public Location getNextPoint() {
            if (!this.path.hasNext()) {
                return null;
            }
            return PaperPathfinder.this.toLoc(this.path.a.get(this.path.f()));
        }
    }
}

