/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.antixray.ChunkPacketBlockControllerAntiXray;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.SpigotWorldConfig;

public class PaperWorldConfig {
    private final String worldName;
    private final SpigotWorldConfig spigotConfig;
    private YamlConfiguration config;
    private boolean verbose;
    public boolean zombiesTargetTurtleEggs = true;
    public boolean piglinsGuardChests = true;
    public boolean useEigencraftRedstone = false;
    public boolean shouldRemoveDragon = false;
    public boolean onlyPlayersCollide = false;
    public boolean allowVehicleCollisions = true;
    public int wanderingTraderSpawnMinuteTicks = 1200;
    public int wanderingTraderSpawnDayTicks = 24000;
    public int wanderingTraderSpawnChanceFailureIncrement = 25;
    public int wanderingTraderSpawnChanceMin = 25;
    public int wanderingTraderSpawnChanceMax = 75;
    public boolean fixClimbingBypassingCrammingRule = false;
    public boolean fixCuringZombieVillagerDiscountExploit = true;
    public boolean disableMobSpawnerSpawnEggTransformation = false;
    public List<EnumDifficulty> zombieBreakDoors;
    public List<EnumDifficulty> vindicatorBreakDoors;
    public Map<EntityTypes<?>, Integer> entityPerChunkSaveLimits = new HashMap();
    public short keepLoadedRange;
    public int autoSavePeriod = -1;
    public int maxAutoSaveChunksPerTick = 24;
    public int cactusMaxHeight;
    public int reedMaxHeight;
    public int bambooMaxHeight;
    public int bambooMinHeight;
    public double babyZombieMovementModifier;
    public int fishingMinTicks;
    public int fishingMaxTicks;
    public boolean nerfedMobsShouldJump;
    public final Reference2IntMap<EnumCreatureType> softDespawnDistances = new Reference2IntOpenHashMap(EnumCreatureType.values().length);
    public final Reference2IntMap<EnumCreatureType> hardDespawnDistances = new Reference2IntOpenHashMap(EnumCreatureType.values().length);
    public boolean keepSpawnInMemory;
    public int fallingBlockHeightNerf;
    public int entityTNTHeightNerf;
    public int netherVoidTopDamageHeight;
    public float maxLeashDistance = 10.0f;
    public boolean disableEndCredits;
    public boolean optimizeExplosions;
    public boolean disableExplosionKnockback;
    public boolean disableThunder;
    public boolean disableIceAndSnow;
    public int mobSpawnerTickRate;
    public Integer waterAnimalMaxSpawnHeight;
    public Integer waterAnimalMinSpawnHeight;
    public int containerUpdateTickRate;
    public boolean disableChestCatDetection;
    public boolean disablePlayerCrits;
    public boolean allChunksAreSlimeChunks;
    public double slimeMaxSpawnHeightInSwamp = 70.0;
    public double slimeMinSpawnHeightInSwamp = 50.0;
    public double slimeMaxSpawnHeightInSlimeChunks = 40.0;
    public int portalSearchRadius;
    public int portalCreateRadius;
    public boolean portalSearchVanillaDimensionScaling;
    public boolean disableTeleportationSuffocationCheck;
    public boolean nonPlayerEntitiesOnScoreboards = false;
    public int nonPlayerArrowDespawnRate = -1;
    public int creativeArrowDespawnRate = -1;
    public double skeleHorseSpawnChance;
    public int fixedInhabitedTime;
    public int grassUpdateRate = 1;
    public boolean useVanillaScoreboardColoring;
    public boolean frostedIceEnabled = true;
    public int frostedIceDelayMin = 20;
    public int frostedIceDelayMax = 40;
    public boolean autoReplenishLootables;
    public boolean restrictPlayerReloot;
    public boolean changeLootTableSeedOnFill;
    public int maxLootableRefills;
    public int lootableRegenMin;
    public int lootableRegenMax;
    public boolean preventTntFromMovingInWater;
    public boolean filterNBTFromSpawnEgg = true;
    public boolean enableTreasureMaps = true;
    public boolean treasureMapsAlreadyDiscovered = false;
    public int maxCollisionsPerEntity = 8;
    public boolean parrotsHangOnBetter;
    public boolean disableCreeperLingeringEffect;
    public boolean disableSprintInterruptionOnAttack;
    public boolean disableEnderpearlExploit = true;
    public int shieldBlockingDelay = 5;
    public boolean scanForLegacyEnderDragon = true;
    public boolean ironGolemsCanSpawnInAir = false;
    public boolean armorStandEntityLookups = true;
    public boolean armorStandTick = true;
    public int waterOverLavaFlowSpeed;
    public boolean preventMovingIntoUnloadedChunks = false;
    public DuplicateUUIDMode duplicateUUIDMode = DuplicateUUIDMode.SAFE_REGEN;
    public int duplicateUUIDDeleteRange = 32;
    public boolean countAllMobsForSpawning = false;
    public boolean disableRelativeProjectileVelocity;
    public boolean disablePillagerPatrols = false;
    public double patrolSpawnChance = 0.2;
    public boolean patrolPerPlayerDelay = false;
    public int patrolDelay = 12000;
    public boolean patrolPerPlayerStart = false;
    public int patrolStartDay = 5;
    public boolean generateFlatBedrock = false;
    public boolean entitiesTargetWithFollowRange = false;
    public boolean cooldownHopperWhenFull = true;
    public boolean disableHopperMoveEvents = false;
    public boolean hoppersIgnoreOccludingBlocks = false;
    public boolean undeadImmuneToCertainEffects = true;
    public boolean spidersImmuneToPoisonEffect = true;
    public boolean witherImmuneToWitherEffect = true;
    public boolean witherSkeletonImmuneToWitherEffect = true;
    public boolean nerfNetherPortalPigmen = false;
    public double zombieVillagerInfectionChance = -1.0;
    public Reference2IntMap<EnumCreatureType> perWorldSpawnLimits = new Reference2IntOpenHashMap(SpawnerCreature.f.length);
    public int lightQueueSize = 20;
    public boolean antiXray;
    public ChunkPacketBlockControllerAntiXray.EngineMode engineMode;
    public int maxBlockHeight;
    public int updateRadius;
    public boolean lavaObscures;
    public boolean usePermission;
    public List<String> hiddenBlocks;
    public List<String> replacementBlocks;
    public boolean altItemDespawnRateEnabled;
    public Map<Material, Integer> altItemDespawnRateMap;
    public boolean perPlayerMobSpawns = false;
    public boolean enderDragonsDeathAlwaysPlacesDragonEgg = false;
    public boolean updatePathfindingOnBlockUpdate = true;
    public boolean phantomIgnoreCreative = true;
    public boolean phantomOnlyAttackInsomniacs = true;
    public boolean zombiesAlwaysCanPickUpLoot;
    public boolean skeletonsAlwaysCanPickUpLoot;
    public int expMergeMaxValue;
    public long delayChunkUnloadsBy;
    public boolean allowUsingSignsInsideSpawnProtection = false;
    public int mapItemFrameCursorLimit = 128;
    public int mapItemFrameCursorUpdateInterval = 10;
    public boolean fixItemsMergingThroughWalls;
    public boolean fixInvulnerableEndCrystalExploit = true;
    public boolean showSignClickCommandFailureMessagesToPlayer = false;
    public boolean allowPlayerCrammingDamage = false;
    public boolean splitOverstackedLoot = true;
    private Table<String, String, Integer> sensorTickRates;
    private Table<String, String, Integer> behaviorTickRates;
    public boolean hideItemmetaFromClients = false;
    public boolean hideDurabilityFromClients = false;
    public Object2LongOpenHashMap<MinecraftKey> featureSeeds = new Object2LongOpenHashMap();
    public int maxBlockLightForMonsterSpawning = -1;

    public PaperWorldConfig(String worldName, SpigotWorldConfig spigotConfig) {
        this.worldName = worldName;
        this.spigotConfig = spigotConfig;
        this.config = PaperConfig.config;
        this.init();
    }

    public void init() {
        this.config = PaperConfig.config;
        PaperConfig.log("-------- World Settings For [" + this.worldName + "] --------");
        PaperConfig.readConfig(PaperWorldConfig.class, this);
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
        if (this.config.get("world-settings." + this.worldName + "." + path) != null) {
            this.config.set("world-settings." + this.worldName + "." + path, val);
        }
    }

    public void removeOldValues() {
        boolean needsSave = false;
        if (PaperConfig.version < 24) {
            needsSave = true;
            this.set("despawn-ranges.soft", null);
            this.set("despawn-ranges.hard", null);
            this.set("spawn-limits.monsters", null);
            this.set("spawn-limits.animals", null);
            this.set("spawn-limits.water-animals", null);
            this.set("spawn-limits.water-ambient", null);
        }
        if (needsSave) {
            PaperConfig.saveConfig();
        }
    }

    private void zombiesTargetTurtleEggs() {
        this.zombiesTargetTurtleEggs = this.getBoolean("zombies-target-turtle-eggs", this.zombiesTargetTurtleEggs);
    }

    private void piglinsGuardChests() {
        this.piglinsGuardChests = this.getBoolean("piglins-guard-chests", this.piglinsGuardChests);
    }

    private void useEigencraftRedstone() {
        this.useEigencraftRedstone = this.getBoolean("use-faster-eigencraft-redstone", false);
        if (this.useEigencraftRedstone) {
            PaperConfig.log("Using Eigencraft redstone algorithm by theosib.");
        } else {
            PaperConfig.log("Using vanilla redstone algorithm.");
        }
    }

    private void shouldRemoveDragon() {
        this.shouldRemoveDragon = this.getBoolean("should-remove-dragon", this.shouldRemoveDragon);
        if (this.shouldRemoveDragon) {
            PaperConfig.log("The Ender Dragon will be removed if she already exists without a portal.");
        }
    }

    private void onlyPlayersCollide() {
        this.onlyPlayersCollide = this.getBoolean("only-players-collide", this.onlyPlayersCollide);
        this.allowVehicleCollisions = this.getBoolean("allow-vehicle-collisions", this.allowVehicleCollisions);
        if (this.onlyPlayersCollide && !this.allowVehicleCollisions) {
            PaperConfig.log("Collisions will only work if a player is one of the two entities colliding.");
        } else if (this.onlyPlayersCollide) {
            PaperConfig.log("Collisions will only work if a player OR a vehicle is one of the two entities colliding.");
        }
    }

    private void wanderingTraderSettings() {
        this.wanderingTraderSpawnMinuteTicks = this.getInt("wandering-trader.spawn-minute-length", this.wanderingTraderSpawnMinuteTicks);
        this.wanderingTraderSpawnDayTicks = this.getInt("wandering-trader.spawn-day-length", this.wanderingTraderSpawnDayTicks);
        this.wanderingTraderSpawnChanceFailureIncrement = this.getInt("wandering-trader.spawn-chance-failure-increment", this.wanderingTraderSpawnChanceFailureIncrement);
        this.wanderingTraderSpawnChanceMin = this.getInt("wandering-trader.spawn-chance-min", this.wanderingTraderSpawnChanceMin);
        this.wanderingTraderSpawnChanceMax = this.getInt("wandering-trader.spawn-chance-max", this.wanderingTraderSpawnChanceMax);
    }

    private void fixClimbingBypassingCrammingRule() {
        this.fixClimbingBypassingCrammingRule = this.getBoolean("fix-climbing-bypassing-cramming-rule", this.fixClimbingBypassingCrammingRule);
    }

    private void fixCuringExploit() {
        this.fixCuringZombieVillagerDiscountExploit = this.getBoolean("game-mechanics.fix-curing-zombie-villager-discount-exploit", this.fixCuringZombieVillagerDiscountExploit);
    }

    private void disableMobSpawnerSpawnEggTransformation() {
        this.disableMobSpawnerSpawnEggTransformation = this.getBoolean("game-mechanics.disable-mob-spawner-spawn-egg-transformation", this.disableMobSpawnerSpawnEggTransformation);
    }

    private void setupEntityBreakingDoors() {
        this.zombieBreakDoors = this.getEnumList("door-breaking-difficulty.zombie", Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.cb).collect(Collectors.toList()), EnumDifficulty.class);
        this.vindicatorBreakDoors = this.getEnumList("door-breaking-difficulty.vindicator", Arrays.stream(EnumDifficulty.values()).filter(EntityVindicator.e).collect(Collectors.toList()), EnumDifficulty.class);
    }

    private void entityPerChunkSaveLimits() {
        this.getInt("entity-per-chunk-save-limit.experience_orb", -1);
        this.getInt("entity-per-chunk-save-limit.snowball", -1);
        this.getInt("entity-per-chunk-save-limit.ender_pearl", -1);
        this.getInt("entity-per-chunk-save-limit.arrow", -1);
        this.getInt("entity-per-chunk-save-limit.fireball", -1);
        this.getInt("entity-per-chunk-save-limit.small_fireball", -1);
        PaperWorldConfig.addEntityPerChunkSaveLimitsFromSection(this.config.getConfigurationSection("world-settings.default.entity-per-chunk-save-limit"), this.entityPerChunkSaveLimits);
        PaperWorldConfig.addEntityPerChunkSaveLimitsFromSection(this.config.getConfigurationSection("world-settings." + this.worldName + ".entity-per-chunk-save-limit"), this.entityPerChunkSaveLimits);
    }

    private static void addEntityPerChunkSaveLimitsFromSection(ConfigurationSection section, Map<EntityTypes<?>, Integer> limitMap) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            int value = section.getInt(key);
            EntityTypes type = EntityTypes.a(key).orElse(null);
            if (type == null) {
                PaperConfig.logError("Invalid entity-per-chunk-save-limit config, '" + key + "' is not a valid entity type. Correct this in paper.yml.");
                continue;
            }
            if (value >= 0) {
                limitMap.put(type, value);
                continue;
            }
            limitMap.remove(type);
        }
    }

    private void keepLoadedRange() {
        this.keepLoadedRange = (short)(this.getInt("keep-spawn-loaded-range", Math.min(this.spigotConfig.viewDistance, 10)) * 16);
        PaperConfig.log("Keep Spawn Loaded Range: " + this.keepLoadedRange / 16);
    }

    private void autoSavePeriod() {
        this.autoSavePeriod = this.getInt("auto-save-interval", -1);
        if (this.autoSavePeriod > 0) {
            PaperConfig.log("Auto Save Interval: " + this.autoSavePeriod + " (" + this.autoSavePeriod / 20 + "s)");
        } else if (this.autoSavePeriod < 0) {
            this.autoSavePeriod = MinecraftServer.getServer().autosavePeriod;
        }
    }

    private void maxAutoSaveChunksPerTick() {
        this.maxAutoSaveChunksPerTick = this.getInt("max-auto-save-chunks-per-tick", 24);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path, int def) {
        return this.getInt(path, def, true);
    }

    private int getInt(String path, int def, boolean setDefault) {
        if (setDefault) {
            this.config.addDefault("world-settings.default." + path, (Object)def);
        }
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path, def));
    }

    private long getLong(String path, long def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getLong("world-settings." + this.worldName + "." + path, this.config.getLong("world-settings.default." + path));
    }

    private float getFloat(String path, float def) {
        return (float)this.getDouble(path, def);
    }

    private <T> List<T> getList(String path, List<T> def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private <T extends Enum<T>> List<T> getEnumList(String path, List<T> def, Class<T> type) {
        this.config.addDefault("world-settings.default." + path, def.stream().map(Enum::name).collect(Collectors.toList()));
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path)).stream().map(s2 -> Enum.valueOf(type, s2)).collect(Collectors.toList());
    }

    private void blockGrowthHeight() {
        this.cactusMaxHeight = this.getInt("max-growth-height.cactus", 3);
        this.reedMaxHeight = this.getInt("max-growth-height.reeds", 3);
        this.bambooMaxHeight = this.getInt("max-growth-height.bamboo.max", 16);
        this.bambooMinHeight = this.getInt("max-growth-height.bamboo.min", 11);
        PaperConfig.log("Max height for cactus growth " + this.cactusMaxHeight + ". Max height for reed growth " + this.reedMaxHeight + ". Max height for bamboo growth " + this.bambooMaxHeight + ". Min height for fully-grown bamboo " + this.bambooMinHeight + ".");
    }

    private void babyZombieMovementModifier() {
        this.babyZombieMovementModifier = this.getDouble("baby-zombie-movement-modifier", 0.5);
        if (PaperConfig.version < 20) {
            this.babyZombieMovementModifier = this.getDouble("baby-zombie-movement-speed", 0.5);
            this.set("baby-zombie-movement-modifier", this.babyZombieMovementModifier);
        }
        PaperConfig.log("Baby zombies will move at the speed of " + this.babyZombieMovementModifier);
    }

    private void fishingTickRange() {
        this.fishingMinTicks = this.getInt("fishing-time-range.MinimumTicks", 100);
        this.fishingMaxTicks = this.getInt("fishing-time-range.MaximumTicks", 600);
        PaperConfig.log("Fishing time ranges are between " + this.fishingMinTicks + " and " + this.fishingMaxTicks + " ticks");
    }

    private void nerfedMobsShouldJump() {
        this.nerfedMobsShouldJump = this.getBoolean("spawner-nerfed-mobs-should-jump", false);
    }

    private void despawnDistances() {
        if (PaperConfig.version < 24) {
            int softDistance = this.getInt("despawn-ranges.soft", 32, false);
            int hardDistance = this.getInt("despawn-ranges.hard", 128, false);
            for (EnumCreatureType value : EnumCreatureType.values()) {
                if (softDistance != 32) {
                    this.softDespawnDistances.put((Object)value, softDistance);
                }
                if (hardDistance == 128) continue;
                this.hardDespawnDistances.put((Object)value, hardDistance);
            }
        }
        for (EnumCreatureType category : EnumCreatureType.values()) {
            int hardDistance;
            int softDistance = this.getInt("despawn-ranges." + category.a() + ".soft", this.softDespawnDistances.getOrDefault((Object)category, category.g()));
            if (softDistance > (hardDistance = this.getInt("despawn-ranges." + category.a() + ".hard", this.hardDespawnDistances.getOrDefault((Object)category, category.f())))) {
                softDistance = hardDistance;
            }
            PaperConfig.log("Mobs in " + category.a() + " Despawn Ranges: Soft" + softDistance + " Hard: " + hardDistance);
            this.softDespawnDistances.put((Object)category, softDistance);
            this.hardDespawnDistances.put((Object)category, hardDistance);
        }
    }

    private void keepSpawnInMemory() {
        this.keepSpawnInMemory = this.getBoolean("keep-spawn-loaded", true);
        PaperConfig.log("Keep spawn chunk loaded: " + this.keepSpawnInMemory);
    }

    private void heightNerfs() {
        this.fallingBlockHeightNerf = this.getInt("falling-block-height-nerf", 0);
        this.entityTNTHeightNerf = this.getInt("tnt-entity-height-nerf", 0);
        if (this.fallingBlockHeightNerf != 0) {
            PaperConfig.log("Falling Block Height Limit set to Y: " + this.fallingBlockHeightNerf);
        }
        if (this.entityTNTHeightNerf != 0) {
            PaperConfig.log("TNT Entity Height Limit set to Y: " + this.entityTNTHeightNerf);
        }
    }

    public boolean doNetherTopVoidDamage() {
        return this.netherVoidTopDamageHeight > 0;
    }

    private void netherVoidTopDamageHeight() {
        boolean legacy;
        this.netherVoidTopDamageHeight = this.getInt("nether-ceiling-void-damage-height", 0);
        PaperConfig.log("Top of the nether void damage height: " + this.netherVoidTopDamageHeight);
        if (PaperConfig.version < 18 && (legacy = this.getBoolean("nether-ceiling-void-damage", false))) {
            this.netherVoidTopDamageHeight = 128;
            this.set("nether-ceiling-void-damage-height", this.netherVoidTopDamageHeight);
        }
    }

    private void maxLeashDistance() {
        this.maxLeashDistance = this.getFloat("max-leash-distance", this.maxLeashDistance);
        PaperConfig.log("Max leash distance: " + this.maxLeashDistance);
    }

    private void disableEndCredits() {
        this.disableEndCredits = this.getBoolean("game-mechanics.disable-end-credits", false);
        PaperConfig.log("End credits disabled: " + this.disableEndCredits);
    }

    private void optimizeExplosions() {
        this.optimizeExplosions = this.getBoolean("optimize-explosions", false);
        PaperConfig.log("Optimize explosions: " + this.optimizeExplosions);
    }

    private void disableExplosionKnockback() {
        this.disableExplosionKnockback = this.getBoolean("disable-explosion-knockback", false);
    }

    private void disableThunder() {
        this.disableThunder = this.getBoolean("disable-thunder", false);
    }

    private void disableIceAndSnow() {
        this.disableIceAndSnow = this.getBoolean("disable-ice-and-snow", false);
    }

    private void mobSpawnerTickRate() {
        this.mobSpawnerTickRate = this.getInt("mob-spawner-tick-rate", 1);
    }

    private void waterAnimalMaxSpawnHeight() {
        String v2 = this.getString("wateranimal-spawn-height.maximum", "default");
        try {
            this.waterAnimalMaxSpawnHeight = Integer.parseInt(v2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void waterAnimalMinSpawnHeight() {
        String v2 = this.getString("wateranimal-spawn-height.minimum", "default");
        try {
            this.waterAnimalMinSpawnHeight = Integer.parseInt(v2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void containerUpdateTickRate() {
        this.containerUpdateTickRate = this.getInt("container-update-tick-rate", 1);
    }

    private void disableChestCatDetection() {
        this.disableChestCatDetection = this.getBoolean("game-mechanics.disable-chest-cat-detection", false);
    }

    private void disablePlayerCrits() {
        this.disablePlayerCrits = this.getBoolean("game-mechanics.disable-player-crits", false);
    }

    private void allChunksAreSlimeChunks() {
        this.allChunksAreSlimeChunks = this.getBoolean("all-chunks-are-slime-chunks", false);
    }

    private void slimeSpawnHeight() {
        this.slimeMaxSpawnHeightInSwamp = this.getDouble("slime-spawn-height.swamp-biome.maximum", this.slimeMaxSpawnHeightInSwamp);
        this.slimeMinSpawnHeightInSwamp = this.getDouble("slime-spawn-height.swamp-biome.minimum", this.slimeMinSpawnHeightInSwamp);
        this.slimeMaxSpawnHeightInSlimeChunks = this.getDouble("slime-spawn-height.slime-chunk.maximum", this.slimeMaxSpawnHeightInSlimeChunks);
    }

    private void portalSearchRadius() {
        this.portalSearchRadius = this.getInt("portal-search-radius", 128);
        this.portalCreateRadius = this.getInt("portal-create-radius", 16);
        this.portalSearchVanillaDimensionScaling = this.getBoolean("portal-search-vanilla-dimension-scaling", true);
    }

    private void disableTeleportationSuffocationCheck() {
        this.disableTeleportationSuffocationCheck = this.getBoolean("disable-teleportation-suffocation-check", false);
    }

    private void nonPlayerEntitiesOnScoreboards() {
        this.nonPlayerEntitiesOnScoreboards = this.getBoolean("allow-non-player-entities-on-scoreboards", false);
    }

    private void nonPlayerArrowDespawnRate() {
        this.nonPlayerArrowDespawnRate = this.getInt("non-player-arrow-despawn-rate", -1);
        if (this.nonPlayerArrowDespawnRate == -1) {
            this.nonPlayerArrowDespawnRate = this.spigotConfig.arrowDespawnRate;
        }
        this.creativeArrowDespawnRate = this.getInt("creative-arrow-despawn-rate", -1);
        if (this.creativeArrowDespawnRate == -1) {
            this.creativeArrowDespawnRate = this.spigotConfig.arrowDespawnRate;
        }
        PaperConfig.log("Non Player Arrow Despawn Rate: " + this.nonPlayerArrowDespawnRate);
        PaperConfig.log("Creative Arrow Despawn Rate: " + this.creativeArrowDespawnRate);
    }

    private void skeleHorseSpawnChance() {
        this.skeleHorseSpawnChance = this.getDouble("skeleton-horse-thunder-spawn-chance", 0.01);
        if (this.skeleHorseSpawnChance < 0.0) {
            this.skeleHorseSpawnChance = 0.01;
        }
    }

    private void fixedInhabitedTime() {
        if (PaperConfig.version < 16) {
            if (!this.config.getBoolean("world-settings.default.use-chunk-inhabited-timer", true)) {
                this.config.set("world-settings.default.fixed-chunk-inhabited-time", (Object)0);
            }
            if (!this.config.getBoolean("world-settings." + this.worldName + ".use-chunk-inhabited-timer", true)) {
                this.config.set("world-settings." + this.worldName + ".fixed-chunk-inhabited-time", (Object)0);
            }
            this.set("use-chunk-inhabited-timer", null);
        }
        this.fixedInhabitedTime = this.getInt("fixed-chunk-inhabited-time", -1);
    }

    private void grassUpdateRate() {
        this.grassUpdateRate = Math.max(0, this.getInt("grass-spread-tick-rate", this.grassUpdateRate));
        PaperConfig.log("Grass Spread Tick Rate: " + this.grassUpdateRate);
    }

    private void useVanillaScoreboardColoring() {
        this.useVanillaScoreboardColoring = this.getBoolean("use-vanilla-world-scoreboard-name-coloring", false);
    }

    private void frostedIce() {
        this.frostedIceEnabled = this.getBoolean("frosted-ice.enabled", this.frostedIceEnabled);
        this.frostedIceDelayMin = this.getInt("frosted-ice.delay.min", this.frostedIceDelayMin);
        this.frostedIceDelayMax = this.getInt("frosted-ice.delay.max", this.frostedIceDelayMax);
        PaperConfig.log("Frosted Ice: " + (this.frostedIceEnabled ? "enabled" : "disabled") + " / delay: min=" + this.frostedIceDelayMin + ", max=" + this.frostedIceDelayMax);
    }

    private void enhancedLootables() {
        this.autoReplenishLootables = this.getBoolean("lootables.auto-replenish", false);
        this.restrictPlayerReloot = this.getBoolean("lootables.restrict-player-reloot", true);
        this.changeLootTableSeedOnFill = this.getBoolean("lootables.reset-seed-on-fill", true);
        this.maxLootableRefills = this.getInt("lootables.max-refills", -1);
        this.lootableRegenMin = PaperConfig.getSeconds(this.getString("lootables.refresh-min", "12h"));
        this.lootableRegenMax = PaperConfig.getSeconds(this.getString("lootables.refresh-max", "2d"));
        if (this.autoReplenishLootables) {
            PaperConfig.log("Lootables: Replenishing every " + PaperConfig.timeSummary(this.lootableRegenMin) + " to " + PaperConfig.timeSummary(this.lootableRegenMax) + (this.restrictPlayerReloot ? " (restricting reloot)" : ""));
        }
    }

    private void preventTntFromMovingInWater() {
        if (PaperConfig.version < 13) {
            boolean oldVal = this.getBoolean("enable-old-tnt-cannon-behaviors", false);
            this.set("prevent-tnt-from-moving-in-water", oldVal);
        }
        this.preventTntFromMovingInWater = this.getBoolean("prevent-tnt-from-moving-in-water", false);
        PaperConfig.log("Prevent TNT from moving in water: " + this.preventTntFromMovingInWater);
    }

    private void fitlerNBTFromSpawnEgg() {
        this.filterNBTFromSpawnEgg = this.getBoolean("filter-nbt-data-from-spawn-eggs-and-related", true);
        if (!this.filterNBTFromSpawnEgg) {
            Bukkit.getLogger().warning("Spawn Egg and Armor Stand NBT filtering disabled, this is a potential security risk");
        }
    }

    private void treasureMapsAlreadyDiscovered() {
        this.enableTreasureMaps = this.getBoolean("enable-treasure-maps", true);
        this.treasureMapsAlreadyDiscovered = this.getBoolean("treasure-maps-return-already-discovered", false);
        if (this.treasureMapsAlreadyDiscovered) {
            PaperConfig.log("Treasure Maps will return already discovered locations");
        }
    }

    private void maxEntityCollision() {
        this.maxCollisionsPerEntity = this.getInt("max-entity-collisions", this.spigotConfig.getInt("max-entity-collisions", this.maxCollisionsPerEntity, false));
        PaperConfig.log("Max Entity Collisions: " + this.maxCollisionsPerEntity);
    }

    private void parrotsHangOnBetter() {
        this.parrotsHangOnBetter = this.getBoolean("parrots-are-unaffected-by-player-movement", false);
        PaperConfig.log("Parrots are unaffected by player movement: " + this.parrotsHangOnBetter);
    }

    private void setDisableCreeperLingeringEffect() {
        this.disableCreeperLingeringEffect = this.getBoolean("disable-creeper-lingering-effect", false);
        PaperConfig.log("Creeper lingering effect: " + this.disableCreeperLingeringEffect);
    }

    private void disableSprintInterruptionOnAttack() {
        this.disableSprintInterruptionOnAttack = this.getBoolean("game-mechanics.disable-sprint-interruption-on-attack", false);
    }

    private void disableEnderpearlExploit() {
        this.disableEnderpearlExploit = this.getBoolean("game-mechanics.disable-unloaded-chunk-enderpearl-exploit", this.disableEnderpearlExploit);
        PaperConfig.log("Disable Unloaded Chunk Enderpearl Exploit: " + (this.disableEnderpearlExploit ? "enabled" : "disabled"));
    }

    private void shieldBlockingDelay() {
        this.shieldBlockingDelay = this.getInt("game-mechanics.shield-blocking-delay", 5);
    }

    private void scanForLegacyEnderDragon() {
        this.scanForLegacyEnderDragon = this.getBoolean("game-mechanics.scan-for-legacy-ender-dragon", true);
    }

    private void ironGolemsCanSpawnInAir() {
        this.ironGolemsCanSpawnInAir = this.getBoolean("iron-golems-can-spawn-in-air", this.ironGolemsCanSpawnInAir);
    }

    private void armorStandEntityLookups() {
        this.armorStandEntityLookups = this.getBoolean("armor-stands-do-collision-entity-lookups", true);
    }

    private void armorStandTick() {
        this.armorStandTick = this.getBoolean("armor-stands-tick", this.armorStandTick);
        PaperConfig.log("ArmorStand ticking is " + (this.armorStandTick ? "enabled" : "disabled") + " by default");
    }

    private void waterOverLavaFlowSpeed() {
        this.waterOverLavaFlowSpeed = this.getInt("water-over-lava-flow-speed", 5);
        PaperConfig.log("Water over lava flow speed: " + this.waterOverLavaFlowSpeed);
    }

    private void preventMovingIntoUnloadedChunks() {
        this.preventMovingIntoUnloadedChunks = this.getBoolean("prevent-moving-into-unloaded-chunks", false);
    }

    private void repairDuplicateUUID() {
        String desiredMode = this.getString("duplicate-uuid-resolver", "saferegen").toLowerCase().trim();
        this.duplicateUUIDDeleteRange = this.getInt("duplicate-uuid-saferegen-delete-range", this.duplicateUUIDDeleteRange);
        switch (desiredMode.toLowerCase()) {
            case "regen": 
            case "regenerate": 
            case "saferegen": 
            case "saferegenerate": {
                this.duplicateUUIDMode = DuplicateUUIDMode.SAFE_REGEN;
                PaperConfig.log("Duplicate UUID Resolve: Regenerate New UUID if distant (Delete likely duplicates within " + this.duplicateUUIDDeleteRange + " blocks)");
                break;
            }
            case "remove": 
            case "delete": {
                this.duplicateUUIDMode = DuplicateUUIDMode.DELETE;
                PaperConfig.log("Duplicate UUID Resolve: Delete Entity");
                break;
            }
            case "silent": 
            case "nothing": {
                this.duplicateUUIDMode = DuplicateUUIDMode.NOTHING;
                PaperConfig.logError("Duplicate UUID Resolve: Do Nothing (no logs) - Warning, may lose indication of bad things happening");
                break;
            }
            case "log": 
            case "warn": {
                this.duplicateUUIDMode = DuplicateUUIDMode.WARN;
                PaperConfig.log("Duplicate UUID Resolve: Warn (do nothing but log it happened, may be spammy)");
                break;
            }
            default: {
                this.duplicateUUIDMode = DuplicateUUIDMode.WARN;
                PaperConfig.logError("Warning: Invalid duplicate-uuid-resolver config " + desiredMode + " - must be one of: regen, delete, nothing, warn");
                PaperConfig.log("Duplicate UUID Resolve: Warn (do nothing but log it happened, may be spammy)");
            }
        }
    }

    private void countAllMobsForSpawning() {
        this.countAllMobsForSpawning = this.getBoolean("count-all-mobs-for-spawning", false);
        if (this.countAllMobsForSpawning) {
            PaperConfig.log("Counting all mobs for spawning. Mob farms may reduce natural spawns elsewhere in world.");
        } else {
            PaperConfig.log("Using improved mob spawn limits (Only Natural Spawns impact spawn limits for more natural spawns)");
        }
    }

    private void disableRelativeProjectileVelocity() {
        this.disableRelativeProjectileVelocity = this.getBoolean("game-mechanics.disable-relative-projectile-velocity", false);
    }

    private void pillagerSettings() {
        this.disablePillagerPatrols = this.getBoolean("game-mechanics.disable-pillager-patrols", this.disablePillagerPatrols);
        this.patrolSpawnChance = this.getDouble("game-mechanics.pillager-patrols.spawn-chance", this.patrolSpawnChance);
        this.patrolPerPlayerDelay = this.getBoolean("game-mechanics.pillager-patrols.spawn-delay.per-player", this.patrolPerPlayerDelay);
        this.patrolDelay = this.getInt("game-mechanics.pillager-patrols.spawn-delay.ticks", this.patrolDelay);
        this.patrolPerPlayerStart = this.getBoolean("game-mechanics.pillager-patrols.start.per-player", this.patrolPerPlayerStart);
        this.patrolStartDay = this.getInt("game-mechanics.pillager-patrols.start.day", this.patrolStartDay);
    }

    private void generatorSettings() {
        this.generateFlatBedrock = this.getBoolean("generator-settings.flat-bedrock", this.generateFlatBedrock);
    }

    private void entitiesTargetWithFollowRange() {
        this.entitiesTargetWithFollowRange = this.getBoolean("entities-target-with-follow-range", this.entitiesTargetWithFollowRange);
    }

    private void hopperOptimizations() {
        this.cooldownHopperWhenFull = this.getBoolean("hopper.cooldown-when-full", this.cooldownHopperWhenFull);
        PaperConfig.log("Cooldown Hoppers when Full: " + (this.cooldownHopperWhenFull ? "enabled" : "disabled"));
        this.disableHopperMoveEvents = this.getBoolean("hopper.disable-move-event", this.disableHopperMoveEvents);
        PaperConfig.log("Hopper Move Item Events: " + (this.disableHopperMoveEvents ? "disabled" : "enabled"));
        this.hoppersIgnoreOccludingBlocks = this.getBoolean("hopper.ignore-occluding-blocks", this.hoppersIgnoreOccludingBlocks);
        PaperConfig.log("Hopper Ignore Container Entities inside Occluding Blocks: " + (this.hoppersIgnoreOccludingBlocks ? "enabled" : "disabled"));
    }

    private void mobEffectChanges() {
        this.undeadImmuneToCertainEffects = this.getBoolean("mob-effects.undead-immune-to-certain-effects", this.undeadImmuneToCertainEffects);
        PaperConfig.log("Undead immune to harmful effects: " + this.undeadImmuneToCertainEffects);
        this.spidersImmuneToPoisonEffect = this.getBoolean("mob-effects.spiders-immune-to-poison-effect", this.spidersImmuneToPoisonEffect);
        PaperConfig.log("Spiders immune to poison effect: " + this.spidersImmuneToPoisonEffect);
        this.witherImmuneToWitherEffect = this.getBoolean("mob-effects.immune-to-wither-effect.wither", this.witherImmuneToWitherEffect);
        PaperConfig.log("Wither immune to wither effect: " + this.witherImmuneToWitherEffect);
        this.witherSkeletonImmuneToWitherEffect = this.getBoolean("mob-effects.immune-to-wither-effect.wither-skeleton", this.witherSkeletonImmuneToWitherEffect);
        PaperConfig.log("Wither skeleton immune to wither effect: " + this.witherSkeletonImmuneToWitherEffect);
    }

    private void nerfNetherPortalPigmen() {
        this.nerfNetherPortalPigmen = this.getBoolean("game-mechanics.nerf-pigmen-from-nether-portals", this.nerfNetherPortalPigmen);
    }

    private void zombieVillagerInfectionChance() {
        this.zombieVillagerInfectionChance = this.getDouble("zombie-villager-infection-chance", this.zombieVillagerInfectionChance);
    }

    private void perWorldSpawnLimits() {
        this.perWorldSpawnLimits.defaultReturnValue(-1);
        if (PaperConfig.version < 24) {
            this.perWorldSpawnLimits.put((Object)EnumCreatureType.a, this.getInt("spawn-limits.monsters", -1, false));
            this.perWorldSpawnLimits.put((Object)EnumCreatureType.b, this.getInt("spawn-limits.animals", -1, false));
            this.perWorldSpawnLimits.put((Object)EnumCreatureType.f, this.getInt("spawn-limits.water-animals", -1, false));
            this.perWorldSpawnLimits.put((Object)EnumCreatureType.g, this.getInt("spawn-limits.water-ambient", -1, false));
        }
        for (EnumCreatureType value : SpawnerCreature.f) {
            this.perWorldSpawnLimits.put((Object)value, this.getInt("spawn-limits." + value.a(), this.perWorldSpawnLimits.getInt((Object)value)));
        }
    }

    private void lightQueueSize() {
        this.lightQueueSize = this.getInt("light-queue-size", this.lightQueueSize);
    }

    private void antiXray() {
        this.antiXray = this.getBoolean("anti-xray.enabled", false);
        this.engineMode = ChunkPacketBlockControllerAntiXray.EngineMode.getById(this.getInt("anti-xray.engine-mode", ChunkPacketBlockControllerAntiXray.EngineMode.HIDE.getId()));
        this.engineMode = this.engineMode == null ? ChunkPacketBlockControllerAntiXray.EngineMode.HIDE : this.engineMode;
        this.maxBlockHeight = this.getInt("anti-xray.max-block-height", 64);
        this.updateRadius = this.getInt("anti-xray.update-radius", 2);
        this.lavaObscures = this.getBoolean("anti-xray.lava-obscures", false);
        this.usePermission = this.getBoolean("anti-xray.use-permission", false);
        this.hiddenBlocks = this.getList("anti-xray.hidden-blocks", Arrays.asList("copper_ore", "deepslate_copper_ore", "gold_ore", "deepslate_gold_ore", "iron_ore", "deepslate_iron_ore", "coal_ore", "deepslate_coal_ore", "lapis_ore", "deepslate_lapis_ore", "mossy_cobblestone", "obsidian", "chest", "diamond_ore", "deepslate_diamond_ore", "redstone_ore", "deepslate_redstone_ore", "clay", "emerald_ore", "deepslate_emerald_ore", "ender_chest"));
        this.replacementBlocks = this.getList("anti-xray.replacement-blocks", Arrays.asList("stone", "oak_planks", "deepslate"));
        if (PaperConfig.version < 19) {
            this.hiddenBlocks.remove("lit_redstone_ore");
            int index = this.replacementBlocks.indexOf("planks");
            if (index != -1) {
                this.replacementBlocks.set(index, "oak_planks");
            }
            this.set("anti-xray.hidden-blocks", this.hiddenBlocks);
            this.set("anti-xray.replacement-blocks", this.replacementBlocks);
        }
        PaperConfig.log("Anti-Xray: " + (this.antiXray ? "enabled" : "disabled") + " / Engine Mode: " + this.engineMode.getDescription() + " / Up to " + (this.maxBlockHeight >> 4 << 4) + " blocks / Update Radius: " + this.updateRadius);
        if (this.antiXray && this.usePermission) {
            Bukkit.getLogger().warning("You have enabled permission-based Anti-Xray checking - depending on your permission plugin, this may cause performance issues");
        }
    }

    private void altItemDespawnRate() {
        String path = "alt-item-despawn-rate";
        this.altItemDespawnRateEnabled = this.getBoolean(path + ".enabled", false);
        EnumMap<Material, Integer> altItemDespawnRateMapDefault = new EnumMap<Material, Integer>(Material.class);
        altItemDespawnRateMapDefault.put(Material.COBBLESTONE, 300);
        for (Material key : altItemDespawnRateMapDefault.keySet()) {
            this.config.addDefault("world-settings.default." + path + ".items." + key, altItemDespawnRateMapDefault.get(key));
        }
        HashMap<String, Integer> rawMap = new HashMap<String, Integer>();
        try {
            ConfigurationSection mapSection = this.config.getConfigurationSection("world-settings." + this.worldName + "." + path + ".items");
            if (mapSection == null) {
                mapSection = this.config.getConfigurationSection("world-settings.default." + path + ".items");
            }
            for (String key : mapSection.getKeys(false)) {
                int val = mapSection.getInt(key);
                rawMap.put(key, val);
            }
        }
        catch (Exception e2) {
            PaperConfig.logError("alt-item-despawn-rate was malformatted");
            this.altItemDespawnRateEnabled = false;
        }
        this.altItemDespawnRateMap = new EnumMap<Material, Integer>(Material.class);
        if (!this.altItemDespawnRateEnabled) {
            return;
        }
        for (String string : rawMap.keySet()) {
            try {
                this.altItemDespawnRateMap.put(Material.valueOf((String)string), (Integer)rawMap.get(string));
            }
            catch (Exception e3) {
                PaperConfig.logError("Could not add item " + string + " to altItemDespawnRateMap: " + e3.getMessage());
            }
        }
        if (this.altItemDespawnRateEnabled) {
            for (Material material : this.altItemDespawnRateMap.keySet()) {
                PaperConfig.log("Alternative item despawn rate of " + material + ": " + this.altItemDespawnRateMap.get(material));
            }
        }
    }

    private void perPlayerMobSpawns() {
        if (PaperConfig.version < 22) {
            this.set("per-player-mob-spawns", Boolean.TRUE);
        }
        this.perPlayerMobSpawns = this.getBoolean("per-player-mob-spawns", true);
    }

    private void enderDragonsDeathAlwaysPlacesDragonEgg() {
        this.enderDragonsDeathAlwaysPlacesDragonEgg = this.getBoolean("ender-dragons-death-always-places-dragon-egg", this.enderDragonsDeathAlwaysPlacesDragonEgg);
    }

    private void setUpdatePathfindingOnBlockUpdate() {
        this.updatePathfindingOnBlockUpdate = this.getBoolean("update-pathfinding-on-block-update", this.updatePathfindingOnBlockUpdate);
    }

    private void phantomSettings() {
        this.phantomIgnoreCreative = this.getBoolean("phantoms-do-not-spawn-on-creative-players", this.phantomIgnoreCreative);
        this.phantomOnlyAttackInsomniacs = this.getBoolean("phantoms-only-attack-insomniacs", this.phantomOnlyAttackInsomniacs);
    }

    private void setMobsAlwaysCanPickUpLoot() {
        this.zombiesAlwaysCanPickUpLoot = this.getBoolean("mobs-can-always-pick-up-loot.zombies", false);
        this.skeletonsAlwaysCanPickUpLoot = this.getBoolean("mobs-can-always-pick-up-loot.skeletons", false);
        PaperConfig.log("Zombies can always pick up loot: " + this.zombiesAlwaysCanPickUpLoot + ". Skeletons can always pick up loot: " + this.skeletonsAlwaysCanPickUpLoot + ".");
    }

    private void expMergeMaxValue() {
        this.expMergeMaxValue = this.getInt("experience-merge-max-value", -1);
        PaperConfig.log("Experience Merge Max Value: " + this.expMergeMaxValue);
    }

    private void delayChunkUnloadsBy() {
        this.delayChunkUnloadsBy = PaperConfig.getSeconds(this.getString("delay-chunk-unloads-by", "10s"));
        if (this.delayChunkUnloadsBy > 0L) {
            PaperConfig.log("Delaying chunk unloads by " + this.delayChunkUnloadsBy + " seconds");
            this.delayChunkUnloadsBy *= 20L;
        }
    }

    private void allowUsingSignsInsideSpawnProtection() {
        this.allowUsingSignsInsideSpawnProtection = this.getBoolean("allow-using-signs-inside-spawn-protection", this.allowUsingSignsInsideSpawnProtection);
    }

    private void mapItemFrameCursorLimit() {
        this.mapItemFrameCursorLimit = this.getInt("map-item-frame-cursor-limit", this.mapItemFrameCursorLimit);
    }

    private void itemFrameCursorUpdateInterval() {
        this.mapItemFrameCursorUpdateInterval = this.getInt("map-item-frame-cursor-update-interval", this.mapItemFrameCursorUpdateInterval);
    }

    private void fixItemsMergingThroughWalls() {
        this.fixItemsMergingThroughWalls = this.getBoolean("fix-items-merging-through-walls", this.fixItemsMergingThroughWalls);
    }

    private void fixInvulnerableEndCrystalExploit() {
        this.fixInvulnerableEndCrystalExploit = this.getBoolean("unsupported-settings.fix-invulnerable-end-crystal-exploit", this.fixInvulnerableEndCrystalExploit);
    }

    private void showSignClickCommandFailureMessagesToPlayer() {
        this.showSignClickCommandFailureMessagesToPlayer = this.getBoolean("show-sign-click-command-failure-msgs-to-player", this.showSignClickCommandFailureMessagesToPlayer);
    }

    private void playerCrammingDamage() {
        this.allowPlayerCrammingDamage = this.getBoolean("allow-player-cramming-damage", this.allowPlayerCrammingDamage);
    }

    private void splitOverstackedLoot() {
        this.splitOverstackedLoot = this.getBoolean("split-overstacked-loot", this.splitOverstackedLoot);
    }

    private void tickRates() {
        this.config.addDefault("world-settings.default.tick-rates.sensor.villager.secondarypoisensor", (Object)40);
        this.config.addDefault("world-settings.default.tick-rates.behavior.villager.validatenearbypoi", (Object)-1);
        PaperConfig.log("Tick rates:");
        this.sensorTickRates = this.loadTickRates("sensor");
        this.behaviorTickRates = this.loadTickRates("behavior");
    }

    private void getHideItemmetaFromClients() {
        this.hideItemmetaFromClients = this.getBoolean("anticheat.obfuscation.items.hide-itemmeta", this.hideItemmetaFromClients);
        this.hideDurabilityFromClients = this.getBoolean("anticheat.obfuscation.items.hide-durability", this.hideDurabilityFromClients);
    }

    private Table<String, String, Integer> loadTickRates(String type) {
        PaperConfig.log("  " + type + ":");
        HashBasedTable table = HashBasedTable.create();
        ConfigurationSection typeSection = this.config.getConfigurationSection("world-settings." + this.worldName + ".tick-rates." + type);
        if (typeSection == null) {
            typeSection = this.config.getConfigurationSection("world-settings.default.tick-rates." + type);
        }
        if (typeSection != null) {
            for (String entity : typeSection.getKeys(false)) {
                ConfigurationSection entitySection = typeSection.getConfigurationSection(entity);
                if (entitySection == null) continue;
                PaperConfig.log("    " + entity + ":");
                for (String typeName : entitySection.getKeys(false)) {
                    if (!entitySection.isInt(typeName)) continue;
                    int tickRate = entitySection.getInt(typeName);
                    table.put((Object)entity.toLowerCase(Locale.ROOT), (Object)typeName.toLowerCase(Locale.ROOT), (Object)tickRate);
                    PaperConfig.log("      " + typeName + ": " + tickRate);
                }
            }
        }
        if (table.isEmpty()) {
            PaperConfig.log("    None configured");
        }
        return table;
    }

    private void featureSeeds() {
        this.featureSeeds.defaultReturnValue(-1L);
        boolean randomise = this.getBoolean("feature-seeds.generate-random-seeds-for-all", false);
        ConfigurationSection defaultSection = this.config.getConfigurationSection("world-settings.default.feature-seeds");
        ConfigurationSection section = this.config.getConfigurationSection("world-settings." + this.worldName + ".feature-seeds");
        IRegistry<WorldGenFeatureConfigured<?, ?>> registry = MinecraftServer.getServer().aU().d(IRegistry.aJ);
        if (section != null) {
            this.loadFeatureSeeds(section, registry);
        }
        this.loadFeatureSeeds(defaultSection, registry);
        if (randomise) {
            HashMap<CallSite, Long> randomisedSeeds = new HashMap<CallSite, Long>();
            SecureRandom random = new SecureRandom();
            for (MinecraftKey resourceLocation : registry.d()) {
                if (this.featureSeeds.containsKey((Object)resourceLocation)) continue;
                long seed = random.nextLong();
                randomisedSeeds.put((CallSite)((Object)("world-settings." + this.worldName + ".feature-seeds." + resourceLocation.a())), seed);
                this.featureSeeds.put((Object)resourceLocation, seed);
            }
            if (!randomisedSeeds.isEmpty()) {
                this.config.addDefaults(randomisedSeeds);
            }
        }
    }

    private void loadFeatureSeeds(ConfigurationSection section, IRegistry<WorldGenFeatureConfigured<?, ?>> registry) {
        for (String key : section.getKeys(false)) {
            if (!(section.get(key) instanceof Number)) continue;
            MinecraftKey location = new MinecraftKey(key);
            if (!registry.c(location)) {
                PaperConfig.logError("Invalid feature resource location: " + location);
                continue;
            }
            this.featureSeeds.putIfAbsent((Object)location, section.getLong(key));
        }
    }

    public int getBehaviorTickRate(String typeName, String entityType, int def) {
        return this.getIntOrDefault(this.behaviorTickRates, typeName, entityType, def);
    }

    public int getSensorTickRate(String typeName, String entityType, int def) {
        return this.getIntOrDefault(this.sensorTickRates, typeName, entityType, def);
    }

    private int getIntOrDefault(Table<String, String, Integer> table, String rowKey, String columnKey, int def) {
        Integer rate = (Integer)table.get((Object)columnKey, (Object)rowKey);
        return rate != null && rate > -1 ? rate : def;
    }

    private void minBlockLightForMobSpawning() {
        this.maxBlockLightForMonsterSpawning = this.getInt("monster-spawn-max-light-level", this.maxBlockLightForMonsterSpawning);
    }

    public static enum DuplicateUUIDMode {
        SAFE_REGEN,
        DELETE,
        NOTHING,
        WARN;

    }
}

