/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.io.SyncLoadFinder;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftSpawnCategory;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;

public class PaperCommand
extends Command {
    private static final String BASE_PERM = "bukkit.command.paper.";
    private static final ImmutableSet<String> SUBCOMMANDS = ImmutableSet.builder().add((Object[])new String[]{"heap", "entity", "reload", "version", "debug", "chunkinfo", "fixlight", "syncloadinfo", "dumpitem", "mobcaps", "playermobcaps"}).build();
    public static final Map<EnumCreatureType, TextColor> MOB_CATEGORY_COLORS = ImmutableMap.builder().put((Object)EnumCreatureType.a, (Object)NamedTextColor.RED).put((Object)EnumCreatureType.b, (Object)NamedTextColor.GREEN).put((Object)EnumCreatureType.c, (Object)NamedTextColor.GRAY).put((Object)EnumCreatureType.d, (Object)TextColor.color((int)7546111)).put((Object)EnumCreatureType.e, (Object)TextColor.color((int)3490278)).put((Object)EnumCreatureType.f, (Object)TextColor.color((int)28415)).put((Object)EnumCreatureType.g, (Object)TextColor.color((int)46079)).put((Object)EnumCreatureType.h, (Object)TextColor.color((int)0x636363)).build();

    public PaperCommand(String name) {
        super(name);
        this.description = "Paper related commands";
        this.usageMessage = "/paper [" + Joiner.on((String)" | ").join(SUBCOMMANDS) + "]";
        this.setPermission("bukkit.command.paper;" + Joiner.on((char)';').join((Iterable)SUBCOMMANDS.stream().map(s2 -> BASE_PERM + s2).collect(Collectors.toSet())));
    }

    private static boolean testPermission(CommandSender commandSender, String permission) {
        if (commandSender.hasPermission(BASE_PERM + permission) || commandSender.hasPermission("bukkit.command.paper")) {
            return true;
        }
        commandSender.sendMessage(Bukkit.getPermissionMessage());
        return false;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length <= 1) {
            return PaperCommand.getListMatchingLast(sender, args, SUBCOMMANDS);
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                if (args.length == 2) {
                    return PaperCommand.getListMatchingLast(sender, args, "help", "list");
                }
                if (args.length != 3) break;
                return PaperCommand.getListMatchingLast(sender, args, (String[])EntityTypes.getEntityNameList().stream().map(MinecraftKey::toString).sorted().toArray(String[]::new));
            }
            case "debug": {
                if (args.length != 2) break;
                return PaperCommand.getListMatchingLast(sender, args, "help", "chunks");
            }
            case "mobcaps": {
                return PaperCommand.getListMatchingLast(sender, args, this.suggestMobcaps(sender, args));
            }
            case "playermobcaps": {
                return PaperCommand.getListMatchingLast(sender, args, this.suggestPlayerMobcaps(sender, args));
            }
            case "chunkinfo": {
                ArrayList<String> worldNames = new ArrayList<String>();
                worldNames.add("*");
                for (World world : Bukkit.getWorlds()) {
                    worldNames.add(world.getName());
                }
                if (args.length != 2) break;
                return PaperCommand.getListMatchingLast(sender, args, worldNames);
            }
            case "syncloadinfo": {
                if (args.length != 2) break;
                return PaperCommand.getListMatchingLast(sender, args, "clear");
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] args, String ... matches) {
        return PaperCommand.getListMatchingLast(sender, args, Arrays.asList(matches));
    }

    public static boolean matches(String s2, String s1) {
        return s1.regionMatches(true, 0, s2, 0, s2.length());
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] strings, Collection<?> collection) {
        String last = strings[strings.length - 1];
        ArrayList results = Lists.newArrayList();
        if (!collection.isEmpty()) {
            for (String s1 : Iterables.transform(collection, (Function)Functions.toStringFunction())) {
                if (!PaperCommand.matches(last, s1) || !sender.hasPermission(BASE_PERM + s1) && !sender.hasPermission("bukkit.command.paper")) continue;
                results.add(s1);
            }
            if (results.isEmpty()) {
                for (Object object : collection) {
                    if (!(object instanceof MinecraftKey) || !PaperCommand.matches(last, ((MinecraftKey)object).a())) continue;
                    results.add(String.valueOf(object));
                }
            }
        }
        return results;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        if (SUBCOMMANDS.contains((Object)args[0].toLowerCase(Locale.ENGLISH)) && !PaperCommand.testPermission(sender, args[0].toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "heap": {
                this.dumpHeap(sender);
                break;
            }
            case "entity": {
                this.listEntities(sender, args);
                break;
            }
            case "reload": {
                this.doReload(sender);
                break;
            }
            case "dumpitem": {
                this.doDumpItem(sender);
                break;
            }
            case "debug": {
                this.doDebug(sender, args);
                break;
            }
            case "chunkinfo": {
                this.doChunkInfo(sender, args);
                break;
            }
            case "fixlight": {
                this.doFixLight(sender, args);
                break;
            }
            case "syncloadinfo": {
                this.doSyncLoadInfo(sender, args);
                break;
            }
            case "mobcaps": {
                this.printMobcaps(sender, args);
                break;
            }
            case "playermobcaps": {
                this.printPlayerMobcaps(sender, args);
                break;
            }
            case "ver": {
                if (!PaperCommand.testPermission(sender, "version")) break;
            }
            case "version": {
                Command ver = MinecraftServer.getServer().server.getCommandMap().getCommand("version");
                if (ver != null) {
                    ver.execute(sender, commandLabel, new String[0]);
                    break;
                }
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void doSyncLoadInfo(CommandSender sender, String[] args) {
        if (!SyncLoadFinder.ENABLED) {
            sender.sendMessage(ChatColor.RED + "This command requires the server startup flag '-Dpaper.debug-sync-loads=true' to be set.");
            return;
        }
        if (args.length > 1 && args[1].equals("clear")) {
            SyncLoadFinder.clear();
            sender.sendMessage(ChatColor.GRAY + "Sync load data cleared.");
            return;
        }
        File file = new File(new File(new File("."), "debug"), "sync-load-info" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
        file.getParentFile().mkdirs();
        sender.sendMessage(ChatColor.GREEN + "Writing sync load info to " + file.toString());
        try {
            JsonObject data = SyncLoadFinder.serialize();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent(" ");
            jsonWriter.setLenient(false);
            Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
            String fileData = stringWriter.toString();
            try (PrintStream out = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");){
                out.print(fileData);
            }
            sender.sendMessage(ChatColor.GREEN + "Successfully written sync load information!");
        }
        catch (Throwable thr) {
            sender.sendMessage(ChatColor.RED + "Failed to write sync load information");
            thr.printStackTrace();
        }
    }

    private List<String> suggestMobcaps(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> worlds = new ArrayList<String>(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
            worlds.add("*");
            return worlds;
        }
        return Collections.emptyList();
    }

    private List<String> suggestPlayerMobcaps(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> list = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                Player senderPlayer;
                if (sender instanceof Player && !(senderPlayer = (Player)sender).canSee(player)) continue;
                list.add(player.getName());
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printMobcaps(CommandSender sender, String[] args) {
        World world;
        List<World> worlds;
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"Must specify a world! ex: '/paper mobcaps world'", (TextColor)NamedTextColor.RED));
                return;
            }
            Player player = (Player)sender;
            worlds = List.of(player.getWorld());
        } else {
            if (args.length != 2) {
                sender.sendMessage((Component)Component.text((String)"Too many arguments!", (TextColor)NamedTextColor.RED));
                return;
            }
            String input = args[1];
            if (input.equals("*")) {
                worlds = Bukkit.getWorlds();
            } else {
                world = Bukkit.getWorld((String)input);
                if (world == null) {
                    sender.sendMessage((Component)Component.text((String)("'" + input + "' is not a valid world!"), (TextColor)NamedTextColor.RED));
                    return;
                }
                worlds = List.of(world);
            }
        }
        Iterator<World> iterator = worlds.iterator();
        while (iterator.hasNext()) {
            world = iterator.next();
            WorldServer level = ((CraftWorld)world).getHandle();
            SpawnerCreature.d state = level.k().l();
            int chunks = state == null ? 0 : state.a();
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Mobcaps for world: "), Component.text((String)world.getName(), (TextColor)NamedTextColor.AQUA), Component.text((String)(" (" + chunks + " spawnable chunks)"))}));
            sender.sendMessage(this.buildMobcapsComponent(category -> {
                if (state == null) {
                    return 0;
                }
                return state.b().getOrDefault(category, 0);
            }, category -> SpawnerCreature.globalLimitForCategory(level, category, chunks)));
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printPlayerMobcaps(CommandSender sender, String[] args) {
        Player player;
        if (args.length == 1) {
            Player pl;
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"Must specify a player! ex: '/paper playermobcount playerName'", (TextColor)NamedTextColor.RED));
                return;
            }
            player = pl = (Player)sender;
        } else {
            if (args.length != 2) {
                sender.sendMessage((Component)Component.text((String)"Too many arguments!", (TextColor)NamedTextColor.RED));
                return;
            }
            String input = args[1];
            player = Bukkit.getPlayerExact((String)input);
            if (player == null) {
                sender.sendMessage((Component)Component.text((String)("Could not find player named '" + input + "'"), (TextColor)NamedTextColor.RED));
                return;
            }
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        WorldServer level = serverPlayer.x();
        if (!level.paperConfig.perPlayerMobSpawns) {
            sender.sendMessage((Component)Component.text((String)"Use '/paper mobcaps' for worlds where per-player mob spawning is disabled.", (TextColor)NamedTextColor.RED));
            return;
        }
        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Mobcaps for player: "), Component.text((String)player.getName(), (TextColor)NamedTextColor.GREEN)}));
        sender.sendMessage(this.buildMobcapsComponent(category -> level.K.a.getMobCountNear(serverPlayer, (EnumCreatureType)category), category -> level.getWorld().getSpawnLimitUnsafe(CraftSpawnCategory.toBukkit(category))));
    }

    private Component buildMobcapsComponent(ToIntFunction<EnumCreatureType> countGetter, ToIntFunction<EnumCreatureType> limitGetter) {
        return (Component)MOB_CATEGORY_COLORS.entrySet().stream().map(entry -> {
            EnumCreatureType category = (EnumCreatureType)entry.getKey();
            TextColor color = (TextColor)entry.getValue();
            Component categoryHover = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Entity types in category ", (TextColor)TextColor.color((int)0xE0E0E0)), Component.text((String)category.a(), (TextColor)color), Component.text((char)':', (TextColor)NamedTextColor.GRAY), Component.newline(), Component.newline(), (ComponentLike)IRegistry.W.e().stream().filter(it -> ((EntityTypes)it.getValue()).f() == category).map(it -> Component.translatable((String)((EntityTypes)it.getValue()).g())).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))});
            BuildableComponent categoryComponent = ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  " + category.a()).color(color)).hoverEvent((HoverEventSource)categoryHover)).build();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(new Component[]{categoryComponent, Component.text((String)": ", (TextColor)NamedTextColor.GRAY)});
            int limit = limitGetter.applyAsInt(category);
            if (limit != -1) {
                builder.append(new Component[]{Component.text((int)countGetter.applyAsInt(category)), Component.text((String)"/", (TextColor)NamedTextColor.GRAY), Component.text((int)limit)});
            } else {
                builder.append(((TextComponent.Builder)Component.text().append(new Component[]{Component.text((char)'n'), Component.text((String)"/", (TextColor)NamedTextColor.GRAY), Component.text((char)'a')})).hoverEvent((HoverEventSource)Component.text((String)"This category does not naturally spawn.")));
            }
            return builder;
        }).map(ComponentLike::asComponent).collect(Component.toComponent((Component)Component.newline()));
    }

    private void doChunkInfo(CommandSender sender, String[] args) {
        ArrayList<World> worlds;
        if (args.length < 2 || args[1].equals("*")) {
            worlds = Bukkit.getWorlds();
        } else {
            worlds = new ArrayList<World>(args.length - 1);
            for (int i2 = 1; i2 < args.length; ++i2) {
                World world = Bukkit.getWorld((String)args[i2]);
                if (world == null) {
                    sender.sendMessage(ChatColor.RED + "World '" + args[i2] + "' is invalid");
                    return;
                }
                worlds.add(world);
            }
        }
        int accumulatedTotal = 0;
        int accumulatedInactive = 0;
        int accumulatedBorder = 0;
        int accumulatedTicking = 0;
        int accumulatedEntityTicking = 0;
        for (World bukkitWorld : worlds) {
            WorldServer world = ((CraftWorld)bukkitWorld).getHandle();
            int total = 0;
            int inactive = 0;
            int border = 0;
            int ticking = 0;
            int entityTicking = 0;
            block8: for (PlayerChunk chunk : world.k().a.updatingChunks.getUpdatingMap().values()) {
                if (chunk.getFullChunkUnchecked() == null) continue;
                ++total;
                PlayerChunk.State state = PlayerChunk.c(chunk.k());
                switch (state) {
                    case a: {
                        ++inactive;
                        continue block8;
                    }
                    case b: {
                        ++border;
                        continue block8;
                    }
                    case c: {
                        ++ticking;
                        continue block8;
                    }
                    case d: {
                        ++entityTicking;
                        continue block8;
                    }
                }
            }
            accumulatedTotal += total;
            accumulatedInactive += inactive;
            accumulatedBorder += border;
            accumulatedTicking += ticking;
            accumulatedEntityTicking += entityTicking;
            sender.sendMessage(ChatColor.BLUE + "Chunks in " + ChatColor.GREEN + bukkitWorld.getName() + ChatColor.DARK_AQUA + ":");
            sender.sendMessage(ChatColor.BLUE + "Total: " + ChatColor.DARK_AQUA + total + ChatColor.BLUE + " Inactive: " + ChatColor.DARK_AQUA + inactive + ChatColor.BLUE + " Border: " + ChatColor.DARK_AQUA + border + ChatColor.BLUE + " Ticking: " + ChatColor.DARK_AQUA + ticking + ChatColor.BLUE + " Entity: " + ChatColor.DARK_AQUA + entityTicking);
        }
        if (worlds.size() > 1) {
            sender.sendMessage(ChatColor.BLUE + "Chunks in " + ChatColor.GREEN + "all listed worlds" + ChatColor.DARK_AQUA + ":");
            sender.sendMessage(ChatColor.BLUE + "Total: " + ChatColor.DARK_AQUA + accumulatedTotal + ChatColor.BLUE + " Inactive: " + ChatColor.DARK_AQUA + accumulatedInactive + ChatColor.BLUE + " Border: " + ChatColor.DARK_AQUA + accumulatedBorder + ChatColor.BLUE + " Ticking: " + ChatColor.DARK_AQUA + accumulatedTicking + ChatColor.BLUE + " Entity: " + ChatColor.DARK_AQUA + accumulatedEntityTicking);
        }
    }

    private void doDebug(CommandSender sender, String[] args) {
        String debugType;
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /paper debug [chunks] help for more information on a specific command");
            return;
        }
        switch (debugType = args[1].toLowerCase(Locale.ENGLISH)) {
            case "chunks": {
                if (args.length >= 3 && args[2].toLowerCase(Locale.ENGLISH).equals("help")) {
                    sender.sendMessage(ChatColor.RED + "Use /paper debug chunks to dump loaded chunk information to a file");
                    break;
                }
                File file = new File(new File(new File("."), "debug"), "chunks-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
                sender.sendMessage(ChatColor.GREEN + "Writing chunk information dump to " + file.toString());
                try {
                    MCUtil.dumpChunks(file);
                    sender.sendMessage(ChatColor.GREEN + "Successfully written chunk information!");
                }
                catch (Throwable thr) {
                    MinecraftServer.q.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage(ChatColor.RED + "Failed to dump chunk information, see console");
                }
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Use /paper debug [chunks] help for more information on a specific command");
                return;
            }
        }
    }

    private void listEntities(CommandSender sender, String[] args) {
        if (args.length < 2 || args[1].toLowerCase(Locale.ENGLISH).equals("help")) {
            sender.sendMessage(ChatColor.RED + "Use /paper entity [list] help for more information on a specific command.");
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "list": {
                String worldName;
                String filter = "*";
                if (args.length > 2) {
                    if (args[2].toLowerCase(Locale.ENGLISH).equals("help")) {
                        sender.sendMessage(ChatColor.RED + "Use /paper entity list [filter] [worldName] to get entity info that matches the optional filter.");
                        return;
                    }
                    filter = args[2];
                }
                String cleanfilter = filter.replace("?", ".?").replace("*", ".*?");
                Set names = EntityTypes.getEntityNameList().stream().filter(n2 -> n2.toString().matches(cleanfilter)).collect(Collectors.toSet());
                if (names.isEmpty()) {
                    sender.sendMessage(ChatColor.RED + "Invalid filter, does not match any entities. Use /paper entity list for a proper list");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                if (args.length > 3) {
                    worldName = args[3];
                } else if (sender instanceof Player) {
                    worldName = ((Player)sender).getWorld().getName();
                } else {
                    sender.sendMessage(ChatColor.RED + "Please specify the name of a world");
                    sender.sendMessage(ChatColor.RED + "To do so without a filter, specify '*' as the filter");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                HashMap list = Maps.newHashMap();
                World bukkitWorld = Bukkit.getWorld((String)worldName);
                if (bukkitWorld == null) {
                    sender.sendMessage(ChatColor.RED + "Could not load world for " + worldName + ". Please select a valid world.");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                WorldServer world = ((CraftWorld)Bukkit.getWorld((String)worldName)).getHandle();
                HashMap nonEntityTicking = Maps.newHashMap();
                ChunkProviderServer chunkProviderServer = world.k();
                world.B().forEach(e2 -> {
                    MinecraftKey key = e2.getMinecraftKey();
                    MutablePair info = list.computeIfAbsent(key, k2 -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                    ChunkCoordIntPair chunk = e2.cZ();
                    MutablePair mutablePair = info;
                    Integer n2 = (Integer)mutablePair.left;
                    mutablePair.left = (Integer)mutablePair.left + 1;
                    ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
                    if (!chunkProviderServer.isPositionTicking((Entity)e2)) {
                        nonEntityTicking.merge(key, 1, Integer::sum);
                    }
                });
                if (names.size() == 1) {
                    MinecraftKey name = (MinecraftKey)names.iterator().next();
                    Pair info = (Pair)list.get(name);
                    int nonTicking = nonEntityTicking.getOrDefault(name, 0);
                    if (info == null) {
                        sender.sendMessage(ChatColor.RED + "No entities found.");
                        return;
                    }
                    sender.sendMessage("Entity: " + name + " Total Ticking: " + ((Integer)info.getLeft() - nonTicking) + ", Total Non-Ticking: " + nonTicking);
                    ((Map)info.getRight()).entrySet().stream().sorted((a2, b2) -> !((Integer)a2.getValue()).equals(b2.getValue()) ? (Integer)b2.getValue() - (Integer)a2.getValue() : ((ChunkCoordIntPair)a2.getKey()).toString().compareTo(((ChunkCoordIntPair)b2.getKey()).toString())).limit(10L).forEach(e2 -> sender.sendMessage("  " + e2.getValue() + ": " + ((ChunkCoordIntPair)e2.getKey()).c + ", " + ((ChunkCoordIntPair)e2.getKey()).d + (chunkProviderServer.a(((ChunkCoordIntPair)e2.getKey()).a()) ? " (Ticking)" : " (Non-Ticking)")));
                    break;
                }
                List<Pair> info = list.entrySet().stream().filter(e2 -> names.contains(e2.getKey())).map(e2 -> Pair.of((Object)((MinecraftKey)e2.getKey()), (Object)((Integer)((MutablePair)e2.getValue()).left))).sorted((a2, b2) -> !((Integer)a2.getRight()).equals(b2.getRight()) ? (Integer)b2.getRight() - (Integer)a2.getRight() : ((MinecraftKey)a2.getKey()).toString().compareTo(((MinecraftKey)b2.getKey()).toString())).collect(Collectors.toList());
                if (info == null || info.size() == 0) {
                    sender.sendMessage(ChatColor.RED + "No entities found.");
                    return;
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                int nonTickingCount = nonEntityTicking.values().stream().mapToInt(Integer::intValue).sum();
                sender.sendMessage("Total Ticking: " + (count - nonTickingCount) + ", Total Non-Ticking: " + nonTickingCount);
                info.forEach(e2 -> {
                    int nonTicking = nonEntityTicking.getOrDefault(e2.getKey(), 0);
                    sender.sendMessage("  " + ((Integer)e2.getValue() - nonTicking) + " (" + nonTicking + ") : " + e2.getKey());
                });
                sender.sendMessage("* First number is ticking entities, second number is non-ticking entities");
            }
        }
    }

    private void dumpHeap(CommandSender sender) {
        Path dir = Paths.get("./dumps", new String[0]);
        String name = "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now());
        Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.YELLOW + "Writing JVM heap data..."));
        Path file = CraftServer.dumpHeap(dir, name);
        if (file != null) {
            Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.GREEN + "Heap dump saved to " + file));
        } else {
            Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.RED + "Failed to write heap dump, see sever log for details"));
        }
    }

    private void doReload(CommandSender sender) {
        Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.RED + "Please note that this command is not supported and may cause issues."));
        Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.RED + "If you encounter any issues please use the /stop command to restart your server."));
        MinecraftServer console = MinecraftServer.getServer();
        PaperConfig.init((File)console.options.valueOf("paper-settings"));
        for (WorldServer world : console.F()) {
            world.paperConfig.init();
        }
        ++console.server.reloadCount;
        Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.GREEN + "Paper config reload complete."));
    }

    private void doDumpItem(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command");
            return;
        }
        ItemStack itemInHand = ((CraftPlayer)sender).getItemInHand();
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy(itemInHand);
        NBTTagCompound tag = itemStack.t();
        if (tag != null) {
            Component nbtComponent = PaperAdventure.asAdventure(GameProfileSerializer.c((NBTBase)tag));
            Bukkit.getConsoleSender().sendMessage(nbtComponent);
            sender.sendMessage(nbtComponent);
        } else {
            sender.sendMessage("Item does not have NBT");
        }
    }

    private void starlightFixLight(EntityPlayer sender, WorldServer world, LightEngineThreaded lightengine, int radius) {
        long start = System.nanoTime();
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(MCUtil.getSpiralOutChunks(sender.cW(), radius));
        int[] pending = new int[1];
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkPos2 = (ChunkCoordIntPair)iterator.next();
            IChunkAccess chunk = world.k().getChunkAtImmediately(chunkPos2.c, chunkPos2.d);
            if (chunk == null || !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
                iterator.remove();
                continue;
            }
            pending[0] = pending[0] + 1;
        }
        int[] relitChunks = new int[1];
        lightengine.relight(chunks, chunkPos -> {
            relitChunks[0] = relitChunks[0] + 1;
            sender.getBukkitEntity().sendMessage(ChatColor.BLUE + "Relit chunk " + ChatColor.DARK_AQUA + chunkPos + ChatColor.BLUE + ", progress: " + ChatColor.DARK_AQUA + (int)Math.round(100.0 * (double)relitChunks[0] / (double)pending[0]) + "%");
        }, totalRelit -> {
            long end = System.nanoTime();
            long diff = Math.round(1.0E-6 * (double)(end - start));
            sender.getBukkitEntity().sendMessage(ChatColor.BLUE + "Relit " + ChatColor.DARK_AQUA + totalRelit + ChatColor.BLUE + " chunks. Took " + ChatColor.DARK_AQUA + diff + "ms");
        });
        sender.getBukkitEntity().sendMessage(ChatColor.BLUE + "Relighting " + ChatColor.DARK_AQUA + pending[0] + ChatColor.BLUE + " chunks");
    }

    private void doFixLight(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command");
            return;
        }
        int radius = 2;
        if (args.length > 1) {
            try {
                radius = Math.min(32, Integer.parseInt(args[1]));
            }
            catch (Exception e2) {
                sender.sendMessage("Not a number");
                return;
            }
        }
        CraftPlayer player = (CraftPlayer)sender;
        EntityPlayer handle = player.getHandle();
        WorldServer world = (WorldServer)handle.s;
        LightEngineThreaded lightengine = world.k().a();
        this.starlightFixLight(handle, world, lightengine, radius);
    }

    private void updateLight(CommandSender sender, WorldServer world, LightEngineThreaded lightengine, Deque<ChunkCoordIntPair> queue) {
        ChunkCoordIntPair coord = queue.poll();
        if (coord == null) {
            sender.sendMessage("All Chunks Light updated");
            return;
        }
        world.k().getChunkAtAsynchronously(coord.c, coord.d, false, false).whenCompleteAsync((either, ex) -> {
            if (ex != null) {
                sender.sendMessage("Error loading chunk " + coord);
                this.updateLight(sender, world, lightengine, queue);
                return;
            }
            Chunk chunk = either.left().orElse(null);
            if (chunk == null) {
                this.updateLight(sender, world, lightengine, queue);
                return;
            }
            lightengine.a(world.paperConfig.lightQueueSize + 4096);
            sender.sendMessage("Updating Light " + coord);
            int cx = chunk.f().c << 4;
            int cz = chunk.f().d << 4;
            for (int y2 = 0; y2 < world.v_(); ++y2) {
                for (int x2 = 0; x2 < 16; ++x2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        BlockPosition pos = new BlockPosition(cx + x2, y2, cz + z2);
                        lightengine.a(pos);
                    }
                }
            }
            lightengine.a();
            PlayerChunk visibleChunk = world.k().a.b(chunk.coordinateKey);
            if (visibleChunk != null) {
                world.k().a.addLightTask(visibleChunk, () -> MinecraftServer.getServer().processQueue.add(() -> {
                    visibleChunk.a(new PacketPlayOutLightUpdate(chunk.f(), lightengine, null, null, true), false);
                    this.updateLight(sender, world, lightengine, queue);
                }));
            } else {
                this.updateLight(sender, world, lightengine, queue);
            }
            lightengine.a(world.paperConfig.lightQueueSize);
        }, (Executor)MinecraftServer.getServer());
    }
}

