/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class MSPTCommand
extends Command {
    private static final DecimalFormat DF = new DecimalFormat("########0.0");

    public MSPTCommand(String name) {
        super(name);
        this.description = "View server tick times";
        this.usageMessage = "/mspt";
        this.setPermission("bukkit.command.mspt");
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        MinecraftServer server = MinecraftServer.getServer();
        ArrayList<String> times = new ArrayList<String>();
        times.addAll(MSPTCommand.eval(server.tickTimes5s.getTimes()));
        times.addAll(MSPTCommand.eval(server.tickTimes10s.getTimes()));
        times.addAll(MSPTCommand.eval(server.tickTimes60s.getTimes()));
        sender.sendMessage("\u00a76Server tick times \u00a7e(\u00a77avg\u00a7e/\u00a77min\u00a7e/\u00a77max\u00a7e)\u00a76 from last 5s\u00a77,\u00a76 10s\u00a77,\u00a76 1m\u00a7e:");
        sender.sendMessage(String.format("\u00a76\u25f4 %s\u00a77/%s\u00a77/%s\u00a7e, %s\u00a77/%s\u00a77/%s\u00a7e, %s\u00a77/%s\u00a77/%s", times.toArray()));
        return true;
    }

    private static List<String> eval(long[] times) {
        long min = Integer.MAX_VALUE;
        long max = 0L;
        long total = 0L;
        for (long value : times) {
            if (value > 0L && value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            total += value;
        }
        double avgD = (double)total / (double)times.length * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        return Arrays.asList(MSPTCommand.getColor(avgD), MSPTCommand.getColor(minD), MSPTCommand.getColor(maxD));
    }

    private static String getColor(double avg) {
        return "\u00a7" + (avg >= 50.0 ? "c" : (avg >= 40.0 ? "e" : "a")) + DF.format(avg);
    }
}

