/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.timings.TimingsReportListener;
import co.aikar.util.JSONUtil;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class TimingsExport
extends Thread {
    private final TimingsReportListener listeners;
    private final Map out;
    private final TimingHistory[] history;
    private static long lastReport = 0L;

    private TimingsExport(TimingsReportListener listeners, Map out, TimingHistory[] history) {
        super("Timings paste thread");
        this.listeners = listeners;
        this.out = out;
        this.history = history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportTimings() {
        Map groupData;
        if (Timings.requestingReport.isEmpty()) {
            return;
        }
        TimingsReportListener listeners = new TimingsReportListener(Timings.requestingReport);
        listeners.addConsoleIfNeeded();
        Timings.requestingReport.clear();
        long now = System.currentTimeMillis();
        long lastReportDiff = now - lastReport;
        if (lastReportDiff < 60000L) {
            listeners.sendMessage(ChatColor.RED + "Please wait at least 1 minute in between Timings reports. (" + (int)((60000L - lastReportDiff) / 1000L) + " seconds)");
            listeners.done();
            return;
        }
        long lastStartDiff = now - TimingsManager.timingStart;
        if (lastStartDiff < 180000L) {
            listeners.sendMessage(ChatColor.RED + "Please wait at least 3 minutes before generating a Timings report. Unlike Timings v1, v2 benefits from longer timings and is not as useful with short timings. (" + (int)((180000L - lastStartDiff) / 1000L) + " seconds)");
            listeners.done();
            return;
        }
        listeners.sendMessage(ChatColor.GREEN + "Preparing Timings Report...");
        lastReport = now;
        Map parent = JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"version", (Object)Bukkit.getVersion()), JSONUtil.pair((String)"maxplayers", (Object)Bukkit.getMaxPlayers()), JSONUtil.pair((String)"start", (Object)(TimingsManager.timingStart / 1000L)), JSONUtil.pair((String)"end", (Object)(System.currentTimeMillis() / 1000L)), JSONUtil.pair((String)"online-mode", (Object)Bukkit.getServer().getOnlineMode()), JSONUtil.pair((String)"sampletime", (Object)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L)), JSONUtil.pair((String)"datapacks", (Object)JSONUtil.toArrayMapper(MinecraftServer.getServer().az().e(), pack -> ChatColor.stripColor((String)CraftChatMessage.fromComponent(pack.a(true)))))});
        if (!TimingsManager.privacy) {
            JSONUtil.appendObjectData((Map)parent, (JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"server", (Object)Bukkit.getUnsafe().getTimingsServerName()), JSONUtil.pair((String)"motd", (Object)Bukkit.getServer().getMotd()), JSONUtil.pair((String)"icon", (Object)Bukkit.getServer().getServerIcon().getData())});
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean osInfo = ManagementFactory.getOperatingSystemMXBean();
        HardwareAbstractionLayer hardwareInfo = new SystemInfo().getHardware();
        parent.put("system", JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"timingcost", (Object)TimingsExport.getCost()), JSONUtil.pair((String)"loadavg", (Object)osInfo.getSystemLoadAverage()), JSONUtil.pair((String)"name", (Object)System.getProperty("os.name")), JSONUtil.pair((String)"version", (Object)System.getProperty("os.version")), JSONUtil.pair((String)"jvmversion", (Object)System.getProperty("java.version")), JSONUtil.pair((String)"jvmvendor", (Object)System.getProperty("java.vendor")), JSONUtil.pair((String)"jvmvendorversion", (Object)System.getProperty("java.vendor.version")), JSONUtil.pair((String)"arch", (Object)System.getProperty("os.arch")), JSONUtil.pair((String)"maxmem", (Object)runtime.maxMemory()), JSONUtil.pair((String)"memory", (Object)JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().toString()), JSONUtil.pair((String)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().toString()), JSONUtil.pair((String)"finalizing", (Object)ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount())})), JSONUtil.pair((String)"cpu", (Object)runtime.availableProcessors()), JSONUtil.pair((String)"cpuname", (Object)hardwareInfo.getProcessor().getProcessorIdentifier().getName().trim()), JSONUtil.pair((String)"runtime", (Object)runtimeBean.getUptime()), JSONUtil.pair((String)"flags", (Object)StringUtils.join(runtimeBean.getInputArguments(), (String)" ")), JSONUtil.pair((String)"gc", (Object)JSONUtil.toObjectMapper(ManagementFactory.getGarbageCollectorMXBeans(), input -> JSONUtil.pair((String)input.getName(), (Object)JSONUtil.toArray((Object[])new Object[]{input.getCollectionCount(), input.getCollectionTime()}))))}));
        parent.put("worlds", JSONUtil.toObjectMapper(MinecraftServer.getServer().F(), world -> {
            if (world.getWorld().getName().equals("worldeditregentempworld")) {
                return null;
            }
            return JSONUtil.pair((String)world.getWorld().getName(), (Object)JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"gamerules", (Object)JSONUtil.toObjectMapper((Object[])world.getWorld().getGameRules(), rule -> JSONUtil.pair((String)rule, (Object)world.getWorld().getGameRuleValue((String)rule)))), JSONUtil.pair((String)"ticking-distance", (Object)world.k().a.playerChunkManager.getTargetTickViewDistance()), JSONUtil.pair((String)"no-ticking-distance", (Object)world.k().a.playerChunkManager.getTargetNoTickViewDistance()), JSONUtil.pair((String)"sending-distance", (Object)world.k().a.playerChunkManager.getTargetSendDistance())}));
        }));
        HashSet tileEntityTypeSet = Sets.newHashSet();
        HashSet entityTypeSet = Sets.newHashSet();
        int size = TimingsManager.HISTORY.size();
        TimingHistory[] history = new TimingHistory[size + 1];
        int i2 = 0;
        for (TimingHistory timingHistory : TimingsManager.HISTORY) {
            tileEntityTypeSet.addAll(timingHistory.tileEntityTypeSet);
            entityTypeSet.addAll(timingHistory.entityTypeSet);
            history[i2++] = timingHistory;
        }
        history[i2] = new TimingHistory();
        tileEntityTypeSet.addAll(history[i2].tileEntityTypeSet);
        entityTypeSet.addAll(history[i2].entityTypeSet);
        Map handlers = JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[0]);
        Map map = TimingIdentifier.GROUP_MAP;
        synchronized (map) {
            for (TimingIdentifier.TimingGroup group2 : TimingIdentifier.GROUP_MAP.values()) {
                List list = group2.handlers;
                synchronized (list) {
                    for (TimingHandler id : group2.handlers) {
                        if (!id.isTimed() && !id.isSpecial()) continue;
                        String name = id.identifier.name;
                        if (name.startsWith("##")) {
                            name = name.substring(3);
                        }
                        handlers.put(id.id, JSONUtil.toArray((Object[])new Object[]{group2.id, name}));
                    }
                }
            }
            groupData = JSONUtil.toObjectMapper(TimingIdentifier.GROUP_MAP.values(), group -> JSONUtil.pair((long)group.id, (Object)group.name));
        }
        parent.put("idmap", JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"groups", (Object)groupData), JSONUtil.pair((String)"handlers", (Object)handlers), JSONUtil.pair((String)"worlds", (Object)JSONUtil.toObjectMapper(TimingHistory.worldMap.entrySet(), input -> JSONUtil.pair((long)((Integer)input.getValue()).intValue(), input.getKey()))), JSONUtil.pair((String)"tileentity", (Object)JSONUtil.toObjectMapper((Iterable)tileEntityTypeSet, input -> JSONUtil.pair((long)input.ordinal(), (Object)input.name()))), JSONUtil.pair((String)"entity", (Object)JSONUtil.toObjectMapper((Iterable)entityTypeSet, input -> JSONUtil.pair((long)input.ordinal(), (Object)input.name())))}));
        parent.put("plugins", JSONUtil.toObjectMapper((Object[])Bukkit.getPluginManager().getPlugins(), plugin -> JSONUtil.pair((String)plugin.getName(), (Object)JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"version", (Object)plugin.getDescription().getVersion()), JSONUtil.pair((String)"description", (Object)String.valueOf(plugin.getDescription().getDescription()).trim()), JSONUtil.pair((String)"website", (Object)plugin.getDescription().getWebsite()), JSONUtil.pair((String)"authors", (Object)StringUtils.join((Collection)plugin.getDescription().getAuthors(), (String)", "))}))));
        parent.put("config", JSONUtil.createObject((JSONUtil.JSONPair[])new JSONUtil.JSONPair[]{JSONUtil.pair((String)"spigot", (Object)TimingsExport.mapAsJSON((ConfigurationSection)Bukkit.spigot().getSpigotConfig(), null)), JSONUtil.pair((String)"bukkit", (Object)TimingsExport.mapAsJSON((ConfigurationSection)Bukkit.spigot().getBukkitConfig(), null)), JSONUtil.pair((String)"paper", (Object)TimingsExport.mapAsJSON((ConfigurationSection)Bukkit.spigot().getPaperConfig(), null))}));
        new TimingsExport(listeners, parent, history).start();
    }

    static long getCost() {
        int passes = 100;
        TimingHandler SAMPLER1 = Timings.ofSafe((String)"Timings Sampler 1");
        TimingHandler SAMPLER2 = Timings.ofSafe((String)"Timings Sampler 2");
        TimingHandler SAMPLER3 = Timings.ofSafe((String)"Timings Sampler 3");
        TimingHandler SAMPLER4 = Timings.ofSafe((String)"Timings Sampler 4");
        TimingHandler SAMPLER5 = Timings.ofSafe((String)"Timings Sampler 5");
        TimingHandler SAMPLER6 = Timings.ofSafe((String)"Timings Sampler 6");
        long start = System.nanoTime();
        for (int i2 = 0; i2 < passes; ++i2) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER3.stopTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    private static JSONObject mapAsJSON(ConfigurationSection config, String parentKey) {
        JSONObject object = new JSONObject();
        for (String key : config.getKeys(false)) {
            Object fullKey = parentKey != null ? parentKey + "." + key : key;
            if (((String)fullKey).equals("database") || ((String)fullKey).equals("settings.bungeecord-addresses") || TimingsManager.hiddenConfigs.contains(fullKey) || key.startsWith("seed-") || key.equals("worldeditregentempworld") || key.equals("feature-seeds")) continue;
            Object val = config.get(key);
            object.put((Object)key, TimingsExport.valAsJSON(val, (String)fullKey));
        }
        return object;
    }

    private static Object valAsJSON(Object val, String parentKey) {
        if (!(val instanceof MemorySection)) {
            if (val instanceof List) {
                Iterable v2 = (Iterable)val;
                return JSONUtil.toArrayMapper((Iterable)v2, input -> TimingsExport.valAsJSON(input, parentKey));
            }
            return String.valueOf(val);
        }
        return TimingsExport.mapAsJSON((ConfigurationSection)val, parentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.out.put("data", JSONUtil.toArrayMapper((Object[])this.history, TimingHistory::export));
        String response = null;
        String timingsURL = null;
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(TimingsManager.url + "post").openConnection();
            con.setDoOutput(true);
            String hostName = "BrokenHost";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            con.setRequestProperty("User-Agent", "Paper/" + Bukkit.getUnsafe().getTimingsServerName() + "/" + hostName);
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(false);
            GZIPOutputStream request = new GZIPOutputStream(con.getOutputStream()){
                {
                    this.def.setLevel(7);
                }
            };
            ((OutputStream)request).write(JSONValue.toJSONString((Object)this.out).getBytes("UTF-8"));
            ((OutputStream)request).close();
            response = this.getResponse(con);
            if (con.getResponseCode() != 302) {
                this.listeners.sendMessage(ChatColor.RED + "Upload Error: " + con.getResponseCode() + ": " + con.getResponseMessage());
                this.listeners.sendMessage(ChatColor.RED + "Check your logs for more information");
                if (response != null) {
                    Bukkit.getLogger().log(Level.SEVERE, response);
                }
                this.listeners.done(timingsURL);
                return;
            }
            timingsURL = con.getHeaderField("Location");
            this.listeners.sendMessage(ChatColor.GREEN + "View Timings Report: " + timingsURL);
            if (response != null && !response.isEmpty()) {
                Bukkit.getLogger().log(Level.INFO, "Timing Response: " + response);
            }
            this.listeners.done(timingsURL);
        }
        catch (IOException ex) {
            this.listeners.sendMessage(ChatColor.RED + "Error uploading timings, check your logs for more information");
            if (response != null) {
                Bukkit.getLogger().log(Level.SEVERE, response);
            }
            Bukkit.getLogger().log(Level.SEVERE, "Could not paste timings", ex);
        }
        finally {
            this.listeners.done(timingsURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = null;){
            int bytesRead;
            is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b2 = new byte[1024];
            while ((bytesRead = is.read(b2)) != -1) {
                bos.write(b2, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
    }
}

