/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int STARLIGHT_LIGHT_VERSION = 6;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static void saveLightHook(World world, IChunkAccess chunk, NBTTagCompound nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + chunk.f() + ", chunk light will be recalculated on its next load", (Throwable)ex);
        }
    }

    private static void saveLightHookReal(World world, IChunkAccess chunk, NBTTagCompound tag) {
        int i2;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        SWMRNibbleArray[] blockNibbles = chunk.getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.getSkyNibbles();
        boolean bl = lit = chunk.v() || !(world instanceof WorldServer);
        if (lit) {
            tag.a("isLightOn", false);
        }
        ChunkStatus status = ChunkStatus.a(tag.l("Status"));
        NBTTagCompound[] sections = new NBTTagCompound[maxSection - minSection + 1];
        NBTTagList sectionsStored = tag.c("sections", 10);
        for (i2 = 0; i2 < sectionsStored.size(); ++i2) {
            NBTTagCompound sectionStored = sectionsStored.a(i2);
            byte k2 = sectionStored.f("Y");
            sectionStored.r("BlockLight");
            sectionStored.r("SkyLight");
            if (sectionStored.f()) continue;
            sections[k2 - minSection] = sectionStored;
        }
        if (lit && status.b(ChunkStatus.l)) {
            for (i2 = minSection; i2 <= maxSection; ++i2) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i2 - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i2 - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                NBTTagCompound section = sections[i2 - minSection];
                if (section == null) {
                    section = new NBTTagCompound();
                    section.a("Y", (byte)i2);
                    sections[i2 - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.a("BlockLight", blockNibble.data);
                    }
                    section.a(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.a("SkyLight", skyNibble.data);
                }
                section.a(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (NBTTagCompound section : sections) {
            if (section == null) continue;
            sectionsStored.add(section);
        }
        tag.a("sections", sectionsStored);
        if (lit) {
            tag.a(STARLIGHT_VERSION_TAG, 6);
        }
    }

    public static void loadLightHook(World world, ChunkCoordIntPair pos, NBTTagCompound tag, IChunkAccess into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to load light for chunk " + pos + ", light will be recalculated", (Throwable)ex);
        }
    }

    private static void loadLightHookReal(World world, ChunkCoordIntPair pos, NBTTagCompound tag, IChunkAccess into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        into.b(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        boolean lit = tag.c("isLightOn") != null && tag.h(STARLIGHT_VERSION_TAG) == 6;
        boolean canReadSky = world.q_().a();
        ChunkStatus status = ChunkStatus.a(tag.l("Status"));
        if (lit && status.b(ChunkStatus.l)) {
            NBTTagList sections = tag.c("sections", 10);
            for (int i2 = 0; i2 < sections.size(); ++i2) {
                NBTTagCompound sectionData = sections.a(i2);
                byte y2 = sectionData.f("Y");
                blockNibbles[y2 - minSection] = sectionData.b("BlockLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m("BlockLight").clone(), sectionData.h(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.h(BLOCKLIGHT_STATE_TAG));
                if (!canReadSky) continue;
                skyNibbles[y2 - minSection] = sectionData.b("SkyLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m("SkyLight").clone(), sectionData.h(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.h(SKYLIGHT_STATE_TAG));
            }
        }
        into.setBlockNibbles(blockNibbles);
        into.setSkyNibbles(skyNibbles);
        into.b(lit);
    }

    private SaveUtil() {
    }
}

