/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import java.util.ArrayDeque;
import java.util.Arrays;
import net.minecraft.world.level.chunk.NibbleArray;

public final class SWMRNibbleArray {
    protected static final int INIT_STATE_NULL = 0;
    protected static final int INIT_STATE_UNINIT = 1;
    protected static final int INIT_STATE_INIT = 2;
    protected static final int INIT_STATE_HIDDEN = 3;
    public static final int ARRAY_SIZE = 2048;
    static final ThreadLocal<ArrayDeque<byte[]>> WORKING_BYTES_POOL = ThreadLocal.withInitial(ArrayDeque::new);
    protected int stateUpdating;
    protected volatile int stateVisible;
    protected byte[] storageUpdating;
    protected boolean updatingDirty;
    protected volatile byte[] storageVisible;

    private static byte[] allocateBytes() {
        byte[] inPool = WORKING_BYTES_POOL.get().pollFirst();
        if (inPool != null) {
            return inPool;
        }
        return new byte[2048];
    }

    private static void freeBytes(byte[] bytes) {
        WORKING_BYTES_POOL.get().addFirst(bytes);
    }

    public static SWMRNibbleArray fromVanilla(NibbleArray nibble) {
        if (nibble == null) {
            return new SWMRNibbleArray(null, true);
        }
        if (nibble.c()) {
            return new SWMRNibbleArray();
        }
        return new SWMRNibbleArray((byte[])nibble.a().clone());
    }

    public SWMRNibbleArray() {
        this(null, false);
    }

    public SWMRNibbleArray(byte[] bytes) {
        this(bytes, false);
    }

    public SWMRNibbleArray(byte[] bytes, boolean isNullNibble) {
        if (bytes != null && bytes.length != 2048) {
            throw new IllegalArgumentException("Data of wrong length: " + bytes.length);
        }
        this.stateUpdating = bytes == null ? (isNullNibble ? 0 : 1) : 2;
        this.stateVisible = this.stateUpdating;
        this.storageVisible = bytes;
        this.storageUpdating = bytes;
    }

    public SWMRNibbleArray(byte[] bytes, int state) {
        if (bytes != null && bytes.length != 2048) {
            throw new IllegalArgumentException("Data of wrong length: " + bytes.length);
        }
        if (bytes == null && (state == 2 || state == 3)) {
            throw new IllegalArgumentException("Data cannot be null and have state be initialised");
        }
        this.stateUpdating = this.stateVisible = state;
        this.storageVisible = bytes;
        this.storageUpdating = bytes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("State: ");
        switch (this.stateVisible) {
            case 0: {
                stringBuilder.append("null");
                break;
            }
            case 1: {
                stringBuilder.append("uninitialised");
                break;
            }
            case 2: {
                stringBuilder.append("initialised");
                break;
            }
            case 3: {
                stringBuilder.append("hidden");
                break;
            }
            default: {
                stringBuilder.append("unknown");
            }
        }
        stringBuilder.append("\nData:\n");
        byte[] data = this.storageVisible;
        if (data != null) {
            for (int i2 = 0; i2 < 4096; ++i2) {
                int level = data[i2 >>> 1] >>> ((i2 & 1) << 2) & 0xF;
                stringBuilder.append(Integer.toHexString(level));
                if ((i2 & 0xF) == 15) {
                    stringBuilder.append("\n");
                }
                if ((i2 & 0xFF) != 255) continue;
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveState getSaveState() {
        SWMRNibbleArray sWMRNibbleArray = this;
        synchronized (sWMRNibbleArray) {
            int state = this.stateVisible;
            byte[] data = this.storageVisible;
            if (state == 0) {
                return null;
            }
            if (state == 1) {
                return new SaveState(null, state);
            }
            boolean zero = SWMRNibbleArray.isAllZero(data);
            if (zero) {
                return state == 2 ? new SaveState(null, 1) : null;
            }
            return new SaveState((byte[])data.clone(), state);
        }
    }

    protected static boolean isAllZero(byte[] data) {
        for (int i2 = 0; i2 < 128; ++i2) {
            byte whole = data[i2 << 4];
            for (int k2 = 1; k2 < 16; ++k2) {
                whole = (byte)(whole | data[i2 << 4 | k2]);
            }
            if (whole == 0) continue;
            return false;
        }
        return true;
    }

    public void extrudeLower(SWMRNibbleArray other) {
        byte[] into;
        if (other.stateUpdating == 0) {
            throw new IllegalArgumentException();
        }
        if (other.storageUpdating == null) {
            this.setUninitialised();
            return;
        }
        byte[] src = other.storageUpdating;
        if (this.storageUpdating != null) {
            into = this.storageUpdating;
        } else {
            this.storageUpdating = into = SWMRNibbleArray.allocateBytes();
            this.stateUpdating = 2;
        }
        this.updatingDirty = true;
        boolean start = false;
        int end = 127;
        for (int y2 = 0; y2 <= 15; ++y2) {
            System.arraycopy(src, 0, into, y2 << 7, 128);
        }
    }

    public void setFull() {
        byte[] byArray;
        if (this.stateUpdating != 3) {
            this.stateUpdating = 2;
        }
        if (this.storageUpdating == null || !this.updatingDirty) {
            this.storageUpdating = SWMRNibbleArray.allocateBytes();
            byArray = this.storageUpdating;
        } else {
            byArray = this.storageUpdating;
        }
        Arrays.fill(byArray, (byte)-1);
        this.updatingDirty = true;
    }

    public void setZero() {
        byte[] byArray;
        if (this.stateUpdating != 3) {
            this.stateUpdating = 2;
        }
        if (this.storageUpdating == null || !this.updatingDirty) {
            this.storageUpdating = SWMRNibbleArray.allocateBytes();
            byArray = this.storageUpdating;
        } else {
            byArray = this.storageUpdating;
        }
        Arrays.fill(byArray, (byte)0);
        this.updatingDirty = true;
    }

    public void setNonNull() {
        if (this.stateUpdating == 3) {
            this.stateUpdating = 2;
            return;
        }
        if (this.stateUpdating != 0) {
            return;
        }
        this.stateUpdating = 1;
    }

    public void setNull() {
        this.stateUpdating = 0;
        if (this.updatingDirty && this.storageUpdating != null) {
            SWMRNibbleArray.freeBytes(this.storageUpdating);
        }
        this.storageUpdating = null;
        this.updatingDirty = false;
    }

    public void setUninitialised() {
        this.stateUpdating = 1;
        if (this.storageUpdating != null && this.updatingDirty) {
            SWMRNibbleArray.freeBytes(this.storageUpdating);
        }
        this.storageUpdating = null;
        this.updatingDirty = false;
    }

    public void setHidden() {
        if (this.stateUpdating == 3) {
            return;
        }
        if (this.stateUpdating != 2) {
            this.setNull();
        } else {
            this.stateUpdating = 3;
        }
    }

    public boolean isDirty() {
        return this.stateUpdating != this.stateVisible || this.updatingDirty;
    }

    public boolean isNullNibbleUpdating() {
        return this.stateUpdating == 0;
    }

    public boolean isNullNibbleVisible() {
        return this.stateVisible == 0;
    }

    public boolean isUninitialisedUpdating() {
        return this.stateUpdating == 1;
    }

    public boolean isUninitialisedVisible() {
        return this.stateVisible == 1;
    }

    public boolean isInitialisedUpdating() {
        return this.stateUpdating == 2;
    }

    public boolean isInitialisedVisible() {
        return this.stateVisible == 2;
    }

    public boolean isHiddenUpdating() {
        return this.stateUpdating == 3;
    }

    public boolean isHiddenVisible() {
        return this.stateVisible == 3;
    }

    protected void swapUpdatingAndMarkDirty() {
        if (this.updatingDirty) {
            return;
        }
        if (this.storageUpdating == null) {
            this.storageUpdating = SWMRNibbleArray.allocateBytes();
            Arrays.fill(this.storageUpdating, (byte)0);
        } else {
            this.storageUpdating = SWMRNibbleArray.allocateBytes();
            System.arraycopy(this.storageUpdating, 0, this.storageUpdating, 0, 2048);
        }
        if (this.stateUpdating != 3) {
            this.stateUpdating = 2;
        }
        this.updatingDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateVisible() {
        if (!this.isDirty()) {
            return false;
        }
        SWMRNibbleArray sWMRNibbleArray = this;
        synchronized (sWMRNibbleArray) {
            if (this.stateUpdating == 0 || this.stateUpdating == 1) {
                this.storageVisible = null;
            } else {
                if (this.storageVisible == null) {
                    this.storageVisible = (byte[])this.storageUpdating.clone();
                } else if (this.storageUpdating != this.storageVisible) {
                    System.arraycopy(this.storageUpdating, 0, this.storageVisible, 0, 2048);
                }
                if (this.storageUpdating != this.storageVisible) {
                    SWMRNibbleArray.freeBytes(this.storageUpdating);
                }
                this.storageUpdating = this.storageVisible;
            }
            this.updatingDirty = false;
            this.stateVisible = this.stateUpdating;
        }
        return true;
    }

    public NibbleArray toVanillaNibble() {
        SWMRNibbleArray sWMRNibbleArray = this;
        synchronized (sWMRNibbleArray) {
            switch (this.stateVisible) {
                case 0: 
                case 3: {
                    return null;
                }
                case 1: {
                    return new NibbleArray();
                }
                case 2: {
                    return new NibbleArray((byte[])this.storageVisible.clone());
                }
            }
            throw new IllegalStateException();
        }
    }

    public int getUpdating(int x2, int y2, int z2) {
        return this.getUpdating(x2 & 0xF | (z2 & 0xF) << 4 | (y2 & 0xF) << 8);
    }

    public int getUpdating(int index) {
        byte[] bytes = this.storageUpdating;
        if (bytes == null) {
            return 0;
        }
        byte value = bytes[index >>> 1];
        return value >>> ((index & 1) << 2) & 0xF;
    }

    public int getVisible(int x2, int y2, int z2) {
        return this.getVisible(x2 & 0xF | (z2 & 0xF) << 4 | (y2 & 0xF) << 8);
    }

    public int getVisible(int index) {
        byte[] visibleBytes = this.storageVisible;
        if (visibleBytes == null) {
            return 0;
        }
        byte value = visibleBytes[index >>> 1];
        return value >>> ((index & 1) << 2) & 0xF;
    }

    public void set(int x2, int y2, int z2, int value) {
        this.set(x2 & 0xF | (z2 & 0xF) << 4 | (y2 & 0xF) << 8, value);
    }

    public void set(int index, int value) {
        if (!this.updatingDirty) {
            this.swapUpdatingAndMarkDirty();
        }
        int shift = (index & 1) << 2;
        int i2 = index >>> 1;
        this.storageUpdating[i2] = (byte)(this.storageUpdating[i2] & 240 >>> shift | value << shift);
    }

    public static final class SaveState {
        public final byte[] data;
        public final int state;

        public SaveState(byte[] data, int state) {
            this.data = data;
            this.state = state;
        }
    }
}

