/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.options.ConverterAbstractOptionsRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V2550;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;
import com.google.common.collect.ImmutableMap;

public final class V2558 {
    protected static final int VERSION = 2558;

    private V2558() {
    }

    public static void register() {
        ConverterAbstractOptionsRename.register(2558, arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"key_key.swapHands", (Object)"key_key.swapOffhand")).get(arg_0));
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2558){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType<Object> dimensions = data.getMap("dimensions");
                if (dimensions == null) {
                    dimensions = Types.NBT.createEmptyMap();
                    data.setMap("dimensions", dimensions);
                }
                if (dimensions.isEmpty()) {
                    data.setMap("dimensions", V2558.recreateSettings(data));
                }
                return null;
            }
        });
    }

    private static MapType<String> recreateSettings(MapType<String> data) {
        long seed = data.getLong("seed");
        return V2550.vanillaLevels(seed, V2550.defaultOverworld(seed), false);
    }
}

