/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.mojang.datafixers.DataFixUtils;
import net.minecraft.util.MathHelper;

public final class V2527 {
    protected static final int VERSION = 2527;

    private V2527() {
    }

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2527){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType heightMaps;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections != null) {
                    int len = sections.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        long[] states;
                        int bits;
                        MapType section = sections.getMap(i2);
                        ListType palette = section.getList("Palette", ObjectType.MAP);
                        if (palette == null || MathHelper.d(bits = Math.max(4, DataFixUtils.ceillog2((int)palette.size()))) || (states = section.getLongs("BlockStates")) == null) continue;
                        section.setLongs("BlockStates", V2527.addPadding(4096, bits, states));
                    }
                }
                if ((heightMaps = level.getMap("Heightmaps")) != null) {
                    for (String key : heightMaps.keys()) {
                        long[] old = heightMaps.getLongs(key);
                        heightMaps.setLongs(key, V2527.addPadding(256, 9, old));
                    }
                }
                return null;
            }
        });
    }

    public static long[] addPadding(int indices, int bits, long[] old) {
        int k2 = old.length;
        if (k2 == 0) {
            return old;
        }
        long l2 = (1L << bits) - 1L;
        int m2 = 64 / bits;
        int n2 = (indices + m2 - 1) / m2;
        long[] padded = new long[n2];
        int o2 = 0;
        int p2 = 0;
        long q2 = 0L;
        int r2 = 0;
        long s2 = old[0];
        long t2 = k2 > 1 ? old[1] : 0L;
        for (int u2 = 0; u2 < indices; ++u2) {
            int ac2;
            long ab2;
            int v2 = u2 * bits;
            int w2 = v2 >> 6;
            int x2 = (u2 + 1) * bits - 1 >> 6;
            int y2 = v2 ^ w2 << 6;
            if (w2 != r2) {
                s2 = t2;
                t2 = w2 + 1 < k2 ? old[w2 + 1] : 0L;
                r2 = w2;
            }
            if (w2 == x2) {
                ab2 = s2 >>> y2 & l2;
            } else {
                ac2 = 64 - y2;
                ab2 = (s2 >>> y2 | t2 << ac2) & l2;
            }
            ac2 = p2 + bits;
            if (ac2 >= 64) {
                padded[o2++] = q2;
                q2 = ab2;
                p2 = bits;
                continue;
            }
            q2 |= ab2 << p2;
            p2 = ac2;
        }
        if (q2 != 0L) {
            padded[o2] = q2;
        }
        return padded;
    }
}

