/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V2511 {
    protected static final int VERSION = 2511;

    private V2511() {
    }

    private static int[] createUUIDArray(long most, long least) {
        return new int[]{(int)(most >>> 32), (int)most, (int)(least >>> 32), (int)least};
    }

    private static void setUUID(MapType<String> data, long most, long least) {
        if (most != 0L && least != 0L) {
            data.setInts("OwnerUUID", V2511.createUUIDArray(most, least));
        }
    }

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> throwableConverter = new DataConverter<MapType<String>, MapType<String>>(2511){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType owner = data.getMap("owner");
                data.remove("owner");
                if (owner == null) {
                    return null;
                }
                V2511.setUUID(data, owner.getLong("M"), owner.getLong("L"));
                return null;
            }
        };
        DataConverter<MapType<String>, MapType<String>> potionConverter = new DataConverter<MapType<String>, MapType<String>>(2511){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType potion = data.getMap("Potion");
                data.remove("Potion");
                data.setMap("Item", potion == null ? Types.NBT.createEmptyMap() : potion);
                return null;
            }
        };
        DataConverter<MapType<String>, MapType<String>> llamaSpitConverter = new DataConverter<MapType<String>, MapType<String>>(2511){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType owner = data.getMap("Owner");
                data.remove("Owner");
                if (owner == null) {
                    return null;
                }
                V2511.setUUID(data, owner.getLong("OwnerUUIDMost"), owner.getLong("OwnerUUIDLeast"));
                return null;
            }
        };
        DataConverter<MapType<String>, MapType<String>> arrowConverter = new DataConverter<MapType<String>, MapType<String>>(2511){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                V2511.setUUID(data, data.getLong("OwnerUUIDMost"), data.getLong("OwnerUUIDLeast"));
                data.remove("OwnerUUIDMost");
                data.remove("OwnerUUIDLeast");
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:egg", throwableConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:ender_pearl", throwableConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:experience_bottle", throwableConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:snowball", throwableConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:potion", throwableConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:potion", potionConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:llama_spit", llamaSpitConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:arrow", arrowConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:spectral_arrow", arrowConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:trident", arrowConverter);
        MCTypeRegistry.ENTITY.addWalker(2511, "minecraft:potion", new DataWalkerItems("Item"));
    }
}

