/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.blockname.ConverterAbstractBlockRename;
import ca.spottedleaf.dataconverter.minecraft.converters.itemname.ConverterAbstractItemRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V1458;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.google.common.collect.ImmutableMap;

public final class V1488 {
    protected static final int VERSION = 1488;

    protected static boolean isIglooPiece(MapType<String> piece) {
        return "Iglu".equals(piece.getString("id"));
    }

    public static void register() {
        ConverterAbstractBlockRename.register(1488, arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant")).get(arg_0));
        ConverterAbstractItemRename.register(1488, arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp")).get(arg_0));
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:command_block", new DataConverter<MapType<String>, MapType<String>>(1488){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:commandblock_minecart", new DataConverter<MapType<String>, MapType<String>>(1488){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1488){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                int i2;
                boolean isIgloo;
                ListType children = data.getList("Children", ObjectType.MAP);
                if (children != null) {
                    isIgloo = true;
                    int len = children.size();
                    for (i2 = 0; i2 < len; ++i2) {
                        if (V1488.isIglooPiece(children.getMap(i2))) continue;
                        isIgloo = false;
                        break;
                    }
                } else {
                    isIgloo = false;
                }
                if (isIgloo) {
                    data.remove("Children");
                    data.setString("id", "Igloo");
                    return null;
                }
                if (children != null) {
                    i2 = 0;
                    while (i2 < children.size()) {
                        MapType<String> child = children.getMap(i2);
                        if (V1488.isIglooPiece(child)) {
                            children.remove(i2);
                            continue;
                        }
                        ++i2;
                    }
                }
                return null;
            }
        });
    }

    private V1488() {
    }
}

