/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.block_name.DataWalkerBlockNames;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V100 {
    protected static final int VERSION = 100;

    private static void registerMob(String id) {
        MCTypeRegistry.ENTITY.addWalker(100, id, new DataWalkerItemLists("ArmorItems", "HandItems"));
    }

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(100){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType equipment = data.getList("Equipment", ObjectType.MAP);
                data.remove("Equipment");
                if (equipment != null) {
                    if (equipment.size() > 0 && data.getListUnchecked("HandItems") == null) {
                        ListType handItems = Types.NBT.createEmptyList();
                        data.setList("HandItems", handItems);
                        handItems.addMap(equipment.getMap(0));
                        handItems.addMap(Types.NBT.createEmptyMap());
                    }
                    if (equipment.size() > 1 && data.getListUnchecked("ArmorItems") == null) {
                        ListType armorItems = Types.NBT.createEmptyList();
                        data.setList("ArmorItems", armorItems);
                        for (int i2 = 1; i2 < Math.min(equipment.size(), 5); ++i2) {
                            armorItems.addMap(equipment.getMap(i2));
                        }
                    }
                }
                ListType dropChances = data.getList("DropChances", ObjectType.FLOAT);
                data.remove("DropChances");
                if (dropChances != null) {
                    if (data.getListUnchecked("HandDropChances") == null) {
                        ListType handDropChances = Types.NBT.createEmptyList();
                        data.setList("HandDropChances", handDropChances);
                        if (0 < dropChances.size()) {
                            handDropChances.addFloat(dropChances.getFloat(0));
                        } else {
                            handDropChances.addFloat(0.0f);
                        }
                        handDropChances.addFloat(0.0f);
                    }
                    if (data.getListUnchecked("ArmorDropChances") == null) {
                        ListType armorDropChances = Types.NBT.createEmptyList();
                        data.setList("ArmorDropChances", armorDropChances);
                        for (int i3 = 1; i3 < 5; ++i3) {
                            if (i3 < dropChances.size()) {
                                armorDropChances.addFloat(dropChances.getFloat(i3));
                                continue;
                            }
                            armorDropChances.addFloat(0.0f);
                        }
                    }
                }
                return null;
            }
        });
        V100.registerMob("ArmorStand");
        V100.registerMob("Creeper");
        V100.registerMob("Skeleton");
        V100.registerMob("Spider");
        V100.registerMob("Giant");
        V100.registerMob("Zombie");
        V100.registerMob("Slime");
        V100.registerMob("Ghast");
        V100.registerMob("PigZombie");
        V100.registerMob("Enderman");
        MCTypeRegistry.ENTITY.addWalker(100, "Enderman", new DataWalkerBlockNames("carried"));
        V100.registerMob("CaveSpider");
        V100.registerMob("Silverfish");
        V100.registerMob("Blaze");
        V100.registerMob("LavaSlime");
        V100.registerMob("EnderDragon");
        V100.registerMob("WitherBoss");
        V100.registerMob("Bat");
        V100.registerMob("Witch");
        V100.registerMob("Endermite");
        V100.registerMob("Guardian");
        V100.registerMob("Pig");
        V100.registerMob("Sheep");
        V100.registerMob("Cow");
        V100.registerMob("Chicken");
        V100.registerMob("Squid");
        V100.registerMob("Wolf");
        V100.registerMob("MushroomCow");
        V100.registerMob("SnowMan");
        V100.registerMob("Ozelot");
        V100.registerMob("VillagerGolem");
        MCTypeRegistry.ENTITY.addWalker(100, "EntityHorse", new DataWalkerItemLists("Items", "ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(100, "EntityHorse", new DataWalkerItems("ArmorItem", "SaddleItem"));
        V100.registerMob("Rabbit");
        MCTypeRegistry.ENTITY.addWalker(100, "Villager", (data, fromVersion, toVersion) -> {
            ListType recipes;
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "Inventory", fromVersion, toVersion);
            MapType offers = data.getMap("Offers");
            if (offers != null && (recipes = offers.getList("Recipes", ObjectType.MAP)) != null) {
                int len = recipes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType<String> recipe = recipes.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "buy", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "buyB", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "sell", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "ArmorItems", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "HandItems", fromVersion, toVersion);
            return null;
        });
        V100.registerMob("Shulker");
        MCTypeRegistry.STRUCTURE.addStructureWalker(100, (data, fromVersion, toVersion) -> {
            ListType blocks;
            ListType entities = data.getList("entities", ObjectType.MAP);
            if (entities != null) {
                int len = entities.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    WalkerUtils.convert(MCTypeRegistry.ENTITY, entities.getMap(i2), "nbt", fromVersion, toVersion);
                }
            }
            if ((blocks = data.getList("blocks", ObjectType.MAP)) != null) {
                int len = blocks.size();
                for (int i3 = 0; i3 < len; ++i3) {
                    WalkerUtils.convert(MCTypeRegistry.TILE_ENTITY, blocks.getMap(i3), "nbt", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, (MapType<String>)data, "palette", fromVersion, toVersion);
            return null;
        });
    }

    private V100() {
    }
}

