/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.helpers;

import ca.spottedleaf.dataconverter.types.MapType;
import java.util.ArrayList;
import java.util.function.Function;

public final class RenameHelper {
    public static void renameKeys(MapType<String> data, Function<String, String> renamer) {
        boolean needsRename = false;
        for (String key : data.keys()) {
            if (renamer.apply(key) == null) continue;
            needsRename = true;
            break;
        }
        if (!needsRename) {
            return;
        }
        ArrayList<String> newKeys = new ArrayList<String>();
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (String key : new ArrayList<String>(data.keys())) {
            String renamed = renamer.apply(key);
            if (renamed == null) continue;
            newValues.add(data.getGeneric(key));
            newKeys.add(renamed);
            data.remove(key);
        }
        int len = newKeys.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String key = (String)newKeys.get(i2);
            Object value = newValues.get(i2);
            data.setGeneric(key, value);
        }
    }

    public static void renameSingle(MapType<String> data, String fromKey, String toKey) {
        Object value = data.getGeneric(fromKey);
        if (value != null) {
            data.remove(fromKey);
            data.setGeneric(toKey, value);
        }
    }

    private RenameHelper() {
    }
}

