/*
 * Decompiled with CFR 0.152.
 */
package org.serversmc.autorestart.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.serversmc.autorestart.enums.ChatColorKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/serversmc/autorestart/utils/Console;", "", "()V", "consoleSender", "Lorg/bukkit/command/ConsoleCommandSender;", "Lorg/jetbrains/annotations/NotNull;", "getConsoleSender", "()Lorg/bukkit/command/ConsoleCommandSender;", "p", "", "catchError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loc", "err", "s", "info", "sendMessage", "warn", "AutoRestart-v4"})
public final class Console {
    @NotNull
    private static final ConsoleCommandSender consoleSender;
    private static final String p = "[AutoRestart] ";
    public static final Console INSTANCE;

    @NotNull
    public final ConsoleCommandSender getConsoleSender() {
        return consoleSender;
    }

    public final void info(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + p + s);
    }

    public final void warn(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + p + s);
    }

    public final void err(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + p + s);
    }

    public final void sendMessage(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        consoleSender.sendMessage(ChatColorKt.translateChatColor('&', s));
    }

    public final void catchError(@NotNull Exception e, @NotNull String loc) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        this.err("There was an error in " + loc);
        this.sendMessage(e.toString());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "e.stackTrace");
        StackTraceElement[] $this$forEach$iv = stackTraceElementArray;
        boolean $i$f$forEach = false;
        StackTraceElement[] stackTraceElementArray2 = $this$forEach$iv;
        int n = stackTraceElementArray2.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement element$iv;
            StackTraceElement it = element$iv = stackTraceElementArray2[i];
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "it.toString()");
            if (!StringsKt.startsWith$default(string, "org.serversmc", false, 2, null)) continue;
            INSTANCE.sendMessage("\t" + it.toString());
        }
        this.err("End of error");
    }

    private Console() {
    }

    static {
        Console console;
        INSTANCE = console = new Console();
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        Intrinsics.checkExpressionValueIsNotNull(consoleCommandSender, "Bukkit.getConsoleSender()");
        consoleSender = consoleCommandSender;
    }
}

