/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;

public class WatchdogThread
extends Thread {
    public static final boolean DISABLE_WATCHDOG = Boolean.getBoolean("disable.watchdog");
    private static WatchdogThread instance;
    private long timeoutTime;
    private boolean restart;
    private final long earlyWarningEvery;
    private final long earlyWarningDelay;
    public static volatile boolean hasStarted;
    private long lastEarlyWarning;
    private volatile long lastTick;
    private volatile boolean stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpEntity(Entity entity) {
        Vec3D moveVec;
        double moveStartZ;
        double moveStartY;
        double moveStartX;
        Vec3D mot;
        double posZ;
        double posY;
        double posX;
        Logger log = Bukkit.getServer().getLogger();
        Object object = entity.posLock;
        synchronized (object) {
            posX = entity.dc();
            posY = entity.de();
            posZ = entity.di();
            mot = entity.da();
            moveStartX = entity.getMoveStartX();
            moveStartY = entity.getMoveStartY();
            moveStartZ = entity.getMoveStartZ();
            moveVec = entity.getMoveVector();
        }
        String entityType = entity.getMinecraftKey().toString();
        UUID entityUUID = entity.cm();
        World world = entity.t;
        log.log(Level.SEVERE, "Ticking entity: " + entityType + ", entity class: " + entity.getClass().getName());
        log.log(Level.SEVERE, "Entity status: removed: " + entity.do() + ", valid: " + entity.valid + ", alive: " + entity.bl() + ", is passenger: " + entity.bF());
        log.log(Level.SEVERE, "Entity UUID: " + entityUUID);
        log.log(Level.SEVERE, "Position: world: '" + (world == null ? "unknown world?" : world.getWorld().getName()) + "' at location (" + posX + ", " + posY + ", " + posZ + ")");
        log.log(Level.SEVERE, "Velocity: " + (mot == null ? "unknown velocity" : mot.toString()) + " (in blocks per tick)");
        log.log(Level.SEVERE, "Entity AABB: " + entity.cw());
        if (moveVec != null) {
            log.log(Level.SEVERE, "Move call information: ");
            log.log(Level.SEVERE, "Start position: (" + moveStartX + ", " + moveStartY + ", " + moveStartZ + ")");
            log.log(Level.SEVERE, "Move vector: " + moveVec.toString());
        }
    }

    private void dumpTickingInfo() {
        Logger log = Bukkit.getServer().getLogger();
        for (Entity entity : WorldServer.getCurrentlyTickingEntities()) {
            this.dumpEntity(entity);
            Entity vehicle = entity.cN();
            if (vehicle == null) continue;
            log.log(Level.SEVERE, "Detailing vehicle for above entity:");
            this.dumpEntity(vehicle);
        }
        for (PacketListener packetListener : PlayerConnectionUtils.getCurrentPacketProcessors()) {
            if (packetListener instanceof PlayerConnection) {
                EntityPlayer player = ((PlayerConnection)packetListener).b;
                long totalPackets = PlayerConnectionUtils.getTotalProcessedPackets();
                if (player == null) {
                    log.log(Level.SEVERE, "Handling packet for player connection or ticking player connection (null player): " + packetListener);
                    log.log(Level.SEVERE, "Total packets processed on the main thread for all players: " + totalPackets);
                    continue;
                }
                this.dumpEntity(player);
                Entity vehicle = player.cN();
                if (vehicle != null) {
                    log.log(Level.SEVERE, "Detailing vehicle for above entity:");
                    this.dumpEntity(vehicle);
                }
                log.log(Level.SEVERE, "Total packets processed on the main thread for all players: " + totalPackets);
                continue;
            }
            log.log(Level.SEVERE, "Handling packet for connection: " + packetListener);
        }
    }

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Paper Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.restart = restart;
        this.earlyWarningEvery = Math.min((long)PaperConfig.watchdogPrintEarlyWarningEvery, timeoutTime);
        this.earlyWarningDelay = Math.min((long)PaperConfig.watchdogPrintEarlyWarningDelay, timeoutTime);
    }

    private static long monotonicMillis() {
        return System.nanoTime() / 1000000L;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            if (timeoutTime <= 0) {
                timeoutTime = 300;
            }
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        } else {
            WatchdogThread.instance.timeoutTime = (long)timeoutTime * 1000L;
            WatchdogThread.instance.restart = restart;
        }
    }

    public static void tick() {
        WatchdogThread.instance.lastTick = WatchdogThread.monotonicMillis();
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            Logger log = Bukkit.getServer().getLogger();
            long currentTime = WatchdogThread.monotonicMillis();
            MinecraftServer server = MinecraftServer.getServer();
            if (this.lastTick != 0L && this.timeoutTime > 0L && hasStarted && (!server.v() || currentTime > this.lastTick + this.earlyWarningEvery && !DISABLE_WATCHDOG)) {
                boolean isLongTimeout;
                boolean bl = isLongTimeout = currentTime > this.lastTick + this.timeoutTime || !server.v() && !server.hasStopped() && currentTime > this.lastTick + 1000L;
                if (!isLongTimeout && (this.earlyWarningEvery <= 0L || !hasStarted || currentTime < this.lastEarlyWarning + this.earlyWarningEvery || currentTime < this.lastTick + this.earlyWarningDelay) || !isLongTimeout && server.hasStopped()) continue;
                this.lastEarlyWarning = currentTime;
                if (isLongTimeout) {
                    log.log(Level.SEVERE, "------------------------------");
                    log.log(Level.SEVERE, "The server has stopped responding! This is (probably) not a Paper bug.");
                    log.log(Level.SEVERE, "If you see a plugin in the Server thread dump below, then please report it to that author");
                    log.log(Level.SEVERE, "\t *Especially* if it looks like HTTP or MySQL operations are occurring");
                    log.log(Level.SEVERE, "If you see a world save or edit, then it means you did far more than your server can handle at once");
                    log.log(Level.SEVERE, "\t If this is the case, consider increasing timeout-time in spigot.yml but note that this will replace the crash with LARGE lag spikes");
                    log.log(Level.SEVERE, "If you are unsure or still think this is a Paper bug, please report this to https://github.com/PaperMC/Paper/issues");
                    log.log(Level.SEVERE, "Be sure to include ALL relevant console errors and Minecraft crash reports");
                    log.log(Level.SEVERE, "Paper version: " + Bukkit.getServer().getVersion());
                    if (World.lastPhysicsProblem != null) {
                        log.log(Level.SEVERE, "------------------------------");
                        log.log(Level.SEVERE, "During the run of the server, a physics stackoverflow was supressed");
                        log.log(Level.SEVERE, "near " + World.lastPhysicsProblem);
                    }
                    if (CraftServer.excessiveVelEx != null) {
                        log.log(Level.SEVERE, "------------------------------");
                        log.log(Level.SEVERE, "During the run of the server, a plugin set an excessive velocity on an entity");
                        log.log(Level.SEVERE, "This may be the cause of the issue, or it may be entirely unrelated");
                        log.log(Level.SEVERE, CraftServer.excessiveVelEx.getMessage());
                        for (StackTraceElement stack : StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(CraftServer.excessiveVelEx.getStackTrace())) {
                            log.log(Level.SEVERE, "\t\t" + stack);
                        }
                    }
                } else {
                    log.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH  - " + Bukkit.getServer().getVersion() + " ---");
                    log.log(Level.SEVERE, "The server has not responded for " + (currentTime - this.lastTick) / 1000L + " seconds! Creating thread dump");
                }
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Server thread dump (Look for plugins here before reporting to Paper!):");
                ChunkTaskManager.dumpAllChunkLoadInfo();
                this.dumpTickingInfo();
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(server.an.getId(), Integer.MAX_VALUE), log);
                log.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    ThreadInfo[] threads;
                    log.log(Level.SEVERE, "Entire Thread Dump:");
                    for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                        WatchdogThread.dumpThread(thread, log);
                    }
                } else {
                    log.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH ---");
                }
                log.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    if (server.hasStopped()) break;
                    AsyncCatcher.enabled = false;
                    AsyncCatcher.shuttingDown = true;
                    server.forceTicks = true;
                    if (this.restart) {
                        RestartCommand.addShutdownHook(SpigotConfig.restartScript);
                    }
                    server.abnormalExit = true;
                    server.safeShutdown(false, this.restart);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    if (server.hasStopped()) break;
                    server.close();
                    break;
                }
            }
            try {
                WatchdogThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger log) {
        log.log(Level.SEVERE, "------------------------------");
        log.log(Level.SEVERE, "Current Thread: " + thread.getThreadName());
        log.log(Level.SEVERE, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + thread.getThreadState());
        if (thread.getLockedMonitors().length != 0) {
            log.log(Level.SEVERE, "\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                log.log(Level.SEVERE, "\t\tLocked on:" + monitor.getLockedStackFrame());
            }
        }
        log.log(Level.SEVERE, "\tStack:");
        for (StackTraceElement stack : StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(thread.getStackTrace())) {
            log.log(Level.SEVERE, "\t\t" + (StackTraceElement)stack);
        }
    }
}

