/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TicksPerSecondCommand
extends Command {
    private boolean hasShownMemoryWarning;

    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        double[] tps = Bukkit.getTPS();
        Object[] tpsAvg = new String[tps.length];
        for (int i2 = 0; i2 < tps.length; ++i2) {
            tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
        }
        sender.sendMessage(ChatColor.GOLD + "TPS from last 1m, 5m, 15m: " + StringUtils.join((Object[])tpsAvg, (String)", "));
        if (args.length > 0 && args[0].equals("mem") && sender.hasPermission("bukkit.command.tpsmemory")) {
            sender.sendMessage(ChatColor.GOLD + "Current Memory Usage: " + ChatColor.GREEN + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + " mb (Max: " + Runtime.getRuntime().maxMemory() / 0x100000L + " mb)");
            if (!this.hasShownMemoryWarning) {
                sender.sendMessage(ChatColor.RED + "Warning: " + ChatColor.GOLD + " Memory usage on modern garbage collectors is not a stable value and it is perfectly normal to see it reach max. Please do not pay it much attention.");
                this.hasShownMemoryWarning = true;
            }
        }
        return true;
    }

    private static String format(double tps) {
        return (tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED)).toString() + (tps > 21.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

