/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R1.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final GeneratorAccess world;
    private final Map<BlockPosition, IBlockData> dataMap = new HashMap<BlockPosition, IBlockData>();
    private final Map<BlockPosition, TileEntity> entityMap = new HashMap<BlockPosition, TileEntity>();
    private final LinkedHashMap<BlockPosition, CraftBlockState> list;

    public BlockStateListPopulator(GeneratorAccess world) {
        this(world, new LinkedHashMap<BlockPosition, CraftBlockState>());
    }

    private BlockStateListPopulator(GeneratorAccess world, LinkedHashMap<BlockPosition, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        IBlockData blockData = this.dataMap.get(pos);
        return blockData != null ? blockData : this.world.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        IBlockData blockData = this.dataMap.get(pos);
        return blockData != null ? blockData.n() : this.world.b_(pos);
    }

    @Override
    public TileEntity c_(BlockPosition pos) {
        if (this.entityMap.containsKey(pos)) {
            return this.entityMap.get(pos);
        }
        return this.world.c_(pos);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags) {
        pos = pos.h();
        this.list.remove(pos);
        this.dataMap.put(pos, state);
        if (state.m()) {
            this.entityMap.put(pos, ((ITileEntity)((Object)state.b())).a(pos, state));
        } else {
            this.entityMap.put(pos, null);
        }
        CraftBlockState state1 = (CraftBlockState)CraftBlock.at(this, pos).getState();
        state1.setFlag(flags);
        state1.setWorldHandle(this.world);
        this.list.put(pos, state1);
        return true;
    }

    @Override
    public WorldServer getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState state : this.list.values()) {
            if (!(state instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)state).refreshSnapshot();
        }
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<BlockPosition> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public GeneratorAccess getWorld() {
        return this.world;
    }

    @Override
    public int u_() {
        return this.getWorld().u_();
    }

    @Override
    public int v_() {
        return this.getWorld().v_();
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public DimensionManager q_() {
        return this.world.q_();
    }
}

