/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

final class CraftCriteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final IScoreboardCriteria criteria;
    final String bukkitName;

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(IScoreboardCriteria criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.d();
    }

    static CraftCriteria getFromNMS(ScoreboardObjective objective) {
        return Objects.requireNonNullElseGet(DEFAULTS.get(objective.c().d()), () -> new CraftCriteria(objective.c()));
    }

    static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        Optional<IScoreboardCriteria> nmsCriteria = IScoreboardCriteria.a(name);
        if (nmsCriteria.isPresent()) {
            return new CraftCriteria(nmsCriteria.get());
        }
        return new CraftCriteria(name);
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry<String, IScoreboardCriteria> entry : IScoreboardCriteria.o.entrySet()) {
            String name = entry.getKey();
            IScoreboardCriteria criteria = entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }
}

