/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.inventory;

import java.util.ArrayList;
import net.minecraft.world.item.crafting.RecipeItemStack;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public RecipeItemStack toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        RecipeItemStack stack;
        if (bukkit == null) {
            stack = RecipeItemStack.a;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new RecipeItemStack(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy(new ItemStack(mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new RecipeItemStack(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + bukkit);
        }
        stack.f();
        if (requireNotEmpty && stack.c.length == 0) {
            throw new IllegalArgumentException("Recipe requires at least one non-air choice!");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(RecipeItemStack list) {
        list.f();
        if (list.c.length == 0) {
            return null;
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.c.length);
            for (net.minecraft.world.item.ItemStack i2 : list.c) {
                choices.add(CraftItemStack.asBukkitCopy(i2));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.c.length);
        for (net.minecraft.world.item.ItemStack i3 : list.c) {
            choices.add(CraftMagicNumbers.getMaterial(i3.c()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }
}

