/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBundle
extends CraftMetaItem
implements BundleMeta {
    static final CraftMetaItem.ItemMetaKey ITEMS = new CraftMetaItem.ItemMetaKey("Items", "items");
    private List<ItemStack> items;

    CraftMetaBundle(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBundle)) {
            return;
        }
        CraftMetaBundle bundle = (CraftMetaBundle)meta;
        if (bundle.hasItems()) {
            this.items = new ArrayList<ItemStack>(bundle.items);
        }
    }

    CraftMetaBundle(NBTTagCompound tag) {
        super(tag);
        NBTTagList list;
        if (tag.b(CraftMetaBundle.ITEMS.NBT, 9) && (list = tag.c(CraftMetaBundle.ITEMS.NBT, 10)) != null && !list.isEmpty()) {
            this.items = new ArrayList<ItemStack>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = list.a(i2);
                this.addItem(CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.a(nbttagcompound1)));
            }
        }
    }

    CraftMetaBundle(Map<String, Object> map) {
        super(map);
        Iterable items = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaBundle.ITEMS.BUKKIT, true);
        if (items != null) {
            for (Object stack : items) {
                if (!(stack instanceof ItemStack)) continue;
                this.addItem((ItemStack)stack);
            }
        }
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        if (this.hasItems()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack item : this.items) {
                NBTTagCompound saved = new NBTTagCompound();
                CraftItemStack.asNMSCopy(item).b(saved);
                list.add(saved);
            }
            tag.a(CraftMetaBundle.ITEMS.NBT, list);
        }
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case BUNDLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBundleEmpty();
    }

    boolean isBundleEmpty() {
        return !this.hasItems();
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.items == null ? ImmutableList.of() : ImmutableList.copyOf(this.items);
    }

    public void setItems(List<ItemStack> items) {
        this.items = null;
        if (items == null) {
            return;
        }
        for (ItemStack i2 : items) {
            this.addItem(i2);
        }
    }

    public void addItem(ItemStack item) {
        Preconditions.checkArgument((item != null && !item.getType().isAir() ? 1 : 0) != 0, (Object)"item is null or air");
        if (this.items == null) {
            this.items = new ArrayList<ItemStack>();
        }
        this.items.add(item);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBundle) {
            CraftMetaBundle that = (CraftMetaBundle)meta;
            return this.hasItems() ? that.hasItems() && this.items.equals(that.items) : !that.hasItems();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBundle || this.isBundleEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasItems()) {
            hash = 61 * hash + this.items.hashCode();
        }
        return original != hash ? CraftMetaBundle.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaBundle clone() {
        return (CraftMetaBundle)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasItems()) {
            builder.put((Object)CraftMetaBundle.ITEMS.BUKKIT, this.items);
        }
        return builder;
    }
}

