/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_18_R1.generator.InternalChunkGenerator;
import org.bukkit.craftbukkit.v1_18_R1.generator.OldCraftChunkData;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    public final ChunkGenerator delegate;
    private final org.bukkit.generator.ChunkGenerator generator;
    private final WorldServer world;
    private final Random random = new Random();
    private boolean newApi;
    private boolean implementBaseHeight = true;

    public CustomChunkGenerator(WorldServer world, ChunkGenerator delegate, org.bukkit.generator.ChunkGenerator generator) {
        super(delegate.e(), delegate.d());
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    private static SeededRandom getSeededRandom() {
        return new SeededRandom(new LegacyRandomSource(0L));
    }

    @Override
    public ChunkGenerator a(long seed) {
        return new CustomChunkGenerator(this.world, this.delegate.a(seed), this.generator);
    }

    @Override
    public WorldChunkManager e() {
        return this.delegate.e();
    }

    @Override
    public int h() {
        return this.delegate.h();
    }

    @Override
    public int g() {
        return this.delegate.g();
    }

    @Override
    public void a(IRegistryCustom registryManager, StructureManager structureAccessor, IChunkAccess chunk, DefinedStructureManager structureManager, long worldSeed) {
        if (this.generator.shouldGenerateStructures()) {
            super.a(registryManager, structureAccessor, chunk, structureManager, worldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structures, IChunkAccess chunk) {
        ChunkGenerator.ChunkData data;
        int z2;
        int x2;
        block16: {
            if (this.generator.shouldGenerateSurface()) {
                this.delegate.a(region, structures, chunk);
            }
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), chunk);
            SeededRandom random = CustomChunkGenerator.getSeededRandom();
            x2 = chunk.f().c;
            z2 = chunk.f().d;
            random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateSurface((WorldInfo)this.world.getWorld(), (Random)random, x2, z2, (ChunkGenerator.ChunkData)chunkData);
            if (this.generator.shouldGenerateBedrock()) {
                random = CustomChunkGenerator.getSeededRandom();
                random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            }
            random = CustomChunkGenerator.getSeededRandom();
            random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateBedrock((WorldInfo)this.world.getWorld(), (Random)random, x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            if (this.newApi) {
                return;
            }
            this.random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(chunk);
            try {
                if (this.generator.isParallelCapable()) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                    break block16;
                }
                CustomChunkGenerator customChunkGenerator = this;
                synchronized (customChunkGenerator) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                }
            }
            catch (UnsupportedOperationException exception) {
                this.newApi = true;
                return;
            }
        }
        Preconditions.checkArgument((boolean)(data instanceof OldCraftChunkData), (String)"Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        OldCraftChunkData craftData = (OldCraftChunkData)data;
        ChunkSection[] sections = craftData.getRawChunkData();
        ChunkSection[] csect = chunk.d();
        int scnt = Math.min(csect.length, sections.length);
        for (int sec = 0; sec < scnt; ++sec) {
            if (sections[sec] == null) continue;
            ChunkSection section = sections[sec];
            ChunkSection oldSection = csect[sec];
            for (int biomeX = 0; biomeX < 4; ++biomeX) {
                for (int biomeY = 0; biomeY < 4; ++biomeY) {
                    for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                        section.setBiome(biomeX, biomeY, biomeZ, oldSection.c(biomeX, biomeY, biomeZ));
                    }
                }
            }
            csect[sec] = section;
        }
        if (craftData.getTiles() != null) {
            for (BlockPosition pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.u();
                IBlockData block = craftData.getTypeId(tx, ty = pos.v(), tz = pos.w());
                if (!block.m()) continue;
                TileEntity tile = ((ITileEntity)((Object)block.b())).a(new BlockPosition((x2 << 4) + tx, ty, (z2 << 4) + tz), block);
                chunk.a(tile);
            }
        }
        for (BlockPosition lightPosition : craftData.getLights()) {
            ((ProtoChunk)chunk).j(new BlockPosition((x2 << 4) + lightPosition.u(), lightPosition.v(), (z2 << 4) + lightPosition.w()));
        }
    }

    @Override
    public void a(RegionLimitedWorldAccess chunkRegion, long seed, BiomeManager biomeAccess, StructureManager structureAccessor, IChunkAccess chunk, WorldGenStage.Features generationStep) {
        if (this.generator.shouldGenerateCaves()) {
            this.delegate.a(chunkRegion, seed, biomeAccess, structureAccessor, chunk, generationStep);
        }
        if (generationStep == WorldGenStage.Features.b) {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), chunk);
            SeededRandom random = CustomChunkGenerator.getSeededRandom();
            int x2 = chunk.f().c;
            int z2 = chunk.f().d;
            random.a(seed, 0, 0);
            this.generator.generateCaves((WorldInfo)this.world.getWorld(), (Random)random, x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        CompletableFuture<IChunkAccess> future = null;
        if (this.generator.shouldGenerateNoise()) {
            future = this.delegate.a(executor, blender, structureAccessor, chunk);
        }
        Function<IChunkAccess, IChunkAccess> function = ichunkaccess1 -> {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), (IChunkAccess)ichunkaccess1);
            SeededRandom random = CustomChunkGenerator.getSeededRandom();
            int x2 = ichunkaccess1.f().c;
            int z2 = ichunkaccess1.f().d;
            random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateNoise((WorldInfo)this.world.getWorld(), (Random)random, x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            return ichunkaccess1;
        };
        return future == null ? CompletableFuture.supplyAsync(() -> (IChunkAccess)function.apply(chunk), SystemUtils.g()) : future.thenApply(function);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        if (this.implementBaseHeight) {
            try {
                SeededRandom random = CustomChunkGenerator.getSeededRandom();
                int xChunk = x2 >> 4;
                int zChunk = z2 >> 4;
                random.setSeed((long)xChunk * 341873128712L + (long)zChunk * 132897987541L);
                return this.generator.getBaseHeight((WorldInfo)this.world.getWorld(), (Random)random, x2, z2, CraftHeightMap.fromNMS(heightmap));
            }
            catch (UnsupportedOperationException exception) {
                this.implementBaseHeight = false;
            }
        }
        return this.delegate.a(x2, z2, heightmap, world);
    }

    @Override
    public WeightedRandomList<BiomeSettingsMobs.c> a(BiomeBase biome, StructureManager accessor, EnumCreatureType group, BlockPosition pos) {
        return this.delegate.a(biome, accessor, group, pos);
    }

    @Override
    public void a(GeneratorAccessSeed world, IChunkAccess chunk, StructureManager structureAccessor) {
        super.applyBiomeDecoration(world, chunk, structureAccessor, this.generator.shouldGenerateDecorations());
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
        if (this.generator.shouldGenerateMobs()) {
            this.delegate.a(region);
        }
    }

    @Override
    public int a(LevelHeightAccessor world) {
        return this.delegate.a(world);
    }

    @Override
    public int f() {
        return this.delegate.f();
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor world) {
        return this.delegate.a(x2, z2, world);
    }

    @Override
    public Climate.Sampler c() {
        return this.delegate.c();
    }

    @Override
    protected Codec<? extends ChunkGenerator> a() {
        return Codec.unit(null);
    }

    @Deprecated
    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final IChunkAccess biome;

        public CustomBiomeGrid(IChunkAccess biome) {
            this.biome = biome;
        }

        public Biome getBiome(int x2, int z2) {
            return this.getBiome(x2, 0, z2);
        }

        public void setBiome(int x2, int z2, Biome bio) {
            for (int y2 = CustomChunkGenerator.this.world.getWorld().getMinHeight(); y2 < CustomChunkGenerator.this.world.getWorld().getMaxHeight(); y2 += 4) {
                this.setBiome(x2, y2, z2, bio);
            }
        }

        public Biome getBiome(int x2, int y2, int z2) {
            return CraftBlock.biomeBaseToBiome(this.biome.biomeRegistry, this.biome.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
        }

        public void setBiome(int x2, int y2, int z2, Biome bio) {
            Preconditions.checkArgument((bio != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
            this.biome.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, CraftBlock.biomeToBiomeBase(this.biome.biomeRegistry, bio));
        }
    }
}

