/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, EntityVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityVillager getHandle() {
        return (EntityVillager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public void remove() {
        this.getHandle().gc();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftVillager.nmsToBukkitProfession(this.getHandle().fJ().b());
    }

    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().a(this.getHandle().fJ().a(CraftVillager.bukkitToNmsProfession(profession)));
    }

    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf((String)IRegistry.ap.b(this.getHandle().fJ().a()).a().toUpperCase(Locale.ROOT));
    }

    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().a(this.getHandle().fJ().a(IRegistry.ap.a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    public int getVillagerLevel() {
        return this.getHandle().fJ().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"level must be between [1, 5]");
        this.getHandle().a(this.getHandle().fJ().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().t();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (Object)"Experience must be positive");
        this.getHandle().u(experience);
    }

    public int getRestocksToday() {
        return this.getHandle().cw;
    }

    public void setRestocksToday(int restocksToday) {
        this.getHandle().cw = restocksToday;
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPosition position = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        IBlockData iblockdata = this.getHandle().t.a_(position);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().fc();
    }

    public void shakeHead() {
        this.getHandle().fW();
    }

    public static Villager.Profession nmsToBukkitProfession(VillagerProfession nms) {
        return Villager.Profession.valueOf((String)IRegistry.aq.b(nms).a().toUpperCase(Locale.ROOT));
    }

    public static VillagerProfession bukkitToNmsProfession(Villager.Profession bukkit) {
        return IRegistry.aq.a(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
    }

    public Reputation getReputation(UUID uniqueId) {
        Reputation.a rep = this.getHandle().fV().getReputations().get(uniqueId);
        if (rep == null) {
            return new Reputation((Map)Maps.newHashMap());
        }
        return rep.getPaperReputation();
    }

    public Map<UUID, Reputation> getReputations() {
        return this.getHandle().fV().getReputations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Reputation.a)entry.getValue()).getPaperReputation()));
    }

    public void setReputation(UUID uniqueId, Reputation reputation) {
        Reputation.a nmsReputation = this.getHandle().fV().getReputations().computeIfAbsent(uniqueId, key -> new Reputation.a());
        nmsReputation.assignFromPaperReputation(reputation);
    }

    public void setReputations(Map<UUID, Reputation> reputations) {
        for (Map.Entry<UUID, Reputation> entry : reputations.entrySet()) {
            this.setReputation(entry.getKey(), entry.getValue());
        }
    }

    public void clearReputations() {
        this.getHandle().fV().getReputations().clear();
    }
}

