/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.animal.EntityRabbit;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class CraftRabbit
extends CraftAnimals
implements Rabbit {
    public CraftRabbit(CraftServer server, EntityRabbit entity) {
        super(server, entity);
    }

    @Override
    public EntityRabbit getHandle() {
        return (EntityRabbit)this.entity;
    }

    @Override
    public String toString() {
        return "CraftRabbit{RabbitType=" + this.getRabbitType() + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.RABBIT;
    }

    public Rabbit.Type getRabbitType() {
        int type = this.getHandle().fz();
        return CraftMagicMapping.fromMagic(type);
    }

    public void setRabbitType(Rabbit.Type type) {
        EntityRabbit entity = this.getHandle();
        if (this.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY) {
            WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
            entity.bR = new PathfinderGoalSelector(world.ac());
            entity.bS = new PathfinderGoalSelector(world.ac());
            entity.u();
            entity.initializePathFinderGoals();
        }
        entity.t(CraftMagicMapping.toMagic(type));
    }

    private static class CraftMagicMapping {
        private static final int[] types = new int[Rabbit.Type.values().length];
        private static final Rabbit.Type[] reverse = new Rabbit.Type[Rabbit.Type.values().length];

        private CraftMagicMapping() {
        }

        private static void set(Rabbit.Type type, int value) {
            CraftMagicMapping.types[type.ordinal()] = value;
            if (value < reverse.length) {
                CraftMagicMapping.reverse[value] = type;
            }
        }

        public static Rabbit.Type fromMagic(int magic) {
            if (magic >= 0 && magic < reverse.length) {
                return reverse[magic];
            }
            if (magic == 99) {
                return Rabbit.Type.THE_KILLER_BUNNY;
            }
            return null;
        }

        public static int toMagic(Rabbit.Type type) {
            return types[type.ordinal()];
        }

        static {
            CraftMagicMapping.set(Rabbit.Type.BROWN, 0);
            CraftMagicMapping.set(Rabbit.Type.WHITE, 1);
            CraftMagicMapping.set(Rabbit.Type.BLACK, 2);
            CraftMagicMapping.set(Rabbit.Type.BLACK_AND_WHITE, 3);
            CraftMagicMapping.set(Rabbit.Type.GOLD, 4);
            CraftMagicMapping.set(Rabbit.Type.SALT_AND_PEPPER, 5);
            CraftMagicMapping.set(Rabbit.Type.THE_KILLER_BUNNY, 99);
        }
    }
}

