/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)super.getHandle();
    }

    @Override
    public EntityType getType() {
        return EntityType.PANDA;
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().fH());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().a(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().fI());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().b(CraftPanda.toNms(gene));
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

