/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class CraftItem
extends CraftEntity
implements Item {
    private static final int NO_AGE_TIME = Short.MIN_VALUE;
    private static final int NO_PICKUP_TIME = Short.MAX_VALUE;
    private final EntityItem item;

    public CraftItem(CraftServer server, Entity entity, EntityItem item) {
        super(server, entity);
        this.item = item;
    }

    public CraftItem(CraftServer server, EntityItem entity) {
        this(server, entity, entity);
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.item.h());
    }

    public void setItemStack(ItemStack stack) {
        this.item.a(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.item.aq;
    }

    public void setPickupDelay(int delay) {
        this.item.aq = Math.min(delay, Short.MAX_VALUE);
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.item.ap = value;
    }

    public boolean canMobPickup() {
        return this.item.canMobPickup;
    }

    public void setCanMobPickup(boolean canMobPickup) {
        this.item.canMobPickup = canMobPickup;
    }

    public boolean canPlayerPickup() {
        return this.item.aq != Short.MAX_VALUE;
    }

    public void setCanPlayerPickup(boolean canPlayerPickup) {
        this.item.aq = canPlayerPickup ? 0 : Short.MAX_VALUE;
    }

    public boolean willAge() {
        return this.item.ap != Short.MIN_VALUE;
    }

    public void setWillAge(boolean willAge) {
        this.item.ap = willAge ? 0 : Short.MIN_VALUE;
    }

    public int getHealth() {
        return this.item.ar;
    }

    public void setHealth(int health) {
        if (health <= 0) {
            this.item.h().a(this.item);
            this.item.ah();
        } else {
            this.item.ar = health;
        }
    }

    public void setOwner(UUID uuid) {
        this.item.b(uuid);
    }

    public UUID getOwner() {
        return this.item.i();
    }

    public void setThrower(UUID uuid) {
        this.item.c(uuid);
    }

    public UUID getThrower() {
        return this.item.j();
    }

    @Override
    public String toString() {
        return "CraftItem";
    }

    public EntityType getType() {
        return EntityType.DROPPED_ITEM;
    }
}

