/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.decoration.EntityHanging;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;

public class CraftHanging
extends CraftEntity
implements Hanging {
    public CraftHanging(CraftServer server, EntityHanging entity) {
        super(server, entity);
    }

    public BlockFace getAttachedFace() {
        return this.getFacing().getOppositeFace();
    }

    public void setFacingDirection(BlockFace face) {
        this.setFacingDirection(face, false);
    }

    public boolean setFacingDirection(BlockFace face, boolean force) {
        EntityHanging hanging = this.getHandle();
        EnumDirection dir = hanging.ct();
        switch (face) {
            case SOUTH: {
                this.getHandle().a(EnumDirection.d);
                break;
            }
            case WEST: {
                this.getHandle().a(EnumDirection.e);
                break;
            }
            case NORTH: {
                this.getHandle().a(EnumDirection.c);
                break;
            }
            case EAST: {
                this.getHandle().a(EnumDirection.f);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not a valid facing direction", face));
            }
        }
        if (!(force || this.getHandle().generation || hanging.r())) {
            hanging.a(dir);
            return false;
        }
        return true;
    }

    @Override
    public BlockFace getFacing() {
        EnumDirection direction = this.getHandle().ct();
        if (direction == null) {
            return BlockFace.SELF;
        }
        return CraftBlock.notchToBlockFace(direction);
    }

    @Override
    public EntityHanging getHandle() {
        return (EntityHanging)this.entity;
    }

    @Override
    public String toString() {
        return "CraftHanging";
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }
}

