/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.animal.EntityFox;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, EntityFox entity) {
        super(server, entity);
    }

    @Override
    public EntityFox getHandle() {
        return (EntityFox)super.getHandle();
    }

    @Override
    public EntityType getType() {
        return EntityType.FOX;
    }

    @Override
    public String toString() {
        return "CraftFox";
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().t().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().a(EntityFox.Type.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().bN();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().x(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().fy();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().v(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().B(sleeping);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        UUID uuid = this.getHandle().ai().a(EntityFox.cg).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null && this.getHandle().ai().a(EntityFox.ch).isPresent()) {
            throw new IllegalStateException("Must remove second trusted player first");
        }
        this.getHandle().ai().b(EntityFox.cg, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        UUID uuid = this.getHandle().ai().a(EntityFox.ch).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null && !this.getHandle().ai().a(EntityFox.cg).isPresent()) {
            throw new IllegalStateException("Must add first trusted player first");
        }
        this.getHandle().ai().b(EntityFox.ch, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public void setInterested(boolean interested) {
        this.getHandle().y(interested);
    }

    public boolean isInterested() {
        return this.getHandle().fI();
    }

    public void setLeaping(boolean leaping) {
        this.getHandle().w(leaping);
    }

    public boolean isLeaping() {
        return this.getHandle().fA();
    }

    public void setDefending(boolean defending) {
        this.getHandle().A(defending);
    }

    public boolean isDefending() {
        return this.getHandle().fL();
    }

    public void setFaceplanted(boolean faceplanted) {
        this.getHandle().z(faceplanted);
    }

    public boolean isFaceplanted() {
        return this.getHandle().fz();
    }
}

