/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;

public class CraftFishHook
extends CraftProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, EntityFishingHook entity) {
        super(server, entity);
    }

    @Override
    public EntityFishingHook getHandle() {
        return (EntityFishingHook)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    public int getMinWaitTime() {
        return this.getHandle().minWaitTime;
    }

    public void setMinWaitTime(int minWaitTime) {
        EntityFishingHook hook = this.getHandle();
        Validate.isTrue((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (String)"The minimum wait time should be between 0 and the maximum wait time.");
        hook.minWaitTime = minWaitTime;
    }

    public int getMaxWaitTime() {
        return this.getHandle().maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        EntityFishingHook hook = this.getHandle();
        Validate.isTrue((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (String)"The maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        hook.maxWaitTime = maxWaitTime;
    }

    public boolean getApplyLure() {
        return this.getHandle().applyLure;
    }

    public void setApplyLure(boolean applyLure) {
        this.getHandle().applyLure = applyLure;
    }

    public double getBiteChance() {
        EntityFishingHook hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.t.s(new BlockPosition(MathHelper.b(hook.dc()), MathHelper.b(hook.de()) + 1, MathHelper.b(hook.di())))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    public void setBiteChance(double chance) {
        Validate.isTrue((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (String)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }

    public boolean isInOpenWater() {
        return this.getHandle().h();
    }

    public Entity getHookedEntity() {
        net.minecraft.world.entity.Entity hooked = this.getHandle().aw;
        return hooked != null ? hooked.getBukkitEntity() : null;
    }

    public void setHookedEntity(Entity entity) {
        EntityFishingHook hook = this.getHandle();
        hook.aw = entity != null ? ((CraftEntity)entity).getHandle() : null;
        hook.ai().b(EntityFishingHook.f, hook.aw != null ? hook.aw.ae() + 1 : 0);
    }

    public boolean pullHookedEntity() {
        EntityFishingHook hook = this.getHandle();
        if (hook.aw == null) {
            return false;
        }
        hook.c(hook.aw);
        return true;
    }

    public FishHook.HookState getState() {
        return FishHook.HookState.values()[this.getHandle().ax.ordinal()];
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getHandle().i() != null) {
            this.getHandle().i().co = null;
        }
    }
}

