/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();
    private final CraftItemStack item;

    public CraftFirework(CraftServer server, EntityFireworks entity) {
        super(server, entity);
        ItemStack item = this.getHandle().ai().a(EntityFireworks.b);
        if (item.b()) {
            item = new ItemStack(Items.rz);
            this.getHandle().ai().b(EntityFireworks.b, item);
        }
        this.item = CraftItemStack.asCraftMirror(item);
        if (this.item.getType() != Material.FIREWORK_ROCKET) {
            this.item.setType(Material.FIREWORK_ROCKET);
        }
    }

    @Override
    public EntityFireworks getHandle() {
        return (EntityFireworks)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    public EntityType getType() {
        return EntityType.FIREWORK;
    }

    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)this.item.getItemMeta();
    }

    public void setFireworkMeta(FireworkMeta meta) {
        this.item.setItemMeta((ItemMeta)meta);
        this.getHandle().f = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().ai().markDirty(EntityFireworks.b);
    }

    public void detonate() {
        this.getHandle().f = 0;
    }

    public boolean isShotAtAngle() {
        return this.getHandle().i();
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().ai().b(EntityFireworks.d, shotAtAngle);
    }

    public UUID getSpawningEntity() {
        return this.getHandle().spawningEntity;
    }

    public LivingEntity getBoostedEntity() {
        EntityLiving boostedEntity = this.getHandle().ap;
        return boostedEntity != null ? (LivingEntity)boostedEntity.getBukkitEntity() : null;
    }
}

