/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1;

import com.destroystokyo.paper.HeightmapType;
import com.destroystokyo.paper.util.map.QueuedChangesMapLong2Object;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.world.MoonPhase;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_18_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_18_R1.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_18_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_18_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R1.CraftRaid;
import org.bukkit.craftbukkit.v1_18_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftSound;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_18_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private final WorldServer world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int waterAmbientSpawn = -1;
    private int waterUndergroundCreatureSpawn = -1;
    private int ambientSpawn = -1;
    private Pointers adventure$pointers;
    private static final Random rand = new Random();
    private static Map<String, GameRules.GameRuleKey<?>> gamerules;
    private static Map<String, GameRules.GameRuleDefinition<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            EntityLightning lightning = EntityTypes.U.a(CraftWorld.this.world);
            lightning.c(loc.getX(), loc.getY(), loc.getZ());
            lightning.isSilent = isSilent;
            CraftWorld.this.world.strikeLightning(lightning);
            return (LightningStrike)lightning.getBukkitEntity();
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            EntityLightning lightning = EntityTypes.U.a(CraftWorld.this.world);
            lightning.c(loc.getX(), loc.getY(), loc.getZ());
            lightning.aq = true;
            lightning.isSilent = isSilent;
            CraftWorld.this.world.strikeLightning(lightning);
            return (LightningStrike)lightning.getBukkitEntity();
        }
    };

    public int getEntityCount() {
        int ret = 0;
        for (net.minecraft.world.entity.Entity entity : this.world.I().a()) {
            if (!entity.isChunkLoaded()) continue;
            ++ret;
        }
        return ret;
    }

    public int getTileEntityCount() {
        Long2ObjectLinkedOpenHashMap<PlayerChunk> chunks = this.world.k().a.updatingChunks.getVisibleMap();
        int size = 0;
        for (PlayerChunk playerchunk : chunks.values()) {
            net.minecraft.world.level.chunk.Chunk chunk = playerchunk.d();
            if (chunk == null) continue;
            size += chunk.i.size();
        }
        return size;
    }

    public int getTickableTileEntityCount() {
        return this.world.getTotalTileEntityTickers();
    }

    public int getChunkCount() {
        int ret = 0;
        for (PlayerChunk chunkHolder : this.world.k().a.updatingChunks.getVisibleMap().values()) {
            if (chunkHolder.d() == null) continue;
            ++ret;
        }
        return ret;
    }

    public int getPlayerCount() {
        return this.world.z().size();
    }

    public MoonPhase getMoonPhase() {
        return MoonPhase.getPhase((long)(this.getFullTime() / 24000L));
    }

    public boolean lineOfSightExists(Location from, Location to) {
        Validate.notNull((Object)from, (String)"from parameter in lineOfSightExists cannot be null");
        Validate.notNull((Object)to, (String)"to parameter in lineOfSightExists cannot be null");
        if (from.getWorld() != to.getWorld()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(from.getX(), from.getY(), from.getZ());
        Vec3D vec3d1 = new Vec3D(to.getX(), to.getY(), to.getZ());
        if (vec3d1.g(vec3d) > 16384.0) {
            return false;
        }
        return this.getHandle().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, null)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public CraftWorld(WorldServer world, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.biomeProvider = biomeProvider;
        this.environment = env;
        this.monsterSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.a);
        this.animalSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.b);
        this.waterAnimalSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.f);
        this.waterAmbientSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.g);
        this.ambientSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.c);
        this.waterUndergroundCreatureSpawn = this.world.paperConfig.perWorldSpawnLimits.getInt((Object)EnumCreatureType.e);
    }

    public Block getBlockAt(int x2, int y2, int z2) {
        return CraftBlock.at(this.world, new BlockPosition(x2, y2, z2));
    }

    public int getHighestBlockYAt(int x2, int z2) {
        return this.getHighestBlockYAt(x2, z2, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(int x2, int z2, HeightmapType heightmap) throws UnsupportedOperationException {
        this.getChunkAt(x2 >> 4, z2 >> 4);
        switch (heightmap) {
            case LIGHT_BLOCKING: {
                throw new UnsupportedOperationException();
            }
            case ANY: {
                return this.world.a(HeightMap.Type.b, x2, z2);
            }
            case SOLID: {
                return this.world.a(HeightMap.Type.d, x2, z2);
            }
            case SOLID_OR_LIQUID: {
                return this.world.a(HeightMap.Type.e, x2, z2);
            }
            case SOLID_OR_LIQUID_NO_LEAVES: {
                return this.world.a(HeightMap.Type.f, x2, z2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Location getSpawnLocation() {
        BlockPosition spawn = this.world.w();
        return new Location((World)this, (double)spawn.u(), (double)spawn.v(), (double)spawn.w(), this.world.x.d(), 0.0f);
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw()) : false;
    }

    public boolean setSpawnLocation(int x2, int y2, int z2, float angle) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.a(new BlockPosition(x2, y2, z2), angle);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x2, int y2, int z2) {
        return this.setSpawnLocation(x2, y2, z2, 0.0f);
    }

    public Chunk getChunkAt(int x2, int z2) {
        net.minecraft.world.level.chunk.Chunk chunk = this.world.k().getChunkAtIfLoadedImmediately(x2, z2);
        if (chunk == null) {
            this.addTicket(x2, z2);
            chunk = this.world.k().a(x2, z2, true);
        }
        return chunk.bukkitChunk;
    }

    private void addTicket(int x2, int z2) {
        MCUtil.MAIN_EXECUTOR.execute(() -> this.world.k().a(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 0, Unit.a));
    }

    public Chunk getChunkAt(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x2, int z2) {
        return this.world.k().getChunkAtIfLoadedImmediately(x2, z2) != null;
    }

    public boolean isChunkGenerated(int x2, int z2) {
        if (!Bukkit.isPrimaryThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x2, z2), this.world.k().h).join();
        }
        IChunkAccess chunk = this.world.k().getChunkAtImmediately(x2, z2);
        if (chunk == null) {
            chunk = this.world.k().a.getUnloadingChunk(x2, z2);
        }
        if (chunk != null) {
            return chunk instanceof ProtoChunkExtension || chunk instanceof net.minecraft.world.level.chunk.Chunk;
        }
        try {
            return this.world.k().a.getChunkStatusOnDisk(new ChunkCoordIntPair(x2, z2)) == ChunkStatus.o;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk[] getLoadedChunks() {
        if (Thread.currentThread() != ((net.minecraft.world.level.World)this.world.G()).z) {
            Long2ObjectLinkedOpenHashMap chunks;
            QueuedChangesMapLong2Object<PlayerChunk> queuedChangesMapLong2Object = this.world.k().a.updatingChunks;
            synchronized (queuedChangesMapLong2Object) {
                chunks = this.world.k().a.updatingChunks.getVisibleMap().clone();
            }
            return (Chunk[])chunks.values().stream().map(PlayerChunk::getFullChunk).filter(Objects::nonNull).map(net.minecraft.world.level.chunk.Chunk::getBukkitChunk).toArray(Chunk[]::new);
        }
        Long2ObjectLinkedOpenHashMap<PlayerChunk> chunks = this.world.k().a.updatingChunks.getVisibleMap();
        return (Chunk[])chunks.values().stream().map(PlayerChunk::getFullChunk).filter(Objects::nonNull).map(net.minecraft.world.level.chunk.Chunk::getBukkitChunk).toArray(Chunk[]::new);
    }

    public void loadChunk(int x2, int z2) {
        this.loadChunk(x2, z2, true);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x2, int z2) {
        return this.unloadChunk(x2, z2, true);
    }

    public boolean unloadChunk(int x2, int z2, boolean save) {
        return this.unloadChunk0(x2, z2, save);
    }

    public boolean unloadChunkRequest(int x2, int z2) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkLoaded(x2, z2)) {
            this.world.k().b(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 0, Unit.a);
        }
        return true;
    }

    private boolean unloadChunk0(int x2, int z2, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        if (!this.isChunkLoaded(x2, z2)) {
            return true;
        }
        net.minecraft.world.level.chunk.Chunk chunk = this.world.d(x2, z2);
        chunk.mustNotSave = !save;
        this.unloadChunkRequest(x2, z2);
        this.world.k().purgeUnload();
        return !this.isChunkLoaded(x2, z2);
    }

    public boolean regenerateChunk(int x2, int z2) {
        AsyncCatcher.catchOp("chunk regenerate");
        throw new UnsupportedOperationException("Not supported in this Minecraft version! Unless you can fix it, this is not a bug :)");
    }

    public boolean refreshChunk(int x2, int z2) {
        PlayerChunk playerChunk = (PlayerChunk)this.world.k().a.updatingChunks.getVisibleMap().get(ChunkCoordIntPair.a(x2, z2));
        if (playerChunk == null) {
            return false;
        }
        playerChunk.a().thenAccept(either -> either.left().ifPresent(chunk -> {
            List<EntityPlayer> playersInRange = playerChunk.y.a(playerChunk.i(), false);
            if (playersInRange.isEmpty()) {
                return;
            }
            ClientboundLevelChunkWithLightPacket refreshPacket = new ClientboundLevelChunkWithLightPacket((net.minecraft.world.level.chunk.Chunk)chunk, this.world.l_(), null, null, true);
            for (EntityPlayer player : playersInRange) {
                if (player.b == null) continue;
                player.b.a(refreshPacket);
            }
        }));
        return true;
    }

    public boolean isChunkInUse(int x2, int z2) {
        return this.isChunkLoaded(x2, z2);
    }

    public boolean loadChunk(int x2, int z2, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        IChunkAccess immediate = this.world.k().getChunkAtIfLoadedImmediately(x2, z2);
        if (immediate != null) {
            return true;
        }
        if (!generate) {
            RegionFile file;
            if (immediate == null) {
                immediate = this.world.k().a.getUnloadingChunk(x2, z2);
            }
            if (immediate != null) {
                if (!(immediate instanceof ProtoChunkExtension) && !(immediate instanceof net.minecraft.world.level.chunk.Chunk)) {
                    return false;
                }
                this.world.k().a(TicketType.PLUGIN, chunkPos, 0, Unit.a);
                this.world.d(x2, z2);
                return true;
            }
            try {
                file = this.world.k().a.regionFileCache.getRegionFile(chunkPos, false);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            ChunkStatus status = file.getStatusIfCached(x2, z2);
            if (!file.e(chunkPos) || status != null && status != ChunkStatus.o) {
                return false;
            }
            IChunkAccess chunk = this.world.k().a(x2, z2, ChunkStatus.c, true);
            if (!(chunk instanceof ProtoChunkExtension) && !(chunk instanceof net.minecraft.world.level.chunk.Chunk)) {
                return false;
            }
        }
        this.world.k().a(TicketType.PLUGIN, chunkPos, 0, Unit.a);
        this.world.k().a(x2, z2, ChunkStatus.o, true);
        return true;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
        ((CraftChunk)this.getChunkAt((int)chunk.getX(), (int)chunk.getZ())).getHandle().bukkitChunk = chunk;
    }

    public boolean addPluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.k().a.D;
        if (chunkDistanceManager.addTicketAtLevel(TicketType.PLUGIN_TICKET, new ChunkCoordIntPair(x2, z2), 31, plugin)) {
            this.getChunkAt(x2, z2);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.k().a.D;
        return chunkDistanceManager.removeTicketAtLevel(TicketType.PLUGIN_TICKET, new ChunkCoordIntPair(x2, z2), 31, plugin);
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.k().a.D;
        chunkDistanceManager.removeAllTicketsFor(TicketType.PLUGIN_TICKET, 31, plugin);
    }

    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.k().a.D;
        ArraySetSorted tickets = (ArraySetSorted)chunkDistanceManager.h.get(ChunkCoordIntPair.a(x2, z2));
        if (tickets == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Ticket ticket : tickets) {
            if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
            ret.add((Object)((Plugin)ticket.c));
        }
        return ret.build();
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.k().a.D;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.h.long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            ArraySetSorted tickets = (ArraySetSorted)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(ChunkCoordIntPair.a(chunkKey), ChunkCoordIntPair.b(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.c, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    public boolean isChunkForceLoaded(int x2, int z2) {
        return this.getHandle().y().contains(ChunkCoordIntPair.a(x2, z2));
    }

    public void setChunkForceLoaded(int x2, int z2, boolean forced) {
        this.getHandle().a(x2, z2, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().y().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(ChunkCoordIntPair.a(coord), ChunkCoordIntPair.b(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public WorldServer getHandle() {
        return this.world;
    }

    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    public Item dropItem(Location loc, ItemStack item, Consumer<Item> function) {
        Validate.notNull((Object)item, (String)"Cannot drop a Null item.");
        EntityItem entity = new EntityItem(this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        entity.aq = 10;
        if (function != null) {
            function.accept((Object)((Item)entity.getBukkitEntity()));
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (Item)entity.getBukkitEntity();
    }

    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<Item> function) {
        double xs = (double)(this.world.w.nextFloat() * 0.5f) + 0.25;
        double ys = (double)(this.world.w.nextFloat() * 0.5f) + 0.25;
        double zs = (double)(this.world.w.nextFloat() * 0.5f) + 0.25;
        loc = loc.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs);
        return this.dropItem(loc, item, function);
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        EntityArrow arrow;
        Validate.notNull((Object)loc, (String)"Can not spawn arrow with a null location");
        Validate.notNull((Object)velocity, (String)"Can not spawn arrow with a null velocity");
        Validate.notNull(clazz, (String)"Can not spawn an arrow with no class");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = EntityTypes.d.a(this.world);
            ((EntityTippedArrow)arrow).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.aH.a(this.world) : (Trident.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.aQ.a(this.world) : (EntityArrow)EntityTypes.d.a(this.world));
        }
        arrow.b(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.b(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        EntityLightning lightning = EntityTypes.U.a(this.world);
        lightning.c(loc.getX(), loc.getY(), loc.getZ());
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        EntityLightning lightning = EntityTypes.U.a(this.world);
        lightning.c(loc.getX(), loc.getY(), loc.getZ());
        lightning.a(true);
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public Location findLightningRod(Location location) {
        return this.world.D(MCUtil.toBlockPosition(location)).map(blockPos -> MCUtil.toLocation(this.world, blockPos).subtract(0.0, 1.0, 0.0)).orElse(null);
    }

    public Location findLightningTarget(Location location) {
        BlockPosition pos = this.world.findLightningTargetAround(MCUtil.toBlockPosition(location), true);
        return pos == null ? null : MCUtil.toLocation(this.world, pos);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockState blockState : this.world.capturedBlockStates.values()) {
                BlockPosition position = ((CraftBlockState)blockState).getPosition();
                IBlockData oldBlock = this.world.a_(position);
                int flag = ((CraftBlockState)blockState).getFlag();
                delegate.setBlockData(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getBlockData());
                IBlockData newBlock = this.world.a_(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flag, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.N.g();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.W();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.W());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.b(this.world.W() + event.getSkipAmount());
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p2;
            if (cp.getHandle().b == null) continue;
            cp.getHandle().b.a(new PacketPlayOutUpdateTime(cp.getHandle().t.V(), cp.getHandle().getPlayerTime(), cp.getHandle().t.X().b(GameRules.k)));
        }
    }

    public boolean isDayTime() {
        return this.getHandle().P();
    }

    public long getGameTime() {
        return this.world.x.e();
    }

    public boolean createExplosion(double x2, double y2, double z2, float power) {
        return this.createExplosion(x2, y2, z2, power, false, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire) {
        return this.createExplosion(x2, y2, z2, power, setFire, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x2, y2, z2, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return !this.world.a((net.minecraft.world.entity.Entity)(source == null ? null : ((CraftEntity)source).getHandle()), (double)x2, (double)y2, (double)z2, (float)power, (boolean)setFire, (Explosion.Effect)(breakBlocks ? Explosion.Effect.b : Explosion.Effect.a)).wasCanceled;
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks) {
        return !this.world.a((net.minecraft.world.entity.Entity)(source != null ? ((CraftEntity)source).getHandle() : null), (double)loc.getX(), (double)loc.getY(), (double)loc.getZ(), (float)power, (boolean)setFire, (Explosion.Effect)(breakBlocks ? Explosion.Effect.b : Explosion.Effect.a)).wasCanceled;
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    public Block getHighestBlockAt(int x2, int z2) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2), z2);
    }

    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        return this.world.d(x2 >> 4, z2 >> 4).a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public Block getHighestBlockAt(int x2, int z2, HeightMap heightMap) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2, heightMap), z2);
    }

    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public Biome getBiome(int x2, int z2) {
        return this.getBiome(x2, 0, z2);
    }

    public void setBiome(int x2, int z2, Biome bio) {
        for (int y2 = this.getMinHeight(); y2 < this.getMaxHeight(); ++y2) {
            this.setBiome(x2, y2, z2, bio);
        }
    }

    @Override
    public void setBiome(int x2, int y2, int z2, BiomeBase bb) {
        net.minecraft.world.level.chunk.Chunk chunk;
        BlockPosition pos = new BlockPosition(x2, 0, z2);
        if (this.world.C(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, bb);
            chunk.a(true);
        }
    }

    public double getTemperature(int x2, int z2) {
        return this.getTemperature(x2, 0, z2);
    }

    public double getTemperature(int x2, int y2, int z2) {
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        return this.world.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2).f(pos);
    }

    public double getHumidity(int x2, int z2) {
        return this.getHumidity(x2, 0, z2);
    }

    public double getHumidity(int x2, int y2, int z2) {
        return this.world.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2).h();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<net.minecraft.world.entity.Entity> getNMSEntities() {
        return this.getHandle().I().a();
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2) {
        return this.getNearbyEntities(location, x2, y2, z2, null);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2, Predicate<Entity> filter) {
        Validate.notNull((Object)location, (String)"Location is null!");
        Validate.isTrue((boolean)this.equals(location.getWorld()), (String)"Location is from different world!");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x2, (double)y2, (double)z2);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<Entity> filter) {
        AsyncCatcher.catchOp("getNearbyEntities");
        Validate.notNull((Object)boundingBox, (String)"Bounding box is null!");
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.getHandle().a((net.minecraft.world.entity.Entity)null, bb, (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.world.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        Validate.isTrue((boolean)this.equals(start.getWorld()), (String)"Start location is from different world!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        Validate.isTrue((boolean)this.equals(start.getWorld()), (String)"Start location is from different world!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        Validate.notNull((Object)fluidCollisionMode, (String)"Fluid collision mode is null!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3D startPos = new Vec3D(start.getX(), start.getY(), start.getZ());
        Vec3D endPos = new Vec3D(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        MovingObjectPositionBlock nmsHitResult = this.getHandle().a(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, CraftFluidCollisionMode.toNMS(fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS(this, nmsHitResult);
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.z().size());
        for (EntityHuman entityHuman : this.world.z()) {
            CraftHumanEntity bukkitEntity = entityHuman.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)bukkitEntity);
        }
        return list;
    }

    public Entity getEntity(UUID uuid) {
        Validate.notNull((Object)uuid, (String)"UUID cannot be null");
        net.minecraft.world.entity.Entity entity = this.world.a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void save() {
        AsyncCatcher.catchOp("world save");
        this.server.checkSaveState();
        boolean oldSave = this.world.b;
        this.world.b = false;
        this.world.a(null, false, false);
        this.world.b = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.b;
    }

    public void setAutoSave(boolean value) {
        this.world.b = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().N.a(EnumDifficulty.a(difficulty.getValue()));
    }

    public Difficulty getDifficulty() {
        return Difficulty.getByValue((int)this.getHandle().af().ordinal());
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.x.k();
    }

    public void setStorm(boolean hasStorm) {
        this.world.N.setRaining(hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.N.l();
    }

    public void setWeatherDuration(int duration) {
        this.world.N.f(duration);
    }

    public boolean isThundering() {
        return this.world.x.i();
    }

    public void setThundering(boolean thundering) {
        this.world.N.setThundering(thundering, ThunderChangeEvent.Cause.PLUGIN);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.N.j();
    }

    public void setThunderDuration(int duration) {
        this.world.N.e(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.N.a(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.N.h();
    }

    public long getSeed() {
        return this.world.E();
    }

    public boolean getPVP() {
        return this.world.pvpMode;
    }

    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)effect, (String)"Effect cannot be null");
        Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().b == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().b.a(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Validate.notNull((Object)data, (String)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)material, (String)"Material cannot be null");
        Validate.isTrue((boolean)material.isBlock(), (String)"Material must be a block");
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), CraftMagicNumbers.getBlock(material).n());
        entity.b = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)data, (String)"Material cannot be null");
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.b = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x2, z2, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.b(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.k().l;
    }

    public boolean getAllowMonsters() {
        return this.world.k().k;
    }

    public int getMinHeight() {
        return this.world.u_();
    }

    public int getMaxHeight() {
        return this.world.ag();
    }

    public int getLogicalHeight() {
        return this.world.q_().m();
    }

    public boolean isNatural() {
        return this.world.q_().e();
    }

    public boolean isBedWorks() {
        return this.world.q_().h();
    }

    public boolean hasSkyLight() {
        return this.world.q_().b();
    }

    public boolean hasCeiling() {
        return this.world.q_().c();
    }

    public boolean isPiglinSafe() {
        return this.world.q_().g();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.q_().i();
    }

    public boolean hasRaids() {
        return this.world.q_().j();
    }

    public boolean isUltraWarm() {
        return this.world.q_().d();
    }

    public int getSeaLevel() {
        return this.world.m_();
    }

    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        if (keepLoaded == this.world.keepSpawnInMemory) {
            return;
        }
        this.world.keepSpawnInMemory = keepLoaded;
        BlockPosition chunkcoordinates = this.world.w();
        if (keepLoaded) {
            this.world.addTicketsForSpawn(this.world.paperConfig.keepLoadedRange, chunkcoordinates);
        } else {
            this.world.removeTicketsForSpawn(this.world.paperConfig.keepLoadedRange, chunkcoordinates);
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public File getWorldFolder() {
        return this.world.convertable.a(SavedFile.i).toFile().getParentFile();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.D() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.N.A().b();
    }

    public boolean isHardcore() {
        return this.world.n_().n();
    }

    public void setHardcore(boolean hardcore) {
        this.world.N.e.c = hardcore;
    }

    public long getTicksPerAnimalSpawns() {
        return this.world.ticksPerAnimalSpawns;
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.world.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    public long getTicksPerMonsterSpawns() {
        return this.world.ticksPerMonsterSpawns;
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.world.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    public long getTicksPerWaterSpawns() {
        return this.world.ticksPerWaterSpawns;
    }

    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.world.ticksPerWaterSpawns = ticksPerWaterSpawns;
    }

    public long getTicksPerWaterAmbientSpawns() {
        return this.world.ticksPerWaterAmbientSpawns;
    }

    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.world.ticksPerWaterAmbientSpawns = ticksPerWaterAmbientSpawns;
    }

    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.world.ticksPerWaterUndergroundCreatureSpawns;
    }

    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.world.ticksPerWaterUndergroundCreatureSpawns = ticksPerWaterUndergroundCreatureSpawns;
    }

    public long getTicksPerAmbientSpawns() {
        return this.world.ticksPerAmbientSpawns;
    }

    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.world.ticksPerAmbientSpawns = ticksPerAmbientSpawns;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public int getMonsterSpawnLimit() {
        if (this.monsterSpawn < 0) {
            return this.server.getMonsterSpawnLimit();
        }
        return this.monsterSpawn;
    }

    public void setMonsterSpawnLimit(int limit) {
        this.monsterSpawn = limit;
    }

    public int getAnimalSpawnLimit() {
        if (this.animalSpawn < 0) {
            return this.server.getAnimalSpawnLimit();
        }
        return this.animalSpawn;
    }

    public void setAnimalSpawnLimit(int limit) {
        this.animalSpawn = limit;
    }

    public int getWaterAnimalSpawnLimit() {
        if (this.waterAnimalSpawn < 0) {
            return this.server.getWaterAnimalSpawnLimit();
        }
        return this.waterAnimalSpawn;
    }

    public void setWaterAnimalSpawnLimit(int limit) {
        this.waterAnimalSpawn = limit;
    }

    public int getWaterAmbientSpawnLimit() {
        if (this.waterAmbientSpawn < 0) {
            return this.server.getWaterAmbientSpawnLimit();
        }
        return this.waterAmbientSpawn;
    }

    public void setWaterAmbientSpawnLimit(int limit) {
        this.waterAmbientSpawn = limit;
    }

    public int getWaterUndergroundCreatureSpawnLimit() {
        if (this.waterUndergroundCreatureSpawn < 0) {
            return this.server.getWaterUndergroundCreatureSpawnLimit();
        }
        return this.waterUndergroundCreatureSpawn;
    }

    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.waterUndergroundCreatureSpawn = limit;
    }

    public int getAmbientSpawnLimit() {
        if (this.ambientSpawn < 0) {
            return this.server.getAmbientSpawnLimit();
        }
        return this.ambientSpawn;
    }

    public void setAmbientSpawnLimit(int limit) {
        this.ambientSpawn = limit;
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(null, x2, y2, z2, CraftSound.getSoundEffect(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        PacketPlayOutCustomSoundEffect packet = new PacketPlayOutCustomSoundEffect(new MinecraftKey(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), new Vec3D(x2, y2, z2), volume, pitch);
        this.world.n().ac().a(null, x2, y2, z2, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.aa(), packet);
    }

    public static synchronized Map<String, GameRules.GameRuleKey<?>> getGameRulesNMS() {
        if (gamerules != null) {
            return gamerules;
        }
        final HashMap gamerules = new HashMap();
        GameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gamerules.put(key.a(), key);
            }
        });
        CraftWorld.gamerules = gamerules;
        return CraftWorld.gamerules;
    }

    public static synchronized Map<String, GameRules.GameRuleDefinition<?>> getGameRuleDefinitions() {
        if (gameruleDefinitions != null) {
            return gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        GameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gameruleDefinitions.put(key.a(), type);
            }
        });
        CraftWorld.gameruleDefinitions = gameruleDefinitions;
        return CraftWorld.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().X().a(CraftWorld.getGameRulesNMS().get(rule));
        return value != null ? ((GameRules.GameRuleValue)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().X().a(CraftWorld.getGameRulesNMS().get(rule));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).a(this.getHandle().n());
        return true;
    }

    public String[] getGameRules() {
        return CraftWorld.getGameRulesNMS().keySet().toArray(new String[CraftWorld.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Validate.isTrue((rule != null && !rule.isEmpty() ? 1 : 0) != 0, (String)"Rule cannot be null nor empty");
        return CraftWorld.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        return this.convert(rule, (GameRules.GameRuleValue<?>)this.getHandle().X().a(CraftWorld.getGameRulesNMS().get(rule.getName())));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        return this.convert(rule, (GameRules.GameRuleValue<?>)CraftWorld.getGameRuleDefinitions().get(rule.getName()).a());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        Validate.notNull(newValue, (String)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, rule, String.valueOf(newValue));
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().X().a(CraftWorld.getGameRulesNMS().get(rule.getName()));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).a(this.getHandle().n());
        return true;
    }

    private <T> T convert(GameRule<T> rule, GameRules.GameRuleValue<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.GameRuleBoolean) {
            return rule.getType().cast(((GameRules.GameRuleBoolean)value).a());
        }
        if (value instanceof GameRules.GameRuleInt) {
            return rule.getType().cast(value.c());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + value + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, null, null, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, List<Player> receivers, Player sender, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        this.getHandle().sendParticles(receivers == null ? this.getHandle().z() : receivers.stream().map(player -> ((CraftPlayer)player).getHandle()).collect(Collectors.toList()), sender != null ? ((CraftPlayer)sender).getHandle() : null, CraftParticle.toNMS(particle, data), x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, force);
    }

    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        BlockPosition originPos = new BlockPosition(origin.getX(), origin.getY(), origin.getZ());
        BlockPosition nearest = this.getHandle().k().g().a(this.getHandle(), (StructureGenerator)StructureGenerator.b.get((Object)structureType.getName()), originPos, radius, findUnexplored);
        return nearest == null ? null : new Location((World)this, (double)nearest.u(), (double)nearest.v(), (double)nearest.w());
    }

    public Location locateNearestBiome(Location origin, Biome biome, int radius) {
        return this.locateNearestBiome(origin, biome, radius, 8);
    }

    public Location locateNearestBiome(Location origin, Biome biome, int radius, int step) {
        BlockPosition originPos = new BlockPosition(origin.getX(), origin.getY(), origin.getZ());
        BlockPosition nearest = this.getHandle().a(CraftBlock.biomeToBiomeBase(this.getHandle().t().d(IRegistry.aR), biome), originPos, radius, step);
        return nearest == null ? null : new Location((World)this, (double)nearest.u(), (double)nearest.v(), (double)nearest.w());
    }

    public boolean isUltrawarm() {
        return this.getHandle().q_().d();
    }

    public double getCoordinateScale() {
        return this.getHandle().q_().f();
    }

    public boolean hasSkylight() {
        return this.getHandle().q_().b();
    }

    public boolean hasBedrockCeiling() {
        return this.getHandle().q_().b();
    }

    public boolean doesBedWork() {
        return this.getHandle().q_().h();
    }

    public boolean doesRespawnAnchorWork() {
        return this.getHandle().q_().i();
    }

    public boolean isFixedTime() {
        return this.getHandle().q_().o();
    }

    public Collection<Material> getInfiniburn() {
        return Sets.newHashSet((Iterator)Iterators.transform(this.getHandle().q_().p().b().iterator(), CraftMagicNumbers::getMaterial));
    }

    public void sendGameEvent(Entity sourceEntity, GameEvent gameEvent, Vector position) {
        this.getHandle().a(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, IRegistry.T.a(CraftNamespacedKey.toMinecraft(gameEvent.getKey())), CraftVector.toBlockPos(position));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.isTrue((radius >= 0 ? 1 : 0) != 0, (String)"Radius cannot be negative");
        PersistentRaid persistentRaid = this.world.B();
        net.minecraft.world.entity.raid.Raid raid = persistentRaid.a(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), radius * radius);
        return raid == null ? null : new CraftRaid(raid);
    }

    public List<Raid> getRaids() {
        PersistentRaid persistentRaid = this.world.B();
        return persistentRaid.b.values().stream().map(CraftRaid::new).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().F() == null ? null : new CraftDragonBattle(this.getHandle().F());
    }

    public CompletableFuture<Chunk> getChunkAtAsync(int x2, int z2, boolean gen, boolean urgent) {
        if (Bukkit.isPrimaryThread()) {
            net.minecraft.world.level.chunk.Chunk immediate = this.world.k().getChunkAtIfLoadedImmediately(x2, z2);
            if (immediate != null) {
                return CompletableFuture.completedFuture(immediate.getBukkitChunk());
            }
        } else {
            CompletableFuture<Chunk> future = new CompletableFuture<Chunk>();
            this.world.n().execute(() -> this.getChunkAtAsync(x2, z2, gen, urgent).whenComplete((chunk, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else {
                    future.complete((Chunk)chunk);
                }
            }));
            return future;
        }
        if (!urgent) {
            this.world.k().markHighPriority(new ChunkCoordIntPair(x2, z2), 1);
        }
        return this.world.k().getChunkAtAsynchronously(x2, z2, gen, urgent).thenComposeAsync(either -> {
            net.minecraft.world.level.chunk.Chunk chunk = either.left().orElse(null);
            if (chunk != null) {
                this.addTicket(x2, z2);
            }
            return CompletableFuture.completedFuture(chunk == null ? null : chunk.getBukkitChunk());
        }, (Executor)MinecraftServer.getServer());
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.aa().a());
    }

    public int getViewDistance() {
        return this.world.spigotConfig.viewDistance;
    }

    public int getSimulationDistance() {
        return this.world.spigotConfig.simulationDistance;
    }

    public void setViewDistance(int viewDistance) {
        throw new UnsupportedOperationException();
    }

    public int getNoTickViewDistance() {
        throw new UnsupportedOperationException();
    }

    public void setNoTickViewDistance(int viewDistance) {
        throw new UnsupportedOperationException();
    }

    public int getSendViewDistance() {
        throw new UnsupportedOperationException();
    }

    public void setSendViewDistance(int viewDistance) {
        throw new UnsupportedOperationException();
    }

    public World.Spigot spigot() {
        return this.spigot;
    }

    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUID).build();
        }
        return this.adventure$pointers;
    }
}

