/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.math.Vector3fa;
import java.util.EnumSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec2F;

public class Vec3D
implements IPosition {
    public static final Vec3D a = new Vec3D(0.0, 0.0, 0.0);
    public final double b;
    public final double c;
    public final double d;

    public static Vec3D a(int rgb) {
        double d2 = (double)(rgb >> 16 & 0xFF) / 255.0;
        double e2 = (double)(rgb >> 8 & 0xFF) / 255.0;
        double f2 = (double)(rgb & 0xFF) / 255.0;
        return new Vec3D(d2, e2, f2);
    }

    public static Vec3D a(BaseBlockPosition vec) {
        return new Vec3D((double)vec.u() + 0.5, (double)vec.v() + 0.5, (double)vec.w() + 0.5);
    }

    public static Vec3D b(BaseBlockPosition vec) {
        return new Vec3D(vec.u(), vec.v(), vec.w());
    }

    public static Vec3D c(BaseBlockPosition vec) {
        return new Vec3D((double)vec.u() + 0.5, vec.v(), (double)vec.w() + 0.5);
    }

    public static Vec3D a(BaseBlockPosition vec, double deltaY) {
        return new Vec3D((double)vec.u() + 0.5, (double)vec.v() + deltaY, (double)vec.w() + 0.5);
    }

    public Vec3D(double x2, double y2, double z2) {
        this.b = x2;
        this.c = y2;
        this.d = z2;
    }

    public Vec3D(Vector3fa vec) {
        this(vec.a(), vec.b(), vec.c());
    }

    public Vec3D a(Vec3D vec) {
        return new Vec3D(vec.b - this.b, vec.c - this.c, vec.d - this.d);
    }

    public Vec3D d() {
        double d2 = Math.sqrt(this.b * this.b + this.c * this.c + this.d * this.d);
        if (d2 < 1.0E-4) {
            return a;
        }
        return new Vec3D(this.b / d2, this.c / d2, this.d / d2);
    }

    public double b(Vec3D vec) {
        return this.b * vec.b + this.c * vec.c + this.d * vec.d;
    }

    public Vec3D c(Vec3D vec) {
        return new Vec3D(this.c * vec.d - this.d * vec.c, this.d * vec.b - this.b * vec.d, this.b * vec.c - this.c * vec.b);
    }

    public Vec3D d(Vec3D vec) {
        return this.a(vec.b, vec.c, vec.d);
    }

    public Vec3D a(double x2, double y2, double z2) {
        return this.b(-x2, -y2, -z2);
    }

    public Vec3D e(Vec3D vec) {
        return this.b(vec.b, vec.c, vec.d);
    }

    public Vec3D b(double x2, double y2, double z2) {
        return new Vec3D(this.b + x2, this.c + y2, this.d + z2);
    }

    public boolean a(IPosition pos, double radius) {
        return this.c(pos.a(), pos.b(), pos.c()) < radius * radius;
    }

    public double f(Vec3D vec) {
        double d2 = vec.b - this.b;
        double e2 = vec.c - this.c;
        double f2 = vec.d - this.d;
        return Math.sqrt(d2 * d2 + e2 * e2 + f2 * f2);
    }

    public double g(Vec3D vec) {
        double d2 = vec.b - this.b;
        double e2 = vec.c - this.c;
        double f2 = vec.d - this.d;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public double c(double x2, double y2, double z2) {
        double d2 = x2 - this.b;
        double e2 = y2 - this.c;
        double f2 = z2 - this.d;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public Vec3D a(double value) {
        return this.d(value, value, value);
    }

    public Vec3D e() {
        return this.a(-1.0);
    }

    public Vec3D h(Vec3D vec) {
        return this.d(vec.b, vec.c, vec.d);
    }

    public Vec3D d(double x2, double y2, double z2) {
        return new Vec3D(this.b * x2, this.c * y2, this.d * z2);
    }

    public double f() {
        return Math.sqrt(this.b * this.b + this.c * this.c + this.d * this.d);
    }

    public double g() {
        return this.b * this.b + this.c * this.c + this.d * this.d;
    }

    public double h() {
        return Math.sqrt(this.b * this.b + this.d * this.d);
    }

    public double i() {
        return this.b * this.b + this.d * this.d;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Vec3D)) {
            return false;
        }
        Vec3D vec3 = (Vec3D)object;
        if (Double.compare(vec3.b, this.b) != 0) {
            return false;
        }
        if (Double.compare(vec3.c, this.c) != 0) {
            return false;
        }
        return Double.compare(vec3.d, this.d) == 0;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.b);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.c);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.d);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        return i2;
    }

    @Override
    public String toString() {
        return "(" + this.b + ", " + this.c + ", " + this.d + ")";
    }

    public Vec3D a(Vec3D to, double delta) {
        return new Vec3D(MathHelper.d(delta, this.b, to.b), MathHelper.d(delta, this.c, to.c), MathHelper.d(delta, this.d, to.d));
    }

    public Vec3D a(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.b;
        double e2 = this.c * (double)f2 + this.d * (double)g2;
        double h2 = this.d * (double)f2 - this.c * (double)g2;
        return new Vec3D(d2, e2, h2);
    }

    public Vec3D b(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.b * (double)f2 + this.d * (double)g2;
        double e2 = this.c;
        double h2 = this.d * (double)f2 - this.b * (double)g2;
        return new Vec3D(d2, e2, h2);
    }

    public Vec3D c(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.b * (double)f2 + this.c * (double)g2;
        double e2 = this.c * (double)f2 - this.b * (double)g2;
        double h2 = this.d;
        return new Vec3D(d2, e2, h2);
    }

    public static Vec3D a(Vec2F polar) {
        return Vec3D.a(polar.i, polar.j);
    }

    public static Vec3D a(float pitch, float yaw) {
        float f2 = MathHelper.b(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float g2 = MathHelper.a(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float h2 = -MathHelper.b(-pitch * ((float)Math.PI / 180));
        float i2 = MathHelper.a(-pitch * ((float)Math.PI / 180));
        return new Vec3D(g2 * h2, i2, f2 * h2);
    }

    public Vec3D a(EnumSet<EnumDirection.EnumAxis> axes) {
        double d2 = axes.contains(EnumDirection.EnumAxis.a) ? (double)MathHelper.b(this.b) : this.b;
        double e2 = axes.contains(EnumDirection.EnumAxis.b) ? (double)MathHelper.b(this.c) : this.c;
        double f2 = axes.contains(EnumDirection.EnumAxis.c) ? (double)MathHelper.b(this.d) : this.d;
        return new Vec3D(d2, e2, f2);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.b, this.c, this.d);
    }

    public Vec3D a(EnumDirection.EnumAxis axis, double value) {
        double d2 = axis == EnumDirection.EnumAxis.a ? value : this.b;
        double e2 = axis == EnumDirection.EnumAxis.b ? value : this.c;
        double f2 = axis == EnumDirection.EnumAxis.c ? value : this.d;
        return new Vec3D(d2, e2, f2);
    }

    @Override
    @Override
    public final double a() {
        return this.b;
    }

    @Override
    @Override
    public final double b() {
        return this.c;
    }

    @Override
    @Override
    public final double c() {
        return this.d;
    }
}

