/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSelector {
    final LootEntryAbstract[] a;
    final LootItemCondition[] b;
    private final Predicate<LootTableInfo> c;
    final LootItemFunction[] d;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> e;
    final NumberProvider f;
    final NumberProvider g;

    LootSelector(LootEntryAbstract[] entries, LootItemCondition[] conditions, LootItemFunction[] functions, NumberProvider rolls, NumberProvider bonusRolls) {
        this.a = entries;
        this.b = conditions;
        this.c = LootItemConditions.a(conditions);
        this.d = functions;
        this.e = LootItemFunctions.a(functions);
        this.f = rolls;
        this.g = bonusRolls;
    }

    private void b(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
        Random random = context.a();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableInt = new MutableInt();
        for (LootEntryAbstract lootPoolEntryContainer : this.a) {
            lootPoolEntryContainer.expand(context, choice -> {
                int i2 = choice.a(context.b());
                if (i2 > 0) {
                    list.add(choice);
                    mutableInt.add(i2);
                }
            });
        }
        int i2 = list.size();
        if (mutableInt.intValue() == 0 || i2 == 0) {
            return;
        }
        if (i2 == 1) {
            ((LootEntry)list.get(0)).a(lootConsumer, context);
            return;
        }
        int j2 = random.nextInt(mutableInt.intValue());
        for (LootEntry lootPoolEntry : list) {
            if ((j2 -= lootPoolEntry.a(context.b())) >= 0) continue;
            lootPoolEntry.a(lootConsumer, context);
            return;
        }
    }

    public void a(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
        if (!this.c.test(context)) {
            return;
        }
        Consumer<ItemStack> consumer = LootItemFunction.a(this.e, lootConsumer, context);
        int i2 = this.f.a(context) + MathHelper.d(this.g.b(context) * context.b());
        for (int j2 = 0; j2 < i2; ++j2) {
            this.b(consumer, context);
        }
    }

    public void a(LootCollector reporter) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2].a(reporter.b(".condition[" + i2 + "]"));
        }
        for (int j2 = 0; j2 < this.d.length; ++j2) {
            this.d[j2].a(reporter.b(".functions[" + j2 + "]"));
        }
        for (int k2 = 0; k2 < this.a.length; ++k2) {
            this.a[k2].a(reporter.b(".entries[" + k2 + "]"));
        }
        this.f.a(reporter.b(".rolls"));
        this.g.a(reporter.b(".bonusRolls"));
    }

    public static a a() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a>,
    LootItemConditionUser<a> {
        private final List<LootEntryAbstract> a = Lists.newArrayList();
        private final List<LootItemCondition> b = Lists.newArrayList();
        private final List<LootItemFunction> c = Lists.newArrayList();
        private NumberProvider d = ConstantValue.a(1.0f);
        private NumberProvider e = ConstantValue.a(0.0f);

        public a a(NumberProvider rolls) {
            this.d = rolls;
            return this;
        }

        @Override
        public a a() {
            return this;
        }

        public a b(NumberProvider bonusRolls) {
            this.e = bonusRolls;
            return this;
        }

        public a a(LootEntryAbstract.a<?> entry) {
            this.a.add(entry.b());
            return this;
        }

        @Override
        public a a(LootItemCondition.a builder) {
            this.b.add(builder.build());
            return this;
        }

        @Override
        public a a(LootItemFunction.a builder) {
            this.c.add(builder.b());
            return this;
        }

        public LootSelector b() {
            if (this.d == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootSelector(this.a.toArray(new LootEntryAbstract[0]), this.b.toArray(new LootItemCondition[0]), this.c.toArray(new LootItemFunction[0]), this.d, this.e);
        }

        @Override
        public /* synthetic */ Object c() {
            return this.a();
        }

        @Override
        public /* synthetic */ Object b(LootItemFunction.a function) {
            return this.a(function);
        }

        @Override
        public /* synthetic */ Object b(LootItemCondition.a condition) {
            return this.a(condition);
        }
    }

    public static class b
    implements JsonDeserializer<LootSelector>,
    JsonSerializer<LootSelector> {
        @Override
        public LootSelector a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = ChatDeserializer.m(jsonElement, "loot pool");
            LootEntryAbstract[] lootPoolEntryContainers = ChatDeserializer.a(jsonObject, "entries", jsonDeserializationContext, LootEntryAbstract[].class);
            LootItemCondition[] lootItemConditions = ChatDeserializer.a(jsonObject, "conditions", new LootItemCondition[0], jsonDeserializationContext, LootItemCondition[].class);
            LootItemFunction[] lootItemFunctions = ChatDeserializer.a(jsonObject, "functions", new LootItemFunction[0], jsonDeserializationContext, LootItemFunction[].class);
            NumberProvider numberProvider = ChatDeserializer.a(jsonObject, "rolls", jsonDeserializationContext, NumberProvider.class);
            NumberProvider numberProvider2 = ChatDeserializer.a(jsonObject, "bonus_rolls", ConstantValue.a(0.0f), jsonDeserializationContext, NumberProvider.class);
            return new LootSelector(lootPoolEntryContainers, lootItemConditions, lootItemFunctions, numberProvider, numberProvider2);
        }

        @Override
        public JsonElement a(LootSelector lootPool, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("rolls", jsonSerializationContext.serialize((Object)lootPool.f));
            jsonObject.add("bonus_rolls", jsonSerializationContext.serialize((Object)lootPool.g));
            jsonObject.add("entries", jsonSerializationContext.serialize((Object)lootPool.a));
            if (!ArrayUtils.isEmpty((Object[])lootPool.b)) {
                jsonObject.add("conditions", jsonSerializationContext.serialize((Object)lootPool.b));
            }
            if (!ArrayUtils.isEmpty((Object[])lootPool.d)) {
                jsonObject.add("functions", jsonSerializationContext.serialize((Object)lootPool.d));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((LootSelector)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

