/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.MinecraftSerializableUUID;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger d = LogManager.getLogger();
    protected static final String a = "WorldGenSettings";
    public WorldSettings e;
    private final GeneratorSettings f;
    private final Lifecycle g;
    private int h;
    private int i;
    private int j;
    private float k;
    private long l;
    private long m;
    @Nullable
    private final DataFixer n;
    private final int o;
    private boolean p;
    @Nullable
    private NBTTagCompound q;
    private final int r;
    private int s;
    private boolean t;
    private int u;
    private boolean v;
    private int w;
    private boolean x;
    private boolean y;
    private WorldBorder.c z;
    private NBTTagCompound A;
    @Nullable
    private NBTTagCompound B;
    private int C;
    private int D;
    @Nullable
    private UUID E;
    private final Set<String> F;
    private boolean G;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> H;
    public WorldServer world;

    private WorldDataServer(@Nullable DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, boolean modded, int spawnX, int spawnY, int spawnZ, float spawnAngle, long time, long timeOfDay, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.c worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> serverBrands, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, NBTTagCompound dragonFight, WorldSettings levelInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        this.n = dataFixer;
        this.G = modded;
        this.h = spawnX;
        this.i = spawnY;
        this.j = spawnZ;
        this.k = spawnAngle;
        this.l = time;
        this.m = timeOfDay;
        this.r = version;
        this.s = clearWeatherTime;
        this.u = rainTime;
        this.t = raining;
        this.w = thunderTime;
        this.v = thundering;
        this.x = initialized;
        this.y = difficultyLocked;
        this.z = worldBorder;
        this.C = wanderingTraderSpawnDelay;
        this.D = wanderingTraderSpawnChance;
        this.E = wanderingTraderId;
        this.F = serverBrands;
        this.q = playerData;
        this.o = dataVersion;
        this.H = scheduledEvents;
        this.B = customBossEvents;
        this.A = dragonFight;
        this.e = levelInfo;
        this.f = generatorOptions;
        this.g = lifecycle;
    }

    public WorldDataServer(WorldSettings levelInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        this(null, SharedConstants.b().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.e, 0, 0, null, Sets.newLinkedHashSet(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, new NBTTagCompound(), levelInfo.h(), generatorOptions, lifecycle);
    }

    public static WorldDataServer a(Dynamic<NBTBase> dynamic, DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, WorldSettings levelInfo, LevelVersion saveVersionInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        long j2 = dynamic.get("Time").asLong(0L);
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (NBTBase)dynamic.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new WorldDataServer(dataFixer, dataVersion, playerData, dynamic.get("WasModded").asBoolean(false), dynamic.get("SpawnX").asInt(0), dynamic.get("SpawnY").asInt(0), dynamic.get("SpawnZ").asInt(0), dynamic.get("SpawnAngle").asFloat(0.0f), j2, dynamic.get("DayTime").asLong(j2), saveVersionInfo.a(), dynamic.get("clearWeatherTime").asInt(0), dynamic.get("rainTime").asInt(0), dynamic.get("raining").asBoolean(false), dynamic.get("thunderTime").asInt(0), dynamic.get("thundering").asBoolean(false), dynamic.get("initialized").asBoolean(true), dynamic.get("DifficultyLocked").asBoolean(false), WorldBorder.c.a(dynamic, WorldBorder.e), dynamic.get("WanderingTraderSpawnDelay").asInt(0), dynamic.get("WanderingTraderSpawnChance").asInt(0), dynamic.get("WanderingTraderId").read(MinecraftSerializableUUID.a).result().orElse(null), dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> SystemUtils.a(dynamic1.asString().result())).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream()), (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue(), nbttagcompound1, levelInfo, generatorOptions, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registryManager, @Nullable NBTTagCompound playerNbt) {
        this.J();
        if (playerNbt == null) {
            playerNbt = this.q;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(registryManager, nbttagcompound1, playerNbt);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom registryManager, NBTTagCompound levelNbt, @Nullable NBTTagCompound playerNbt) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = this.F.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        levelNbt.a("ServerBrands", nbttaglist);
        levelNbt.a("WasModded", this.G);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().getName());
        nbttagcompound2.a("Id", SharedConstants.b().b().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().isStable());
        nbttagcompound2.a("Series", SharedConstants.b().b().b());
        levelNbt.a("Version", nbttagcompound2);
        levelNbt.a("DataVersion", SharedConstants.b().getWorldVersion());
        RegistryWriteOps<NBTBase> registrywriteops = RegistryWriteOps.a(DynamicOpsNBT.a, registryManager);
        DataResult dataresult = GeneratorSettings.a.encodeStart(registrywriteops, (Object)this.f);
        Logger logger = d;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> levelNbt.a(a, (NBTBase)nbtbase));
        levelNbt.a("GameType", this.e.b().a());
        levelNbt.a("SpawnX", this.h);
        levelNbt.a("SpawnY", this.i);
        levelNbt.a("SpawnZ", this.j);
        levelNbt.a("SpawnAngle", this.k);
        levelNbt.a("Time", this.l);
        levelNbt.a("DayTime", this.m);
        levelNbt.a("LastPlayed", SystemUtils.e());
        levelNbt.a("LevelName", this.e.a());
        levelNbt.a("version", 19133);
        levelNbt.a("clearWeatherTime", this.s);
        levelNbt.a("rainTime", this.u);
        levelNbt.a("raining", this.t);
        levelNbt.a("thunderTime", this.w);
        levelNbt.a("thundering", this.v);
        levelNbt.a("hardcore", this.e.c());
        levelNbt.a("allowCommands", this.e.e());
        levelNbt.a("initialized", this.x);
        this.z.a(levelNbt);
        levelNbt.a("Difficulty", (byte)this.e.d().a());
        levelNbt.a("DifficultyLocked", this.y);
        levelNbt.a("GameRules", this.e.f().a());
        levelNbt.a("DragonFight", this.A);
        if (playerNbt != null) {
            levelNbt.a("Player", playerNbt);
        }
        DataPackConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.g()).result().ifPresent(nbtbase -> levelNbt.a("DataPacks", (NBTBase)nbtbase));
        if (this.B != null) {
            levelNbt.a("CustomBossEvents", this.B);
        }
        levelNbt.a("ScheduledEvents", this.H.b());
        levelNbt.a("WanderingTraderSpawnDelay", this.C);
        levelNbt.a("WanderingTraderSpawnChance", this.D);
        if (this.E != null) {
            levelNbt.a("WanderingTraderId", this.E);
        }
        levelNbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
    }

    @Override
    public int a() {
        return this.h;
    }

    @Override
    public int b() {
        return this.i;
    }

    @Override
    public int c() {
        return this.j;
    }

    @Override
    public float d() {
        return this.k;
    }

    @Override
    public long e() {
        return this.l;
    }

    @Override
    public long f() {
        return this.m;
    }

    private void J() {
        if (!this.p && this.q != null) {
            if (this.o < SharedConstants.b().getWorldVersion()) {
                if (this.n == null) {
                    throw SystemUtils.c(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.q = GameProfileSerializer.a(this.n, DataFixTypes.b, this.q, this.o);
            }
            this.p = true;
        }
    }

    @Override
    public NBTTagCompound y() {
        this.J();
        return this.q;
    }

    @Override
    public void b(int spawnX) {
        this.h = spawnX;
    }

    @Override
    public void c(int spawnY) {
        this.i = spawnY;
    }

    @Override
    public void d(int spawnZ) {
        this.j = spawnZ;
    }

    @Override
    public void a(float angle) {
        this.k = angle;
    }

    @Override
    public void a(long time) {
        this.l = time;
    }

    @Override
    public void b(long timeOfDay) {
        this.m = timeOfDay;
    }

    @Override
    public void a(BlockPosition pos, float angle) {
        this.h = pos.u();
        this.i = pos.v();
        this.j = pos.w();
        this.k = angle;
    }

    @Override
    public String g() {
        return this.e.a();
    }

    @Override
    public int z() {
        return this.r;
    }

    @Override
    public int h() {
        return this.s;
    }

    @Override
    public void a(int clearWeatherTime) {
        this.s = clearWeatherTime;
    }

    @Override
    public boolean i() {
        return this.v;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.v == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.v = thundering;
    }

    @Override
    public int j() {
        return this.w;
    }

    @Override
    public void e(int thunderTime) {
        this.w = thunderTime;
    }

    @Override
    public boolean k() {
        return this.t;
    }

    @Override
    public void b(boolean raining) {
        this.setRaining(raining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean raining, WeatherChangeEvent.Cause cause) {
        if (this.t == raining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, raining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.t = raining;
    }

    @Override
    public int l() {
        return this.u;
    }

    @Override
    public void f(int rainTime) {
        this.u = rainTime;
    }

    @Override
    public EnumGamemode m() {
        return this.e.b();
    }

    @Override
    public void a(EnumGamemode gameMode) {
        this.e = this.e.a(gameMode);
    }

    @Override
    public boolean n() {
        return this.e.c();
    }

    @Override
    public boolean o() {
        return this.e.e();
    }

    @Override
    public boolean p() {
        return this.x;
    }

    @Override
    public void c(boolean initialized) {
        this.x = initialized;
    }

    @Override
    public GameRules q() {
        return this.e.f();
    }

    @Override
    public WorldBorder.c r() {
        return this.z;
    }

    @Override
    public void a(WorldBorder.c properties) {
        this.z = properties;
    }

    @Override
    public EnumDifficulty s() {
        return this.e.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.e = this.e.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.s(), this.t());
        for (EntityPlayer player : this.world.z()) {
            player.b.a(packet);
        }
    }

    @Override
    public boolean t() {
        return this.y;
    }

    @Override
    public void d(boolean locked) {
        this.y = locked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> u() {
        return this.H;
    }

    @Override
    public void a(CrashReportSystemDetails reportSection, LevelHeightAccessor world) {
        IWorldDataServer.super.a(reportSection, world);
        SaveData.super.a(reportSection);
    }

    @Override
    public GeneratorSettings A() {
        return this.f;
    }

    @Override
    public Lifecycle B() {
        return this.g;
    }

    @Override
    public NBTTagCompound C() {
        return this.A;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.A = nbt;
    }

    @Override
    public DataPackConfiguration D() {
        return this.e.g();
    }

    @Override
    public void a(DataPackConfiguration dataPackSettings) {
        this.e = this.e.a(dataPackSettings);
    }

    @Override
    @Nullable
    public NBTTagCompound E() {
        return this.B;
    }

    @Override
    public void b(@Nullable NBTTagCompound nbt) {
        this.B = nbt;
    }

    @Override
    public int v() {
        return this.C;
    }

    @Override
    public void g(int wanderingTraderSpawnDelay) {
        this.C = wanderingTraderSpawnDelay;
    }

    @Override
    public int w() {
        return this.D;
    }

    @Override
    public void h(int wanderingTraderSpawnChance) {
        this.D = wanderingTraderSpawnChance;
    }

    @Override
    @Nullable
    public UUID x() {
        return this.E;
    }

    @Override
    public void a(UUID uuid) {
        this.E = uuid;
    }

    @Override
    public void a(String brand, boolean modded) {
        this.F.add(brand);
        this.G |= modded;
    }

    @Override
    public boolean F() {
        return this.G;
    }

    @Override
    public Set<String> G() {
        return ImmutableSet.copyOf(this.F);
    }

    @Override
    public IWorldDataServer H() {
        return this;
    }

    @Override
    public WorldSettings I() {
        return this.e.h();
    }

    public void checkName(String name) {
        if (!this.e.a.equals(name)) {
            this.e.a = name;
        }
    }
}

