/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class PathfinderWater
extends PathfinderAbstract {
    private final boolean j;
    private final Long2ObjectMap<PathType> k = new Long2ObjectOpenHashMap();

    public PathfinderWater(boolean canJumpOutOfWater) {
        this.j = canJumpOutOfWater;
    }

    @Override
    @Override
    public void a(ChunkCache cachedWorld, EntityInsentient entity) {
        super.a(cachedWorld, entity);
        this.k.clear();
    }

    @Override
    @Override
    public void a() {
        super.a();
        this.k.clear();
    }

    @Override
    @Override
    public PathPoint b() {
        return super.a(MathHelper.b(this.b.cw().a), MathHelper.b(this.b.cw().b + 0.5), MathHelper.b(this.b.cw().c));
    }

    @Override
    @Override
    public PathDestination a(double x2, double y2, double z2) {
        return new PathDestination(super.a(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2)));
    }

    @Override
    @Override
    public int a(PathPoint[] successors, PathPoint node) {
        int i2 = 0;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            PathPoint node2 = this.a(node.a + direction.i(), node.b + direction.j(), node.c + direction.k());
            map.put(direction, node2);
            if (!this.a(node2)) continue;
            successors[i2++] = node2;
        }
        for (EnumDirection direction2 : EnumDirection.EnumDirectionLimit.a) {
            EnumDirection direction3 = direction2.g();
            PathPoint node3 = this.a(node.a + direction2.i() + direction3.i(), node.b, node.c + direction2.k() + direction3.k());
            if (!this.a(node3, (PathPoint)map.get(direction2), (PathPoint)map.get(direction3))) continue;
            successors[i2++] = node3;
        }
        return i2;
    }

    protected boolean a(@Nullable PathPoint node) {
        return node != null && !node.i;
    }

    protected boolean a(@Nullable PathPoint node, @Nullable PathPoint node2, @Nullable PathPoint node3) {
        return this.a(node) && node2 != null && node2.k >= 0.0f && node3 != null && node3.k >= 0.0f;
    }

    @Override
    @Nullable
    @Override
    protected PathPoint a(int x2, int y2, int z2) {
        float f2;
        PathPoint node = null;
        PathType blockPathTypes = this.b(x2, y2, z2);
        if ((this.j && blockPathTypes == PathType.v || blockPathTypes == PathType.i) && (f2 = this.b.a(blockPathTypes)) >= 0.0f) {
            node = super.a(x2, y2, z2);
            node.l = blockPathTypes;
            node.k = Math.max(node.k, f2);
            if (this.a.b_(new BlockPosition(x2, y2, z2)).c()) {
                node.k += 8.0f;
            }
        }
        return node;
    }

    protected PathType b(int i2, int j2, int k2) {
        return (PathType)((Object)this.k.computeIfAbsent(BlockPosition.a(i2, j2, k2), l2 -> this.a(this.a, i2, j2, k2)));
    }

    @Override
    @Override
    public PathType a(IBlockAccess world, int x2, int y2, int z2) {
        return this.a(world, x2, y2, z2, this.b, this.d, this.e, this.f, this.e(), this.d());
    }

    @Override
    @Override
    public PathType a(IBlockAccess world, int x2, int y2, int z2, EntityInsentient mob, int sizeX, int sizeY, int sizeZ, boolean canOpenDoors, boolean canEnterOpenDoors) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = x2; i2 < x2 + sizeX; ++i2) {
            for (int j2 = y2; j2 < y2 + sizeY; ++j2) {
                for (int k2 = z2; k2 < z2 + sizeZ; ++k2) {
                    Fluid fluidState = world.b_(mutableBlockPos.d(i2, j2, k2));
                    IBlockData blockState = world.a_(mutableBlockPos.d(i2, j2, k2));
                    if (fluidState.c() && blockState.a(world, mutableBlockPos.c(), PathMode.b) && blockState.g()) {
                        return PathType.v;
                    }
                    if (fluidState.a(TagsFluid.b)) continue;
                    return PathType.a;
                }
            }
        }
        IBlockData blockState2 = world.a_(mutableBlockPos);
        if (blockState2.a(world, (BlockPosition)mutableBlockPos, PathMode.b)) {
            return PathType.i;
        }
        return PathType.a;
    }
}

