/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class NoiseGeneratorOctaves {
    private static final int a = 0x2000000;
    private final NoiseGeneratorPerlin[] b;
    private final int c;
    private final DoubleList d;
    private final double e;
    private final double f;

    @Deprecated
    public static NoiseGeneratorOctaves a(RandomSource random, IntStream intStream) {
        return new NoiseGeneratorOctaves(random, NoiseGeneratorOctaves.a((IntSortedSet)new IntRBTreeSet((Collection)intStream.boxed().collect(ImmutableList.toImmutableList()))), false);
    }

    @Deprecated
    public static NoiseGeneratorOctaves a(RandomSource random, int offset, DoubleList amplitudes) {
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)offset, (Object)amplitudes), false);
    }

    public static NoiseGeneratorOctaves b(RandomSource random, IntStream intStream) {
        return NoiseGeneratorOctaves.a(random, (List)intStream.boxed().collect(ImmutableList.toImmutableList()));
    }

    public static NoiseGeneratorOctaves a(RandomSource random, List<Integer> list) {
        return new NoiseGeneratorOctaves(random, NoiseGeneratorOctaves.a((IntSortedSet)new IntRBTreeSet(list)), true);
    }

    public static NoiseGeneratorOctaves a(RandomSource random, int offset, double firstAmplitude, double ... amplitudes) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(amplitudes);
        doubleArrayList.add(0, firstAmplitude);
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)offset, (Object)doubleArrayList), true);
    }

    public static NoiseGeneratorOctaves b(RandomSource random, int offset, DoubleList amplitudes) {
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)offset, (Object)amplitudes), true);
    }

    private static Pair<Integer, DoubleList> a(IntSortedSet octaves) {
        int j2;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i2 = -octaves.firstInt();
        int k2 = i2 + (j2 = octaves.lastInt()) + 1;
        if (k2 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList doubleList = new DoubleArrayList(new double[k2]);
        IntBidirectionalIterator intBidirectionalIterator = octaves.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int l2 = intBidirectionalIterator.nextInt();
            doubleList.set(l2 + i2, 1.0);
        }
        return Pair.of((Object)(-i2), (Object)doubleList);
    }

    protected NoiseGeneratorOctaves(RandomSource random, Pair<Integer, DoubleList> pair, boolean xoroshiro) {
        this.c = (Integer)pair.getFirst();
        this.d = (DoubleList)pair.getSecond();
        int i2 = this.d.size();
        int j2 = -this.c;
        this.b = new NoiseGeneratorPerlin[i2];
        if (xoroshiro) {
            PositionalRandomFactory positionalRandomFactory = random.b();
            for (int k2 = 0; k2 < i2; ++k2) {
                if (this.d.getDouble(k2) == 0.0) continue;
                int l2 = this.c + k2;
                this.b[k2] = new NoiseGeneratorPerlin(positionalRandomFactory.a("octave_" + l2));
            }
        } else {
            double d2;
            NoiseGeneratorPerlin improvedNoise = new NoiseGeneratorPerlin(random);
            if (j2 >= 0 && j2 < i2 && (d2 = this.d.getDouble(j2)) != 0.0) {
                this.b[j2] = improvedNoise;
            }
            for (int m2 = j2 - 1; m2 >= 0; --m2) {
                if (m2 < i2) {
                    double e2 = this.d.getDouble(m2);
                    if (e2 != 0.0) {
                        this.b[m2] = new NoiseGeneratorPerlin(random);
                        continue;
                    }
                    NoiseGeneratorOctaves.a(random);
                    continue;
                }
                NoiseGeneratorOctaves.a(random);
            }
            if (Arrays.stream(this.b).filter(Objects::nonNull).count() != this.d.stream().filter(double_ -> double_ != 0.0).count()) {
                throw new IllegalStateException("Failed to create correct number of noise levels for given non-zero amplitudes");
            }
            if (j2 < i2 - 1) {
                throw new IllegalArgumentException("Positive octaves are temporarily disabled");
            }
        }
        this.f = Math.pow(2.0, -j2);
        this.e = Math.pow(2.0, i2 - 1) / (Math.pow(2.0, i2) - 1.0);
    }

    private static void a(RandomSource random) {
        random.b(262);
    }

    public double a(double x2, double y2, double z2) {
        return this.a(x2, y2, z2, 0.0, 0.0, false);
    }

    @Deprecated
    public double a(double x2, double y2, double z2, double yScale, double yMax, boolean useOrigin) {
        double d2 = 0.0;
        double e2 = this.f;
        double f2 = this.e;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            NoiseGeneratorPerlin improvedNoise = this.b[i2];
            if (improvedNoise != null) {
                double g2 = improvedNoise.a(NoiseGeneratorOctaves.a(x2 * e2), useOrigin ? -improvedNoise.b : NoiseGeneratorOctaves.a(y2 * e2), NoiseGeneratorOctaves.a(z2 * e2), yScale * e2, yMax * e2);
                d2 += this.d.getDouble(i2) * g2 * f2;
            }
            e2 *= 2.0;
            f2 /= 2.0;
        }
        return d2;
    }

    @Nullable
    public NoiseGeneratorPerlin a(int octave) {
        return this.b[this.b.length - 1 - octave];
    }

    public static double a(double value) {
        return value - (double)MathHelper.c(value / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    protected int a() {
        return this.c;
    }

    protected DoubleList b() {
        return this.d;
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        info.append("PerlinNoise{");
        List<String> list = this.d.stream().map(double_ -> String.format("%.2f", double_)).toList();
        info.append("first octave: ").append(this.c).append(", amplitudes: ").append(list).append(", noise levels: [");
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            info.append(i2).append(": ");
            NoiseGeneratorPerlin improvedNoise = this.b[i2];
            if (improvedNoise == null) {
                info.append("null");
            } else {
                improvedNoise.a(info);
            }
            info.append(", ");
        }
        info.append("]");
        info.append("}");
    }
}

