/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;

public class NoiseGeneratorNormal {
    private static final double a = 1.0181268882175227;
    private static final double b = 0.3333333333333333;
    private final double c;
    private final NoiseGeneratorOctaves d;
    private final NoiseGeneratorOctaves e;

    @Deprecated
    public static NoiseGeneratorNormal a(RandomSource random, a parameters) {
        return new NoiseGeneratorNormal(random, parameters.a(), parameters.b(), false);
    }

    public static NoiseGeneratorNormal a(RandomSource random, int offset, double ... octaves) {
        return new NoiseGeneratorNormal(random, offset, (DoubleList)new DoubleArrayList(octaves), true);
    }

    public static NoiseGeneratorNormal b(RandomSource random, a parameters) {
        return new NoiseGeneratorNormal(random, parameters.a(), parameters.b(), true);
    }

    public static NoiseGeneratorNormal a(RandomSource random, int offset, DoubleList octaves) {
        return new NoiseGeneratorNormal(random, offset, octaves, true);
    }

    private NoiseGeneratorNormal(RandomSource random, int offset, DoubleList octaves, boolean xoroshiro) {
        if (xoroshiro) {
            this.d = NoiseGeneratorOctaves.b(random, offset, octaves);
            this.e = NoiseGeneratorOctaves.b(random, offset, octaves);
        } else {
            this.d = NoiseGeneratorOctaves.a(random, offset, octaves);
            this.e = NoiseGeneratorOctaves.a(random, offset, octaves);
        }
        int i2 = Integer.MAX_VALUE;
        int j2 = Integer.MIN_VALUE;
        DoubleListIterator doubleListIterator = octaves.iterator();
        while (doubleListIterator.hasNext()) {
            int k2 = doubleListIterator.nextIndex();
            double d2 = doubleListIterator.nextDouble();
            if (d2 == 0.0) continue;
            i2 = Math.min(i2, k2);
            j2 = Math.max(j2, k2);
        }
        this.c = 0.16666666666666666 / NoiseGeneratorNormal.a(j2 - i2);
    }

    private static double a(int octaves) {
        return 0.1 * (1.0 + 1.0 / (double)(octaves + 1));
    }

    public double a(double x2, double y2, double z2) {
        double d2 = x2 * 1.0181268882175227;
        double e2 = y2 * 1.0181268882175227;
        double f2 = z2 * 1.0181268882175227;
        return (this.d.a(x2, y2, z2) + this.e.a(d2, e2, f2)) * this.c;
    }

    public a a() {
        return new a(this.d.a(), (List<Double>)this.d.b());
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        info.append("NormalNoise {");
        info.append("first: ");
        this.d.a(info);
        info.append(", second: ");
        this.e.a(info);
        info.append("}");
    }

    public static class a {
        private final int c;
        private final DoubleList d;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("firstOctave").forGetter(a::a), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(a::b)).apply((Applicative)instance, a::new));
        public static final Codec<Supplier<a>> b = RegistryFileCodec.a(IRegistry.aS, a);

        public a(int firstOctave, List<Double> amplitudes) {
            this.c = firstOctave;
            this.d = new DoubleArrayList(amplitudes);
        }

        public a(int firstOctave, double firstAmplitude, double ... amplitudes) {
            this.c = firstOctave;
            this.d = new DoubleArrayList(amplitudes);
            this.d.add(0, firstAmplitude);
        }

        public int a() {
            return this.c;
        }

        public DoubleList b() {
            return this.d;
        }
    }
}

