/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenNetherPieces {
    private static final int b = 30;
    private static final int c = 10;
    public static final int a = 64;
    static final WorldGenNetherPieceWeight[] d = new WorldGenNetherPieceWeight[]{new WorldGenNetherPieceWeight(WorldGenNetherPiece3.class, 30, 0, true), new WorldGenNetherPieceWeight(WorldGenNetherPiece1.class, 10, 4), new WorldGenNetherPieceWeight(WorldGenNetherPiece13.class, 10, 4), new WorldGenNetherPieceWeight(WorldGenNetherPiece14.class, 10, 3), new WorldGenNetherPieceWeight(WorldGenNetherPiece12.class, 5, 2), new WorldGenNetherPieceWeight(WorldGenNetherPiece6.class, 5, 1)};
    static final WorldGenNetherPieceWeight[] e = new WorldGenNetherPieceWeight[]{new WorldGenNetherPieceWeight(WorldGenNetherPiece9.class, 25, 0, true), new WorldGenNetherPieceWeight(WorldGenNetherPiece7.class, 15, 5), new WorldGenNetherPieceWeight(WorldGenNetherPiece10.class, 5, 10), new WorldGenNetherPieceWeight(WorldGenNetherPiece8.class, 5, 10), new WorldGenNetherPieceWeight(WorldGenNetherPiece4.class, 10, 3, true), new WorldGenNetherPieceWeight(WorldGenNetherPiece5.class, 7, 2), new WorldGenNetherPieceWeight(WorldGenNetherPiece11.class, 5, 2)};

    static WorldGenNetherPiece a(WorldGenNetherPieceWeight pieceData, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
        Class<? extends WorldGenNetherPiece> class_ = pieceData.a;
        WorldGenNetherPiece netherBridgePiece = null;
        if (class_ == WorldGenNetherPiece3.class) {
            netherBridgePiece = WorldGenNetherPiece3.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece1.class) {
            netherBridgePiece = WorldGenNetherPiece1.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece13.class) {
            netherBridgePiece = WorldGenNetherPiece13.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece14.class) {
            netherBridgePiece = WorldGenNetherPiece14.a(holder, x2, y2, z2, chainLength, orientation);
        } else if (class_ == WorldGenNetherPiece12.class) {
            netherBridgePiece = WorldGenNetherPiece12.a(holder, x2, y2, z2, chainLength, orientation);
        } else if (class_ == WorldGenNetherPiece6.class) {
            netherBridgePiece = WorldGenNetherPiece6.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece9.class) {
            netherBridgePiece = WorldGenNetherPiece9.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece10.class) {
            netherBridgePiece = WorldGenNetherPiece10.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece8.class) {
            netherBridgePiece = WorldGenNetherPiece8.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece4.class) {
            netherBridgePiece = WorldGenNetherPiece4.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece5.class) {
            netherBridgePiece = WorldGenNetherPiece5.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece7.class) {
            netherBridgePiece = WorldGenNetherPiece7.a(holder, x2, y2, z2, orientation, chainLength);
        } else if (class_ == WorldGenNetherPiece11.class) {
            netherBridgePiece = WorldGenNetherPiece11.a(holder, x2, y2, z2, orientation, chainLength);
        }
        return netherBridgePiece;
    }

    static class WorldGenNetherPieceWeight {
        public final Class<? extends WorldGenNetherPiece> a;
        public final int b;
        public int c;
        public final int d;
        public final boolean e;

        public WorldGenNetherPieceWeight(Class<? extends WorldGenNetherPiece> pieceType, int weight, int limit, boolean repeatable) {
            this.a = pieceType;
            this.b = weight;
            this.d = limit;
            this.e = repeatable;
        }

        public WorldGenNetherPieceWeight(Class<? extends WorldGenNetherPiece> pieceType, int weight, int limit) {
            this(pieceType, weight, limit, false);
        }

        public boolean a(int chainLength) {
            return this.d == 0 || this.c < this.d;
        }

        public boolean a() {
            return this.d == 0 || this.c < this.d;
        }
    }

    public static class WorldGenNetherPiece3
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 10;
        private static final int c = 19;

        public WorldGenNetherPiece3(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.g, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece3(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.g, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 1, 3, false);
        }

        public static WorldGenNetherPiece3 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -3, 0, 5, 10, 19, orientation);
            if (!WorldGenNetherPiece3.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece3(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 3, 0, 4, 4, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 5, 0, 3, 7, 18, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 5, 0, 0, 5, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 5, 0, 4, 5, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 4, 2, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 13, 4, 2, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 0, 0, 4, 1, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 0, 15, 4, 1, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 2; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                    this.a(world, Blocks.ee.n(), i2, -1, 18 - j2, chunkBox);
                }
            }
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            IBlockData blockState2 = (IBlockData)blockState.a(BlockTall.b, true);
            IBlockData blockState3 = (IBlockData)blockState.a(BlockTall.d, true);
            this.a(world, chunkBox, 0, 1, 1, 0, 4, 1, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 3, 4, 0, 4, 4, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 3, 14, 0, 4, 14, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 1, 17, 0, 4, 17, blockState2, blockState2, false);
            this.a(world, chunkBox, 4, 1, 1, 4, 4, 1, blockState3, blockState3, false);
            this.a(world, chunkBox, 4, 3, 4, 4, 4, 4, blockState3, blockState3, false);
            this.a(world, chunkBox, 4, 3, 14, 4, 4, 14, blockState3, blockState3, false);
            this.a(world, chunkBox, 4, 1, 17, 4, 4, 17, blockState3, blockState3, false);
        }
    }

    public static class WorldGenNetherPiece1
    extends WorldGenNetherPiece {
        private static final int a = 19;
        private static final int b = 10;
        private static final int c = 19;

        public WorldGenNetherPiece1(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.e, chainLength, boundingBox);
            this.a(orientation);
        }

        protected WorldGenNetherPiece1(int x2, int z2, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.e, 0, StructurePiece.a(x2, 64, z2, orientation, 19, 10, 19));
            this.a(orientation);
        }

        protected WorldGenNetherPiece1(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
        }

        public WorldGenNetherPiece1(NBTTagCompound nbt) {
            this(WorldGenFeatureStructurePieceType.e, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 8, 3, false);
            this.b((WorldGenNetherPiece15)start, holder, random, 3, 8, false);
            this.c((WorldGenNetherPiece15)start, holder, random, 3, 8, false);
        }

        public static WorldGenNetherPiece1 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -8, -3, 0, 19, 10, 19, orientation);
            if (!WorldGenNetherPiece1.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece1(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 7, 3, 0, 11, 4, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 3, 7, 18, 4, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 5, 0, 10, 7, 18, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 5, 8, 18, 7, 10, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 7, 5, 0, 7, 5, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 7, 5, 11, 7, 5, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 0, 11, 5, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 11, 11, 5, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 7, 7, 5, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 7, 18, 5, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 11, 7, 5, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 11, 18, 5, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 7, 2, 0, 11, 2, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 7, 2, 13, 11, 2, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 7, 0, 0, 11, 1, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 7, 0, 15, 11, 1, 18, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 7; i2 <= 11; ++i2) {
                for (int j2 = 0; j2 <= 2; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                    this.a(world, Blocks.ee.n(), i2, -1, 18 - j2, chunkBox);
                }
            }
            this.a(world, chunkBox, 0, 2, 7, 5, 2, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 13, 2, 7, 18, 2, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 0, 7, 3, 1, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 15, 0, 7, 18, 1, 11, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int k2 = 0; k2 <= 2; ++k2) {
                for (int l2 = 7; l2 <= 11; ++l2) {
                    this.a(world, Blocks.ee.n(), k2, -1, l2, chunkBox);
                    this.a(world, Blocks.ee.n(), 18 - k2, -1, l2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece13
    extends WorldGenNetherPiece {
        private static final int a = 7;
        private static final int b = 9;
        private static final int c = 7;

        public WorldGenNetherPiece13(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.q, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece13(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.q, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 2, 0, false);
            this.b((WorldGenNetherPiece15)start, holder, random, 0, 2, false);
            this.c((WorldGenNetherPiece15)start, holder, random, 0, 2, false);
        }

        public static WorldGenNetherPiece13 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -2, 0, 0, 7, 9, 7, orientation);
            if (!WorldGenNetherPiece13.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece13(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 6, 1, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 6, 7, 6, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 1, 6, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 6, 1, 6, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 2, 0, 6, 6, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 2, 6, 6, 6, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 0, 6, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 5, 0, 6, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 2, 0, 6, 6, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 2, 5, 6, 6, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.a(world, chunkBox, 2, 6, 0, 4, 6, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 0, 4, 5, 0, blockState, blockState, false);
            this.a(world, chunkBox, 2, 6, 6, 4, 6, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 6, 4, 5, 6, blockState, blockState, false);
            this.a(world, chunkBox, 0, 6, 2, 0, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 2, 0, 5, 4, blockState2, blockState2, false);
            this.a(world, chunkBox, 6, 6, 2, 6, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 5, 2, 6, 5, 4, blockState2, blockState2, false);
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece14
    extends WorldGenNetherPiece {
        private static final int a = 7;
        private static final int b = 11;
        private static final int c = 7;

        public WorldGenNetherPiece14(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.r, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece14(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.r, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.c((WorldGenNetherPiece15)start, holder, random, 6, 2, false);
        }

        public static WorldGenNetherPiece14 a(StructurePieceAccessor holder, int x2, int y2, int z2, int chainlength, EnumDirection orientation) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -2, 0, 0, 7, 11, 7, orientation);
            if (!WorldGenNetherPiece14.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece14(chainlength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 6, 1, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 6, 10, 6, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 1, 8, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 2, 0, 6, 8, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 1, 0, 8, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 2, 1, 6, 8, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 2, 6, 5, 8, 6, Blocks.ee.n(), Blocks.ee.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.a(world, chunkBox, 0, 3, 2, 0, 5, 4, blockState2, blockState2, false);
            this.a(world, chunkBox, 6, 3, 2, 6, 5, 2, blockState2, blockState2, false);
            this.a(world, chunkBox, 6, 3, 4, 6, 5, 4, blockState2, blockState2, false);
            this.c(world, Blocks.ee.n(), 5, 2, 5, chunkBox);
            this.a(world, chunkBox, 4, 2, 5, 4, 3, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 3, 2, 5, 3, 4, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 2, 5, 2, 5, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 2, 5, 1, 6, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 7, 1, 5, 7, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 8, 2, 6, 8, 4, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 2, 6, 0, 4, 8, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 0, 4, 5, 0, blockState, blockState, false);
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece12
    extends WorldGenNetherPiece {
        private static final int a = 7;
        private static final int b = 8;
        private static final int c = 9;
        private boolean d;

        public WorldGenNetherPiece12(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.p, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece12(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.p, nbt);
            this.d = nbt.q("Mob");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Mob", this.d);
        }

        public static WorldGenNetherPiece12 a(StructurePieceAccessor holder, int x2, int y2, int z2, int chainLength, EnumDirection orientation) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -2, 0, 0, 7, 8, 9, orientation);
            if (!WorldGenNetherPiece12.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece12(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            BlockPosition.MutableBlockPosition blockPos;
            this.a(world, chunkBox, 0, 2, 0, 6, 7, 7, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 1, 0, 0, 5, 1, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 2, 1, 5, 2, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 3, 2, 5, 3, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 4, 3, 5, 4, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 2, 0, 1, 4, 2, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 2, 0, 5, 4, 2, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 5, 2, 1, 5, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 5, 2, 5, 5, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 3, 0, 5, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 5, 3, 6, 5, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 5, 8, 5, 5, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.d, true), 1, 6, 3, chunkBox);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.b, true), 5, 6, 3, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.b, true)).a(BlockTall.a, true), 0, 6, 3, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.a, true), 6, 6, 3, chunkBox);
            this.a(world, chunkBox, 0, 6, 4, 0, 6, 7, blockState2, blockState2, false);
            this.a(world, chunkBox, 6, 6, 4, 6, 6, 7, blockState2, blockState2, false);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.b, true)).a(BlockTall.c, true), 0, 6, 8, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.c, true), 6, 6, 8, chunkBox);
            this.a(world, chunkBox, 1, 6, 8, 5, 6, 8, blockState, blockState, false);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.b, true), 1, 7, 8, chunkBox);
            this.a(world, chunkBox, 2, 7, 8, 4, 7, 8, blockState, blockState, false);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.d, true), 5, 7, 8, chunkBox);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.b, true), 2, 8, 8, chunkBox);
            this.c(world, blockState, 3, 8, 8, chunkBox);
            this.c(world, (IBlockData)Blocks.ef.n().a(BlockTall.d, true), 4, 8, 8, chunkBox);
            if (!this.d && chunkBox.b(blockPos = this.c(3, 5, 5))) {
                this.d = true;
                world.a((BlockPosition)blockPos, Blocks.bV.n(), 2);
                TileEntity blockEntity = world.c_(blockPos);
                if (blockEntity instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)blockEntity).d().a(EntityTypes.h);
                }
            }
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece6
    extends WorldGenNetherPiece {
        private static final int a = 13;
        private static final int b = 14;
        private static final int c = 13;

        public WorldGenNetherPiece6(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.j, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece6(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.j, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 5, 3, true);
        }

        public static WorldGenNetherPiece6 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -5, -3, 0, 13, 14, 13, orientation);
            if (!WorldGenNetherPiece6.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece6(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 3, 0, 12, 4, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 0, 12, 13, 12, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 5, 0, 1, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 0, 12, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 11, 4, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 5, 11, 10, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 9, 11, 7, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 0, 4, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 5, 0, 10, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 9, 0, 7, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 11, 2, 10, 12, 10, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 8, 0, 7, 8, 0, Blocks.ef.n(), Blocks.ef.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            for (int i2 = 1; i2 <= 11; i2 += 2) {
                this.a(world, chunkBox, i2, 10, 0, i2, 11, 0, blockState, blockState, false);
                this.a(world, chunkBox, i2, 10, 12, i2, 11, 12, blockState, blockState, false);
                this.a(world, chunkBox, 0, 10, i2, 0, 11, i2, blockState2, blockState2, false);
                this.a(world, chunkBox, 12, 10, i2, 12, 11, i2, blockState2, blockState2, false);
                this.c(world, Blocks.ee.n(), i2, 13, 0, chunkBox);
                this.c(world, Blocks.ee.n(), i2, 13, 12, chunkBox);
                this.c(world, Blocks.ee.n(), 0, 13, i2, chunkBox);
                this.c(world, Blocks.ee.n(), 12, 13, i2, chunkBox);
                if (i2 == 11) continue;
                this.c(world, blockState, i2 + 1, 13, 0, chunkBox);
                this.c(world, blockState, i2 + 1, 13, 12, chunkBox);
                this.c(world, blockState2, 0, 13, i2 + 1, chunkBox);
                this.c(world, blockState2, 12, 13, i2 + 1, chunkBox);
            }
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.b, true), 0, 13, 0, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.c, true)).a(BlockTall.b, true), 0, 13, 12, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.c, true)).a(BlockTall.d, true), 12, 13, 12, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.d, true), 12, 13, 0, chunkBox);
            for (int j2 = 3; j2 <= 9; j2 += 2) {
                this.a(world, chunkBox, 1, 7, j2, 1, 8, j2, (IBlockData)blockState2.a(BlockTall.d, true), (IBlockData)blockState2.a(BlockTall.d, true), false);
                this.a(world, chunkBox, 11, 7, j2, 11, 8, j2, (IBlockData)blockState2.a(BlockTall.b, true), (IBlockData)blockState2.a(BlockTall.b, true), false);
            }
            this.a(world, chunkBox, 4, 2, 0, 8, 2, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 4, 12, 2, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 0, 0, 8, 1, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 0, 9, 8, 1, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 0, 4, 3, 1, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 9, 0, 4, 12, 1, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int k2 = 4; k2 <= 8; ++k2) {
                for (int l2 = 0; l2 <= 2; ++l2) {
                    this.a(world, Blocks.ee.n(), k2, -1, l2, chunkBox);
                    this.a(world, Blocks.ee.n(), k2, -1, 12 - l2, chunkBox);
                }
            }
            for (int m2 = 0; m2 <= 2; ++m2) {
                for (int n2 = 4; n2 <= 8; ++n2) {
                    this.a(world, Blocks.ee.n(), m2, -1, n2, chunkBox);
                    this.a(world, Blocks.ee.n(), 12 - m2, -1, n2, chunkBox);
                }
            }
            this.a(world, chunkBox, 5, 5, 5, 7, 5, 7, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 1, 6, 6, 4, 6, Blocks.a.n(), Blocks.a.n(), false);
            this.c(world, Blocks.ee.n(), 6, 0, 6, chunkBox);
            this.c(world, Blocks.B.n(), 6, 5, 6, chunkBox);
            BlockPosition.MutableBlockPosition blockPos = this.c(6, 5, 6);
            if (chunkBox.b(blockPos)) {
                world.a((BlockPosition)blockPos, FluidTypes.e, 0);
            }
        }
    }

    public static class WorldGenNetherPiece9
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 7;
        private static final int c = 5;

        public WorldGenNetherPiece9(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.m, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece9(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.m, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 1, 0, true);
        }

        public static WorldGenNetherPiece9 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, 0, 0, 5, 7, 5, orientation);
            if (!WorldGenNetherPiece9.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece9(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 1, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 4, 5, 4, Blocks.a.n(), Blocks.a.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.a(world, chunkBox, 0, 2, 0, 0, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 2, 0, 4, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 3, 1, 0, 4, 1, blockState, blockState, false);
            this.a(world, chunkBox, 0, 3, 3, 0, 4, 3, blockState, blockState, false);
            this.a(world, chunkBox, 4, 3, 1, 4, 4, 1, blockState, blockState, false);
            this.a(world, chunkBox, 4, 3, 3, 4, 4, 3, blockState, blockState, false);
            this.a(world, chunkBox, 0, 6, 0, 4, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece10
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 7;
        private static final int c = 5;
        private boolean d;

        public WorldGenNetherPiece10(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.n, chainLength, boundingBox);
            this.a(orientation);
            this.d = random.nextInt(3) == 0;
        }

        public WorldGenNetherPiece10(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.n, nbt);
            this.d = nbt.q("Chest");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Chest", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.c((WorldGenNetherPiece15)start, holder, random, 0, 1, true);
        }

        public static WorldGenNetherPiece10 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, 0, 0, 5, 7, 5, orientation);
            if (!WorldGenNetherPiece10.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece10(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 1, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 4, 5, 4, Blocks.a.n(), Blocks.a.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.a(world, chunkBox, 0, 2, 0, 0, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 3, 1, 0, 4, 1, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 3, 3, 0, 4, 3, blockState2, blockState2, false);
            this.a(world, chunkBox, 4, 2, 0, 4, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 2, 4, 4, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 3, 4, 1, 4, 4, blockState, blockState, false);
            this.a(world, chunkBox, 3, 3, 4, 3, 4, 4, blockState, blockState, false);
            if (this.d && chunkBox.b(this.c(1, 2, 3))) {
                this.d = false;
                this.a(world, chunkBox, random, 1, 2, 3, LootTables.v);
            }
            this.a(world, chunkBox, 0, 6, 0, 4, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece8
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 7;
        private static final int c = 5;
        private boolean d;

        public WorldGenNetherPiece8(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.l, chainLength, boundingBox);
            this.a(orientation);
            this.d = random.nextInt(3) == 0;
        }

        public WorldGenNetherPiece8(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.l, nbt);
            this.d = nbt.q("Chest");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Chest", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.b((WorldGenNetherPiece15)start, holder, random, 0, 1, true);
        }

        public static WorldGenNetherPiece8 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, 0, 0, 5, 7, 5, orientation);
            if (!WorldGenNetherPiece8.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece8(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 1, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 4, 5, 4, Blocks.a.n(), Blocks.a.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            this.a(world, chunkBox, 4, 2, 0, 4, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 3, 1, 4, 4, 1, blockState2, blockState2, false);
            this.a(world, chunkBox, 4, 3, 3, 4, 4, 3, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 2, 0, 0, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 4, 3, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 3, 4, 1, 4, 4, blockState, blockState, false);
            this.a(world, chunkBox, 3, 3, 4, 3, 4, 4, blockState, blockState, false);
            if (this.d && chunkBox.b(this.c(3, 2, 3))) {
                this.d = false;
                this.a(world, chunkBox, random, 3, 2, 3, LootTables.v);
            }
            this.a(world, chunkBox, 0, 6, 0, 4, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece4
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 14;
        private static final int c = 10;

        public WorldGenNetherPiece4(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.h, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece4(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.h, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 1, 0, true);
        }

        public static WorldGenNetherPiece4 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -7, 0, 5, 14, 10, orientation);
            if (!WorldGenNetherPiece4.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece4(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            IBlockData blockState = (IBlockData)Blocks.eg.n().a(BlockStairs.a, EnumDirection.d);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            for (int i2 = 0; i2 <= 9; ++i2) {
                int j2 = Math.max(1, 7 - i2);
                int k2 = Math.min(Math.max(j2 + 5, 14 - i2), 13);
                int l2 = i2;
                this.a(world, chunkBox, 0, 0, l2, 4, j2, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                this.a(world, chunkBox, 1, j2 + 1, l2, 3, k2 - 1, l2, Blocks.a.n(), Blocks.a.n(), false);
                if (i2 <= 6) {
                    this.c(world, blockState, 1, j2 + 1, l2, chunkBox);
                    this.c(world, blockState, 2, j2 + 1, l2, chunkBox);
                    this.c(world, blockState, 3, j2 + 1, l2, chunkBox);
                }
                this.a(world, chunkBox, 0, k2, l2, 4, k2, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                this.a(world, chunkBox, 0, j2 + 1, l2, 0, k2 - 1, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                this.a(world, chunkBox, 4, j2 + 1, l2, 4, k2 - 1, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                if ((i2 & 1) == 0) {
                    this.a(world, chunkBox, 0, j2 + 2, l2, 0, j2 + 3, l2, blockState2, blockState2, false);
                    this.a(world, chunkBox, 4, j2 + 2, l2, 4, j2 + 3, l2, blockState2, blockState2, false);
                }
                for (int m2 = 0; m2 <= 4; ++m2) {
                    this.a(world, Blocks.ee.n(), m2, -1, l2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece5
    extends WorldGenNetherPiece {
        private static final int a = 9;
        private static final int b = 7;
        private static final int c = 9;

        public WorldGenNetherPiece5(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.i, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece5(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.i, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            int i2 = 1;
            EnumDirection direction = this.h();
            if (direction == EnumDirection.e || direction == EnumDirection.c) {
                i2 = 5;
            }
            this.b((WorldGenNetherPiece15)start, holder, random, 0, i2, random.nextInt(8) > 0);
            this.c((WorldGenNetherPiece15)start, holder, random, 0, i2, random.nextInt(8) > 0);
        }

        public static WorldGenNetherPiece5 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -3, 0, 0, 9, 7, 9, orientation);
            if (!WorldGenNetherPiece5.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece5(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            this.a(world, chunkBox, 0, 0, 0, 8, 1, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 8, 5, 8, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 6, 0, 8, 6, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 2, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 2, 0, 8, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 3, 0, 1, 4, 0, blockState2, blockState2, false);
            this.a(world, chunkBox, 7, 3, 0, 7, 4, 0, blockState2, blockState2, false);
            this.a(world, chunkBox, 0, 2, 4, 8, 2, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 1, 4, 2, 2, 4, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 6, 1, 4, 7, 2, 4, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 1, 3, 8, 7, 3, 8, blockState2, blockState2, false);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.b, true)).a(BlockTall.c, true), 0, 3, 8, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.c, true), 8, 3, 8, chunkBox);
            this.a(world, chunkBox, 0, 3, 6, 0, 3, 7, blockState, blockState, false);
            this.a(world, chunkBox, 8, 3, 6, 8, 3, 7, blockState, blockState, false);
            this.a(world, chunkBox, 0, 3, 4, 0, 5, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 3, 4, 8, 5, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 3, 5, 2, 5, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 6, 3, 5, 7, 5, 5, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 1, 4, 5, 1, 5, 5, blockState2, blockState2, false);
            this.a(world, chunkBox, 7, 4, 5, 7, 5, 5, blockState2, blockState2, false);
            for (int i2 = 0; i2 <= 5; ++i2) {
                for (int j2 = 0; j2 <= 8; ++j2) {
                    this.a(world, Blocks.ee.n(), j2, -1, i2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece7
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 7;
        private static final int c = 5;

        public WorldGenNetherPiece7(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.k, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece7(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.k, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 1, 0, true);
            this.b((WorldGenNetherPiece15)start, holder, random, 0, 1, true);
            this.c((WorldGenNetherPiece15)start, holder, random, 0, 1, true);
        }

        public static WorldGenNetherPiece7 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, 0, 0, 5, 7, 5, orientation);
            if (!WorldGenNetherPiece7.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece7(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 1, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 4, 5, 4, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 2, 0, 0, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 2, 0, 4, 5, 0, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 4, 0, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 2, 4, 4, 5, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 6, 0, 4, 6, 4, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.a(world, Blocks.ee.n(), i2, -1, j2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece11
    extends WorldGenNetherPiece {
        private static final int a = 13;
        private static final int b = 14;
        private static final int c = 13;

        public WorldGenNetherPiece11(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.o, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenNetherPiece11(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.o, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenNetherPiece15)start, holder, random, 5, 3, true);
            this.a((WorldGenNetherPiece15)start, holder, random, 5, 11, true);
        }

        public static WorldGenNetherPiece11 a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainlength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -5, -3, 0, 13, 14, 13, orientation);
            if (!WorldGenNetherPiece11.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece11(chainlength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 3, 0, 12, 4, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 5, 0, 12, 13, 12, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 0, 5, 0, 1, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 11, 5, 0, 12, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 11, 4, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 5, 11, 10, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 9, 11, 7, 12, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 0, 4, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 8, 5, 0, 10, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 5, 9, 0, 7, 12, 1, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 11, 2, 10, 12, 10, Blocks.ee.n(), Blocks.ee.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            IBlockData blockState3 = (IBlockData)blockState2.a(BlockTall.d, true);
            IBlockData blockState4 = (IBlockData)blockState2.a(BlockTall.b, true);
            for (int i2 = 1; i2 <= 11; i2 += 2) {
                this.a(world, chunkBox, i2, 10, 0, i2, 11, 0, blockState, blockState, false);
                this.a(world, chunkBox, i2, 10, 12, i2, 11, 12, blockState, blockState, false);
                this.a(world, chunkBox, 0, 10, i2, 0, 11, i2, blockState2, blockState2, false);
                this.a(world, chunkBox, 12, 10, i2, 12, 11, i2, blockState2, blockState2, false);
                this.c(world, Blocks.ee.n(), i2, 13, 0, chunkBox);
                this.c(world, Blocks.ee.n(), i2, 13, 12, chunkBox);
                this.c(world, Blocks.ee.n(), 0, 13, i2, chunkBox);
                this.c(world, Blocks.ee.n(), 12, 13, i2, chunkBox);
                if (i2 == 11) continue;
                this.c(world, blockState, i2 + 1, 13, 0, chunkBox);
                this.c(world, blockState, i2 + 1, 13, 12, chunkBox);
                this.c(world, blockState2, 0, 13, i2 + 1, chunkBox);
                this.c(world, blockState2, 12, 13, i2 + 1, chunkBox);
            }
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.b, true), 0, 13, 0, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.c, true)).a(BlockTall.b, true), 0, 13, 12, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.c, true)).a(BlockTall.d, true), 12, 13, 12, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.ef.n().a(BlockTall.a, true)).a(BlockTall.d, true), 12, 13, 0, chunkBox);
            for (int j2 = 3; j2 <= 9; j2 += 2) {
                this.a(world, chunkBox, 1, 7, j2, 1, 8, j2, blockState3, blockState3, false);
                this.a(world, chunkBox, 11, 7, j2, 11, 8, j2, blockState4, blockState4, false);
            }
            IBlockData blockState5 = (IBlockData)Blocks.eg.n().a(BlockStairs.a, EnumDirection.c);
            for (int k2 = 0; k2 <= 6; ++k2) {
                int l2 = k2 + 4;
                for (int m2 = 5; m2 <= 7; ++m2) {
                    this.c(world, blockState5, m2, 5 + k2, l2, chunkBox);
                }
                if (l2 >= 5 && l2 <= 8) {
                    this.a(world, chunkBox, 5, 5, l2, 7, k2 + 4, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                } else if (l2 >= 9 && l2 <= 10) {
                    this.a(world, chunkBox, 5, 8, l2, 7, k2 + 4, l2, Blocks.ee.n(), Blocks.ee.n(), false);
                }
                if (k2 < 1) continue;
                this.a(world, chunkBox, 5, 6 + k2, l2, 7, 9 + k2, l2, Blocks.a.n(), Blocks.a.n(), false);
            }
            for (int n2 = 5; n2 <= 7; ++n2) {
                this.c(world, blockState5, n2, 12, 11, chunkBox);
            }
            this.a(world, chunkBox, 5, 6, 7, 5, 7, 7, blockState4, blockState4, false);
            this.a(world, chunkBox, 7, 6, 7, 7, 7, 7, blockState3, blockState3, false);
            this.a(world, chunkBox, 5, 13, 12, 7, 13, 12, Blocks.a.n(), Blocks.a.n(), false);
            this.a(world, chunkBox, 2, 5, 2, 3, 5, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 9, 3, 5, 10, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 2, 5, 4, 2, 5, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 9, 5, 2, 10, 5, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 9, 5, 9, 10, 5, 10, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 10, 5, 4, 10, 5, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            IBlockData blockState6 = (IBlockData)blockState5.a(BlockStairs.a, EnumDirection.f);
            IBlockData blockState7 = (IBlockData)blockState5.a(BlockStairs.a, EnumDirection.e);
            this.c(world, blockState7, 4, 5, 2, chunkBox);
            this.c(world, blockState7, 4, 5, 3, chunkBox);
            this.c(world, blockState7, 4, 5, 9, chunkBox);
            this.c(world, blockState7, 4, 5, 10, chunkBox);
            this.c(world, blockState6, 8, 5, 2, chunkBox);
            this.c(world, blockState6, 8, 5, 3, chunkBox);
            this.c(world, blockState6, 8, 5, 9, chunkBox);
            this.c(world, blockState6, 8, 5, 10, chunkBox);
            this.a(world, chunkBox, 3, 4, 4, 4, 4, 8, Blocks.cU.n(), Blocks.cU.n(), false);
            this.a(world, chunkBox, 8, 4, 4, 9, 4, 8, Blocks.cU.n(), Blocks.cU.n(), false);
            this.a(world, chunkBox, 3, 5, 4, 4, 5, 8, Blocks.eh.n(), Blocks.eh.n(), false);
            this.a(world, chunkBox, 8, 5, 4, 9, 5, 8, Blocks.eh.n(), Blocks.eh.n(), false);
            this.a(world, chunkBox, 4, 2, 0, 8, 2, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 2, 4, 12, 2, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 0, 0, 8, 1, 3, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 4, 0, 9, 8, 1, 12, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 0, 0, 4, 3, 1, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            this.a(world, chunkBox, 9, 0, 4, 12, 1, 8, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int o2 = 4; o2 <= 8; ++o2) {
                for (int p2 = 0; p2 <= 2; ++p2) {
                    this.a(world, Blocks.ee.n(), o2, -1, p2, chunkBox);
                    this.a(world, Blocks.ee.n(), o2, -1, 12 - p2, chunkBox);
                }
            }
            for (int q2 = 0; q2 <= 2; ++q2) {
                for (int r2 = 4; r2 <= 8; ++r2) {
                    this.a(world, Blocks.ee.n(), q2, -1, r2, chunkBox);
                    this.a(world, Blocks.ee.n(), 12 - q2, -1, r2, chunkBox);
                }
            }
        }
    }

    public static class WorldGenNetherPiece2
    extends WorldGenNetherPiece {
        private static final int a = 5;
        private static final int b = 10;
        private static final int c = 8;
        private final int d;

        public WorldGenNetherPiece2(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.f, chainLength, boundingBox);
            this.a(orientation);
            this.d = random.nextInt();
        }

        public WorldGenNetherPiece2(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.f, nbt);
            this.d = nbt.h("Seed");
        }

        public static WorldGenNetherPiece2 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -3, 0, 5, 10, 8, orientation);
            if (!WorldGenNetherPiece2.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenNetherPiece2(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Seed", this.d);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            Random random2 = new Random(this.d);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 3; j2 <= 4; ++j2) {
                    int k2 = random2.nextInt(8);
                    this.a(world, chunkBox, i2, j2, 0, i2, j2, k2, Blocks.ee.n(), Blocks.ee.n(), false);
                }
            }
            int l2 = random2.nextInt(8);
            this.a(world, chunkBox, 0, 5, 0, 0, 5, l2, Blocks.ee.n(), Blocks.ee.n(), false);
            int m2 = random2.nextInt(8);
            this.a(world, chunkBox, 4, 5, 0, 4, 5, m2, Blocks.ee.n(), Blocks.ee.n(), false);
            for (int n2 = 0; n2 <= 4; ++n2) {
                int o2 = random2.nextInt(5);
                this.a(world, chunkBox, n2, 2, 0, n2, 2, o2, Blocks.ee.n(), Blocks.ee.n(), false);
            }
            for (int p2 = 0; p2 <= 4; ++p2) {
                for (int q2 = 0; q2 <= 1; ++q2) {
                    int r2 = random2.nextInt(3);
                    this.a(world, chunkBox, p2, q2, 0, p2, q2, r2, Blocks.ee.n(), Blocks.ee.n(), false);
                }
            }
        }
    }

    public static class WorldGenNetherPiece15
    extends WorldGenNetherPiece1 {
        public WorldGenNetherPieceWeight a;
        public List<WorldGenNetherPieceWeight> b;
        public List<WorldGenNetherPieceWeight> c;
        public final List<StructurePiece> d = Lists.newArrayList();

        public WorldGenNetherPiece15(Random random, int x2, int z2) {
            super(x2, z2, WorldGenNetherPiece15.b(random));
            this.b = Lists.newArrayList();
            for (WorldGenNetherPieceWeight pieceWeight : d) {
                pieceWeight.c = 0;
                this.b.add(pieceWeight);
            }
            this.c = Lists.newArrayList();
            for (WorldGenNetherPieceWeight pieceWeight2 : e) {
                pieceWeight2.c = 0;
                this.c.add(pieceWeight2);
            }
        }

        public WorldGenNetherPiece15(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.s, nbt);
        }
    }

    static abstract class WorldGenNetherPiece
    extends StructurePiece {
        protected WorldGenNetherPiece(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
            super(type, length, boundingBox);
        }

        public WorldGenNetherPiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        }

        private int a(List<WorldGenNetherPieceWeight> possiblePieces) {
            boolean bl = false;
            int i2 = 0;
            for (WorldGenNetherPieceWeight pieceWeight : possiblePieces) {
                if (pieceWeight.d > 0 && pieceWeight.c < pieceWeight.d) {
                    bl = true;
                }
                i2 += pieceWeight.b;
            }
            return bl ? i2 : -1;
        }

        private WorldGenNetherPiece a(WorldGenNetherPiece15 start, List<WorldGenNetherPieceWeight> possiblePieces, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            int i2 = this.a(possiblePieces);
            boolean bl = i2 > 0 && chainLength <= 30;
            int j2 = 0;
            block0: while (j2 < 5 && bl) {
                ++j2;
                int k2 = random.nextInt(i2);
                for (WorldGenNetherPieceWeight pieceWeight : possiblePieces) {
                    if ((k2 -= pieceWeight.b) >= 0) continue;
                    if (!pieceWeight.a(chainLength) || pieceWeight == start.a && !pieceWeight.e) continue block0;
                    WorldGenNetherPiece netherBridgePiece = WorldGenNetherPieces.a(pieceWeight, holder, random, x2, y2, z2, orientation, chainLength);
                    if (netherBridgePiece == null) continue;
                    ++pieceWeight.c;
                    start.a = pieceWeight;
                    if (!pieceWeight.a()) {
                        possiblePieces.remove(pieceWeight);
                    }
                    return netherBridgePiece;
                }
            }
            return WorldGenNetherPiece2.a(holder, random, x2, y2, z2, orientation, chainLength);
        }

        private StructurePiece a(WorldGenNetherPiece15 start, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int chainLength, boolean inside) {
            WorldGenNetherPiece structurePiece;
            if (Math.abs(x2 - start.f().g()) > 112 || Math.abs(z2 - start.f().i()) > 112) {
                return WorldGenNetherPiece2.a(holder, random, x2, y2, z2, orientation, chainLength);
            }
            List<WorldGenNetherPieceWeight> list = start.b;
            if (inside) {
                list = start.c;
            }
            if ((structurePiece = this.a(start, list, holder, random, x2, y2, z2, orientation, chainLength + 1)) != null) {
                holder.a(structurePiece);
                start.d.add(structurePiece);
            }
            return structurePiece;
        }

        @Nullable
        protected StructurePiece a(WorldGenNetherPiece15 start, StructurePieceAccessor holder, Random random, int leftRightOffset, int heightOffset, boolean inside) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, direction, this.g(), inside);
                    }
                    case d: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, direction, this.g(), inside);
                    }
                    case e: {
                        return this.a(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, direction, this.g(), inside);
                    }
                    case f: {
                        return this.a(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, direction, this.g(), inside);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece b(WorldGenNetherPiece15 start, StructurePieceAccessor holder, Random random, int heightOffset, int leftRightOffset, boolean inside) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return this.a(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.e, this.g(), inside);
                    }
                    case d: {
                        return this.a(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.e, this.g(), inside);
                    }
                    case e: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, EnumDirection.c, this.g(), inside);
                    }
                    case f: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, EnumDirection.c, this.g(), inside);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece c(WorldGenNetherPiece15 start, StructurePieceAccessor holder, Random random, int heightOffset, int leftRightOffset, boolean inside) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return this.a(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.f, this.g(), inside);
                    }
                    case d: {
                        return this.a(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.f, this.g(), inside);
                    }
                    case e: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, EnumDirection.d, this.g(), inside);
                    }
                    case f: {
                        return this.a(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, EnumDirection.d, this.g(), inside);
                    }
                }
            }
            return null;
        }

        protected static boolean a(StructureBoundingBox boundingBox) {
            return boundingBox != null && boundingBox.h() > 10;
        }
    }
}

