/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructurePiece {
    private static final Logger a = LogManager.getLogger();
    protected static final IBlockData z = Blocks.lp.n();
    protected StructureBoundingBox A;
    @Nullable
    private EnumDirection b;
    private EnumBlockMirror c;
    private EnumBlockRotation d;
    protected int B;
    private final WorldGenFeatureStructurePieceType e;
    private static final Set<Block> f = ImmutableSet.builder().add((Object)Blocks.ef).add((Object)Blocks.bR).add((Object)Blocks.bS).add((Object)Blocks.cR).add((Object)Blocks.iA).add((Object)Blocks.iE).add((Object)Blocks.iD).add((Object)Blocks.iB).add((Object)Blocks.iC).add((Object)Blocks.cn).add((Object)Blocks.dP).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
        this.e = type;
        this.B = length;
        this.A = boundingBox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
        this(type, nbt.h("GD"), (StructureBoundingBox)StructureBoundingBox.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("BB")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int i2 = nbt.h("O");
        this.a(i2 == -1 ? null : EnumDirection.b(i2));
    }

    protected static StructureBoundingBox a(int x2, int y2, int z2, EnumDirection orientation, int width, int height, int depth) {
        if (orientation.n() == EnumDirection.EnumAxis.c) {
            return new StructureBoundingBox(x2, y2, z2, x2 + width - 1, y2 + height - 1, z2 + depth - 1);
        }
        return new StructureBoundingBox(x2, y2, z2, x2 + depth - 1, y2 + height - 1, z2 + width - 1);
    }

    protected static EnumDirection b(Random random) {
        return EnumDirection.EnumDirectionLimit.a.a(random);
    }

    public final NBTTagCompound a(StructurePieceSerializationContext context) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("id", IRegistry.ba.b(this.j()).toString());
        StructureBoundingBox.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.A).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(tag -> compoundTag.a("BB", (NBTBase)tag));
        EnumDirection direction = this.h();
        compoundTag.a("O", direction == null ? -1 : direction.d());
        compoundTag.a("GD", this.B);
        this.a(context, compoundTag);
        return compoundTag;
    }

    protected abstract void a(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public NoiseEffect ac_() {
        return NoiseEffect.c;
    }

    public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
    }

    public abstract void a(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, Random var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox f() {
        return this.A;
    }

    public int g() {
        return this.B;
    }

    public boolean a(ChunkCoordIntPair pos, int offset) {
        int i2 = pos.d();
        int j2 = pos.e();
        return this.A.a(i2 - offset, j2 - offset, i2 + 15 + offset, j2 + 15 + offset);
    }

    public BlockPosition ad_() {
        return new BlockPosition(this.A.f());
    }

    protected BlockPosition.MutableBlockPosition c(int x2, int y2, int z2) {
        return new BlockPosition.MutableBlockPosition(this.a(x2, z2), this.a(y2), this.b(x2, z2));
    }

    protected int a(int x2, int z2) {
        EnumDirection direction = this.h();
        if (direction == null) {
            return x2;
        }
        switch (direction) {
            case c: 
            case d: {
                return this.A.g() + x2;
            }
            case e: {
                return this.A.j() - z2;
            }
            case f: {
                return this.A.g() + z2;
            }
        }
        return x2;
    }

    protected int a(int y2) {
        if (this.h() == null) {
            return y2;
        }
        return y2 + this.A.h();
    }

    protected int b(int x2, int z2) {
        EnumDirection direction = this.h();
        if (direction == null) {
            return z2;
        }
        switch (direction) {
            case c: {
                return this.A.l() - z2;
            }
            case d: {
                return this.A.i() + z2;
            }
            case e: 
            case f: {
                return this.A.i() + x2;
            }
        }
        return z2;
    }

    protected void c(GeneratorAccessSeed world, IBlockData block, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.c(x2, y2, z2);
        if (!box.b(blockPos)) {
            return;
        }
        if (!this.a(world, x2, y2, z2, box)) {
            return;
        }
        if (this.c != EnumBlockMirror.a) {
            block = block.a(this.c);
        }
        if (this.d != EnumBlockRotation.a) {
            block = block.a(this.d);
        }
        world.a((BlockPosition)blockPos, block, 2);
        Fluid fluidState = world.b_(blockPos);
        if (!fluidState.c()) {
            world.a((BlockPosition)blockPos, fluidState.a(), 0);
        }
        if (f.contains(block.b())) {
            world.z(blockPos).e(blockPos);
        }
    }

    protected boolean a(IWorldReader world, int x2, int y2, int z2, StructureBoundingBox box) {
        return true;
    }

    protected IBlockData a(IBlockAccess world, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.c(x2, y2, z2);
        if (!box.b(blockPos)) {
            return Blocks.a.n();
        }
        return world.a_(blockPos);
    }

    protected boolean b(IWorldReader world, int x2, int z2, int y2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.c(x2, z2 + 1, y2);
        if (!box.b(blockPos)) {
            return false;
        }
        return blockPos.v() < world.a(HeightMap.Type.c, blockPos.u(), blockPos.w());
    }

    protected void b(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    this.c(world, Blocks.a.n(), j2, i2, k2, bounds);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).g()) continue;
                    if (i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ) {
                        this.c(world, outline, j2, i2, k2, box);
                        continue;
                    }
                    this.c(world, inside, j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), outline, inside, cantReplaceAir);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean cantReplaceAir, Random random, StructurePieceBlockSelector randomizer) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).g()) continue;
                    randomizer.a(random, j2, i2, k2, i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ);
                    this.c(world, randomizer.a(), j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, boolean cantReplaceAir, Random random, StructurePieceBlockSelector randomizer) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), cantReplaceAir, random, randomizer);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, Random random, float blockChance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir, boolean stayBelowSeaLevel) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (random.nextFloat() > blockChance || cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).g() || stayBelowSeaLevel && !this.b(world, j2, i2, k2, box)) continue;
                    if (i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ) {
                        this.c(world, outline, j2, i2, k2, box);
                        continue;
                    }
                    this.c(world, inside, j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, Random random, float threshold, int x2, int y2, int z2, IBlockData state) {
        if (random.nextFloat() < threshold) {
            this.c(world, state, x2, y2, z2, bounds);
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData block, boolean cantReplaceAir) {
        float f2 = maxX - minX + 1;
        float g2 = maxY - minY + 1;
        float h2 = maxZ - minZ + 1;
        float i2 = (float)minX + f2 / 2.0f;
        float j2 = (float)minZ + h2 / 2.0f;
        for (int k2 = minY; k2 <= maxY; ++k2) {
            float l2 = (float)(k2 - minY) / g2;
            for (int m2 = minX; m2 <= maxX; ++m2) {
                float n2 = ((float)m2 - i2) / (f2 * 0.5f);
                for (int o2 = minZ; o2 <= maxZ; ++o2) {
                    float q2;
                    float p2 = ((float)o2 - j2) / (h2 * 0.5f);
                    if (cantReplaceAir && this.a((IBlockAccess)world, m2, k2, o2, bounds).g() || !((q2 = n2 * n2 + l2 * l2 + p2 * p2) <= 1.05f)) continue;
                    this.c(world, block, m2, k2, o2, bounds);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition mutableBlockPos = this.c(x2, y2, z2);
        if (!box.b(mutableBlockPos)) {
            return;
        }
        while (this.a(world.a_(mutableBlockPos)) && mutableBlockPos.v() > world.u_() + 1) {
            world.a((BlockPosition)mutableBlockPos, state, 2);
            mutableBlockPos.c(EnumDirection.a);
        }
    }

    protected boolean a(IBlockData state) {
        return state.g() || state.c().a() || state.a(Blocks.dY) || state.a(Blocks.ba) || state.a(Blocks.bb);
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, Random random, int x2, int y2, int z2, MinecraftKey lootTableId) {
        return this.a((WorldAccess)world, boundingBox, random, this.c(x2, y2, z2), lootTableId, null);
    }

    public static IBlockData a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        EnumDirection direction = null;
        for (EnumDirection direction2 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction2);
            IBlockData blockState = world.a_(blockPos);
            if (blockState.a(Blocks.bX)) {
                return state;
            }
            if (!blockState.i(world, blockPos)) continue;
            if (direction == null) {
                direction = direction2;
                continue;
            }
            direction = null;
            break;
        }
        if (direction != null) {
            return (IBlockData)state.a(BlockFacingHorizontal.aE, direction.f());
        }
        EnumDirection direction3 = state.c(BlockFacingHorizontal.aE);
        BlockPosition blockPos2 = pos.a(direction3);
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.f();
            blockPos2 = pos.a(direction3);
        }
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.g();
            blockPos2 = pos.a(direction3);
        }
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.f();
            blockPos2 = pos.a(direction3);
        }
        return (IBlockData)state.a(BlockFacingHorizontal.aE, direction3);
    }

    protected boolean a(WorldAccess world, StructureBoundingBox boundingBox, Random random, BlockPosition pos, MinecraftKey lootTableId, @Nullable IBlockData block) {
        if (!boundingBox.b(pos) || world.a_(pos).a(Blocks.bX)) {
            return false;
        }
        if (block == null) {
            block = StructurePiece.a(world, pos, Blocks.bX.n());
        }
        world.a(pos, block, 2);
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityChest) {
            ((TileEntityChest)blockEntity).a(lootTableId, random.nextLong());
        }
        return true;
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, Random random, int x2, int y2, int z2, EnumDirection facing, MinecraftKey lootTableId) {
        BlockPosition.MutableBlockPosition blockPos = this.c(x2, y2, z2);
        if (boundingBox.b(blockPos) && !world.a_(blockPos).a(Blocks.ay)) {
            this.c(world, (IBlockData)Blocks.ay.n().a(BlockDispenser.a, facing), x2, y2, z2, boundingBox);
            TileEntity blockEntity = world.c_(blockPos);
            if (blockEntity instanceof TileEntityDispenser) {
                ((TileEntityDispenser)blockEntity).a(lootTableId, random.nextLong());
            }
            return true;
        }
        return false;
    }

    public void a(int x2, int y2, int z2) {
        this.A.a(x2, y2, z2);
    }

    public static StructureBoundingBox a(Stream<StructurePiece> pieces) {
        return StructureBoundingBox.b(pieces.map(StructurePiece::f)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece a(List<StructurePiece> pieces, StructureBoundingBox box) {
        for (StructurePiece structurePiece : pieces) {
            if (!structurePiece.f().a(box)) continue;
            return structurePiece;
        }
        return null;
    }

    @Nullable
    public EnumDirection h() {
        return this.b;
    }

    public void a(@Nullable EnumDirection orientation) {
        this.b = orientation;
        if (orientation == null) {
            this.d = EnumBlockRotation.a;
            this.c = EnumBlockMirror.a;
        } else {
            switch (orientation) {
                case d: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.a;
                    break;
                }
                case e: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                case f: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                default: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.a;
                }
            }
        }
    }

    public EnumBlockRotation ab_() {
        return this.d;
    }

    public EnumBlockMirror i() {
        return this.c;
    }

    public WorldGenFeatureStructurePieceType j() {
        return this.e;
    }

    protected static abstract class StructurePieceBlockSelector {
        protected IBlockData a = Blocks.a.n();

        protected StructurePieceBlockSelector() {
        }

        public abstract void a(Random var1, int var2, int var3, int var4, boolean var5);

        public IBlockData a() {
            return this.a;
        }
    }
}

