/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureCheck {
    private static final Logger a = LogManager.getLogger();
    private static final int b = -1;
    private final ChunkScanAccess c;
    private final IRegistryCustom d;
    private final IRegistry<BiomeBase> e;
    private final DefinedStructureManager f;
    private final ResourceKey<World> g;
    private final ChunkGenerator h;
    private final LevelHeightAccessor i;
    private final WorldChunkManager j;
    private final long k;
    private final DataFixer l;
    private final Long2ObjectMap<Object2IntMap<StructureGenerator<?>>> m = new Long2ObjectOpenHashMap();
    private final Map<StructureGenerator<?>, Long2BooleanMap> n = new HashMap();

    public StructureCheck(ChunkScanAccess chunkIoWorker, IRegistryCustom registryManager, DefinedStructureManager structureManager, ResourceKey<World> worldKey, ChunkGenerator chunkGenerator, LevelHeightAccessor world, WorldChunkManager biomeSource, long seed, DataFixer dataFixer) {
        this.c = chunkIoWorker;
        this.d = registryManager;
        this.f = structureManager;
        this.g = worldKey;
        this.h = chunkGenerator;
        this.i = world;
        this.j = biomeSource;
        this.k = seed;
        this.l = dataFixer;
        this.e = registryManager.b(IRegistry.aR);
    }

    public <F extends StructureGenerator<?>> StructureCheckResult a(ChunkCoordIntPair pos2, F feature2, boolean skipExistingChunk) {
        long l2 = pos2.a();
        Object2IntMap object2IntMap = (Object2IntMap)this.m.get(l2);
        if (object2IntMap != null) {
            return this.a(object2IntMap, feature2, skipExistingChunk);
        }
        StructureCheckResult structureCheckResult = this.a(pos2, feature2, skipExistingChunk, l2);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        boolean bl = this.n.computeIfAbsent(feature2, feature -> new Long2BooleanOpenHashMap()).computeIfAbsent(l2, pos -> {
            ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>> multimap = this.h.d().b(feature2);
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                if (!this.a(pos2, (StructureFeature)entry.getKey(), (Collection)entry.getValue())) continue;
                return true;
            }
            return false;
        });
        if (!bl) {
            return StructureCheckResult.b;
        }
        return StructureCheckResult.c;
    }

    private <FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> boolean a(ChunkCoordIntPair pos, StructureFeature<FC, F> feature, Collection<ResourceKey<BiomeBase>> allowedBiomes) {
        Predicate<BiomeBase> predicate = biome -> this.e.c((BiomeBase)biome).filter(allowedBiomes::contains).isPresent();
        return ((StructureGenerator)feature.d).a(this.d, this.h, this.j, this.f, this.k, pos, feature.e, this.i, predicate);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private StructureCheckResult a(ChunkCoordIntPair pos, StructureGenerator<?> feature, boolean skipExistingChunk, long posLong) {
        void compoundTag3;
        CollectFields collectFields = new CollectFields(new CollectFields.b(NBTTagInt.a, "DataVersion"), new CollectFields.b("Level", "Structures", NBTTagCompound.b, "Starts"), new CollectFields.b("structures", NBTTagCompound.b, "starts"));
        try {
            this.c.a(pos, collectFields).join();
        }
        catch (Exception exception) {
            a.warn("Failed to read chunk {}", (Object)pos, (Object)exception);
            return StructureCheckResult.c;
        }
        NBTBase tag = collectFields.d();
        if (!(tag instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        int i2 = IChunkLoader.a(compoundTag);
        if (i2 <= 1493) {
            return StructureCheckResult.c;
        }
        IChunkLoader.a(compoundTag, this.g, this.h.b());
        try {
            NBTTagCompound compoundTag2 = GameProfileSerializer.a(this.l, DataFixTypes.c, compoundTag, i2);
        }
        catch (Exception exception2) {
            a.warn("Failed to partially datafix chunk {}", (Object)pos, (Object)exception2);
            return StructureCheckResult.c;
        }
        Object2IntMap<StructureGenerator<?>> object2IntMap = this.a((NBTTagCompound)compoundTag3);
        if (object2IntMap == null) {
            return null;
        }
        this.a(posLong, object2IntMap);
        return this.a(object2IntMap, feature, skipExistingChunk);
    }

    @Nullable
    private Object2IntMap<StructureGenerator<?>> a(NBTTagCompound nbt) {
        if (!nbt.b("structures", 10)) {
            return null;
        }
        NBTTagCompound compoundTag = nbt.p("structures");
        if (!compoundTag.b("starts", 10)) {
            return null;
        }
        NBTTagCompound compoundTag2 = compoundTag.p("starts");
        if (compoundTag2.f()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        for (String string : compoundTag2.d()) {
            String string3;
            NBTTagCompound compoundTag3;
            String string2 = string.toLowerCase(Locale.ROOT);
            StructureGenerator structureFeature = (StructureGenerator)StructureGenerator.b.get((Object)string2);
            if (structureFeature == null || (compoundTag3 = compoundTag2.p(string)).f() || "INVALID".equals(string3 = compoundTag3.l("id"))) continue;
            int i2 = compoundTag3.h("references");
            object2IntMap.put((Object)structureFeature, i2);
        }
        return object2IntMap;
    }

    private static Object2IntMap<StructureGenerator<?>> a(Object2IntMap<StructureGenerator<?>> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult a(Object2IntMap<StructureGenerator<?>> referencesByStructure, StructureGenerator<?> feature, boolean skipExistingChunk) {
        int i2 = referencesByStructure.getOrDefault(feature, -1);
        return i2 != -1 && (!skipExistingChunk || i2 == 0) ? StructureCheckResult.a : StructureCheckResult.b;
    }

    public void a(ChunkCoordIntPair pos, Map<StructureGenerator<?>, StructureStart<?>> structureStarts) {
        long l2 = pos.a();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        structureStarts.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)object2IntMap, arg_0, arg_1));
        this.a(l2, (Object2IntMap<StructureGenerator<?>>)object2IntMap);
    }

    private void a(long pos, Object2IntMap<StructureGenerator<?>> referencesByStructure) {
        this.m.put(pos, StructureCheck.a(referencesByStructure));
        this.n.values().forEach(generationPossibilityByChunkPos -> generationPossibilityByChunkPos.remove(pos));
    }

    public void a(ChunkCoordIntPair pos2, StructureGenerator<?> feature) {
        this.m.compute(pos2.a(), (pos, referencesByStructure) -> {
            if (referencesByStructure == null || referencesByStructure.isEmpty()) {
                referencesByStructure = new Object2IntOpenHashMap();
            }
            referencesByStructure.computeInt((Object)feature, (feature, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }

    private static /* synthetic */ void a(Object2IntMap feature, StructureGenerator start, StructureStart structureStart) {
        if (structureStart.b()) {
            feature.put((Object)start, structureStart.f());
        }
    }
}

