/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> a = SystemUtils.a(Maps.newHashMap(), (T hashmap) -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> b = SystemUtils.a(Maps.newHashMap(), (T hashmap) -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private final boolean c;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> d = Maps.newHashMap();
    private final Map<String, PersistentIndexed> e = Maps.newHashMap();
    private final List<String> f;
    private final List<String> g;

    public PersistentStructureLegacy(@Nullable WorldPersistentData persistentStateManager, List<String> list, List<String> list1) {
        this.f = list;
        this.g = list1;
        this.a(persistentStateManager);
        boolean flag = false;
        for (String s2 : this.g) {
            flag |= this.d.get(s2) != null;
        }
        this.c = flag;
    }

    public void a(long i2) {
        for (String s2 : this.f) {
            PersistentIndexed persistentindexed = this.e.get(s2);
            if (persistentindexed == null || !persistentindexed.c(i2)) continue;
            persistentindexed.d(i2);
            persistentindexed.b();
        }
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1 = nbt.p("Level");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound1.h("xPos"), nbttagcompound1.h("zPos"));
        if (this.a(chunkcoordintpair.c, chunkcoordintpair.d)) {
            nbt = this.a(nbt, chunkcoordintpair);
        }
        NBTTagCompound nbttagcompound2 = nbttagcompound1.p("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.p("References");
        for (String s2 : this.g) {
            StructureGenerator structuregenerator = (StructureGenerator)StructureGenerator.b.get((Object)s2.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.b(s2, 12) || structuregenerator == null) continue;
            boolean flag = true;
            LongArrayList longarraylist = new LongArrayList();
            for (int i2 = chunkcoordintpair.c - 8; i2 <= chunkcoordintpair.c + 8; ++i2) {
                for (int j2 = chunkcoordintpair.d - 8; j2 <= chunkcoordintpair.d + 8; ++j2) {
                    if (!this.a(i2, j2, s2)) continue;
                    longarraylist.add(ChunkCoordIntPair.a(i2, j2));
                }
            }
            nbttagcompound3.c(s2, (List<Long>)longarraylist);
        }
        nbttagcompound2.a("References", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbt.a("Level", nbttagcompound1);
        return nbt;
    }

    private boolean a(int chunkX, int chunkZ, String id) {
        return !this.c ? false : this.d.get(id) != null && this.e.get(a.get(id)).b(ChunkCoordIntPair.a(chunkX, chunkZ));
    }

    private boolean a(int chunkX, int chunkZ) {
        String s2;
        if (!this.c) {
            return false;
        }
        Iterator<String> iterator = this.g.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.d.get(s2 = iterator.next()) == null || !this.e.get(a.get(s2)).c(ChunkCoordIntPair.a(chunkX, chunkZ)));
        return true;
    }

    private NBTTagCompound a(NBTTagCompound nbt, ChunkCoordIntPair pos) {
        NBTTagCompound nbttagcompound1 = nbt.p("Level");
        NBTTagCompound nbttagcompound2 = nbttagcompound1.p("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.p("Starts");
        for (String s2 : this.g) {
            NBTTagCompound nbttagcompound4;
            Long2ObjectMap<NBTTagCompound> long2objectmap = this.d.get(s2);
            if (long2objectmap == null) continue;
            long i2 = pos.a();
            if (!this.e.get(a.get(s2)).c(i2) || (nbttagcompound4 = (NBTTagCompound)long2objectmap.get(i2)) == null) continue;
            nbttagcompound3.a(s2, nbttagcompound4);
        }
        nbttagcompound2.a("Starts", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbt.a("Level", nbttagcompound1);
        return nbt;
    }

    private void a(@Nullable WorldPersistentData persistentStateManager) {
        if (persistentStateManager != null) {
            for (String s2 : this.f) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    nbttagcompound = persistentStateManager.a(s2, 1493).p("data").p("Features");
                    if (nbttagcompound.f()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String s1 : nbttagcompound.d()) {
                    String s22;
                    String s3;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.p(s1);
                    long i2 = ChunkCoordIntPair.a(nbttagcompound1.h("ChunkX"), nbttagcompound1.h("ChunkZ"));
                    NBTTagList nbttaglist = nbttagcompound1.c("Children", 10);
                    if (!nbttaglist.isEmpty() && (s3 = b.get(s22 = nbttaglist.a(0).l("id"))) != null) {
                        nbttagcompound1.a("id", s3);
                    }
                    s22 = nbttagcompound1.l("id");
                    this.d.computeIfAbsent(s22, s4 -> new Long2ObjectOpenHashMap()).put(i2, (Object)nbttagcompound1);
                }
                String s42 = s2 + "_index";
                PersistentIndexed persistentindexed = persistentStateManager.a(PersistentIndexed::b, PersistentIndexed::new, s42);
                if (!persistentindexed.a().isEmpty()) {
                    this.e.put(s2, persistentindexed);
                    continue;
                }
                PersistentIndexed persistentindexed1 = new PersistentIndexed();
                this.e.put(s2, persistentindexed1);
                for (String s5 : nbttagcompound.d()) {
                    NBTTagCompound nbttagcompound2 = nbttagcompound.p(s5);
                    persistentindexed1.a(ChunkCoordIntPair.a(nbttagcompound2.h("ChunkX"), nbttagcompound2.h("ChunkZ")));
                }
                persistentindexed1.b();
            }
        }
    }

    public static PersistentStructureLegacy a(ResourceKey<WorldDimension> world, @Nullable WorldPersistentData persistentStateManager) {
        if (world == WorldDimension.b) {
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (world == WorldDimension.c) {
            ImmutableList immutablelist = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        if (world == WorldDimension.d) {
            ImmutableList immutablelist = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        throw new RuntimeException(String.format("Unknown dimension type : %s", world));
    }
}

