/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PlacedFeature {
    public static final Codec<PlacedFeature> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldGenFeatureConfigured.b.fieldOf("feature").forGetter(placedFeature -> placedFeature.d), (App)PlacementModifier.b.listOf().fieldOf("placement").forGetter(placedFeature -> placedFeature.e)).apply((Applicative)instance, PlacedFeature::new));
    public static final Codec<Supplier<PlacedFeature>> b = RegistryFileCodec.a(IRegistry.aN, a);
    public static final Codec<List<Supplier<PlacedFeature>>> c = RegistryFileCodec.b(IRegistry.aN, a);
    private final Supplier<WorldGenFeatureConfigured<?, ?>> d;
    private final List<PlacementModifier> e;

    public PlacedFeature(Supplier<WorldGenFeatureConfigured<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        this.d = feature;
        this.e = placementModifiers;
    }

    public boolean a(GeneratorAccessSeed world, ChunkGenerator generator, Random random, BlockPosition pos) {
        return this.a(new PlacementContext(world, generator, Optional.empty()), random, pos);
    }

    public boolean b(GeneratorAccessSeed world, ChunkGenerator generator, Random random, BlockPosition pos) {
        return this.a(new PlacementContext(world, generator, Optional.of(this)), random, pos);
    }

    private boolean a(PlacementContext context, Random random, BlockPosition pos2) {
        Stream<BlockPosition> stream = Stream.of(pos2);
        for (PlacementModifier placementModifier : this.e) {
            stream = stream.flatMap(pos -> placementModifier.a_(context, random, (BlockPosition)pos));
        }
        WorldGenFeatureConfigured<?, ?> configuredFeature = this.d.get();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(blockPos -> {
            if (configuredFeature.a(context.d(), context.f(), random, (BlockPosition)blockPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> a() {
        return this.d.get().d();
    }

    @VisibleForDebug
    public List<PlacementModifier> b() {
        return this.e;
    }

    @Override
    public String toString() {
        return "Placed " + IRegistry.aW.b((WorldGenerator<?>)this.d.get().a());
    }
}

