/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger b = LogManager.getLogger();
    public static final Codec<GeneratorSettingsFlat> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.a(IRegistry.aR).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.c), (App)StructureSettings.a.fieldOf("structures").forGetter(GeneratorSettingsFlat::d), (App)WorldGenFlatLayerInfo.a.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::f), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.j), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.i), (App)BiomeBase.d.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(flatLevelGeneratorSettings -> Optional.of(flatLevelGeneratorSettings.f))).apply((Applicative)instance, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::a, Function.identity()).stable();
    private final IRegistry<BiomeBase> c;
    private final StructureSettings d;
    private final List<WorldGenFlatLayerInfo> e = Lists.newArrayList();
    private Supplier<BiomeBase> f;
    private final List<IBlockData> g;
    private boolean h;
    private boolean i;
    private boolean j;

    private static DataResult<GeneratorSettingsFlat> a(GeneratorSettingsFlat config) {
        int i2 = config.e.stream().mapToInt(WorldGenFlatLayerInfo::a).sum();
        if (i2 > DimensionManager.c) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionManager.c), (Object)config);
        }
        return DataResult.success((Object)config);
    }

    private GeneratorSettingsFlat(IRegistry<BiomeBase> biomeRegistry, StructureSettings structuresConfig, List<WorldGenFlatLayerInfo> layers, boolean hasLakes, boolean hasFeatures, Optional<Supplier<BiomeBase>> biome) {
        this(structuresConfig, biomeRegistry);
        if (hasLakes) {
            this.b();
        }
        if (hasFeatures) {
            this.a();
        }
        this.e.addAll(layers);
        this.h();
        if (!biome.isPresent()) {
            b.error("Unknown biome, defaulting to plains");
            this.f = () -> biomeRegistry.d(Biomes.b);
        } else {
            this.f = biome.get();
        }
    }

    public GeneratorSettingsFlat(StructureSettings structuresConfig, IRegistry<BiomeBase> biomeRegistry) {
        this.c = biomeRegistry;
        this.d = structuresConfig;
        this.f = () -> biomeRegistry.d(Biomes.b);
        this.g = Lists.newArrayList();
    }

    public GeneratorSettingsFlat a(StructureSettings structuresConfig) {
        return this.a(this.e, structuresConfig);
    }

    public GeneratorSettingsFlat a(List<WorldGenFlatLayerInfo> layers, StructureSettings structuresConfig) {
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(structuresConfig, this.c);
        for (WorldGenFlatLayerInfo flatLayerInfo : layers) {
            flatLevelGeneratorSettings.e.add(new WorldGenFlatLayerInfo(flatLayerInfo.a(), flatLayerInfo.b().b()));
            flatLevelGeneratorSettings.h();
        }
        flatLevelGeneratorSettings.a(this.f);
        if (this.i) {
            flatLevelGeneratorSettings.a();
        }
        if (this.j) {
            flatLevelGeneratorSettings.b();
        }
        return flatLevelGeneratorSettings;
    }

    public void a() {
        this.i = true;
    }

    public void b() {
        this.j = true;
    }

    public BiomeBase c() {
        boolean bl;
        BiomeBase biome = this.e();
        BiomeSettingsGeneration biomeGenerationSettings = biome.e();
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a();
        if (this.j) {
            builder.a(WorldGenStage.Decoration.b, MiscOverworldPlacements.g);
            builder.a(WorldGenStage.Decoration.b, MiscOverworldPlacements.h);
        }
        boolean bl2 = bl = (!this.h || this.c.c(biome).equals(Optional.of(Biomes.a))) && this.i;
        if (bl) {
            List<List<Supplier<PlacedFeature>>> list = biomeGenerationSettings.b();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 == WorldGenStage.Decoration.d.ordinal() || i2 == WorldGenStage.Decoration.e.ordinal()) continue;
                List<Supplier<PlacedFeature>> list2 = list.get(i2);
                for (Supplier<PlacedFeature> supplier : list2) {
                    builder.a(i2, supplier);
                }
            }
        }
        List<IBlockData> list3 = this.g();
        for (int j2 = 0; j2 < list3.size(); ++j2) {
            IBlockData blockState = list3.get(j2);
            if (HeightMap.Type.e.e().test(blockState)) continue;
            list3.set(j2, null);
            builder.a(WorldGenStage.Decoration.k, WorldGenerator.ad.a(new WorldGenFeatureFillConfiguration(j2, blockState)).a(new PlacementModifier[0]));
        }
        return new BiomeBase.a().a(biome.c()).a(biome.r()).a(biome.i()).b(biome.h()).a(biome.j()).a(builder.a()).a(biome.b()).a();
    }

    public StructureSettings d() {
        return this.d;
    }

    public BiomeBase e() {
        return this.f.get();
    }

    public void a(Supplier<BiomeBase> biome) {
        this.f = biome;
    }

    public List<WorldGenFlatLayerInfo> f() {
        return this.e;
    }

    public List<IBlockData> g() {
        return this.g;
    }

    public void h() {
        this.g.clear();
        for (WorldGenFlatLayerInfo flatLayerInfo : this.e) {
            for (int i2 = 0; i2 < flatLayerInfo.a(); ++i2) {
                this.g.add(flatLayerInfo.b());
            }
        }
        this.h = this.g.stream().allMatch(state -> state.a(Blocks.a));
    }

    public static GeneratorSettingsFlat a(IRegistry<BiomeBase> biomeRegistry) {
        StructureSettings structureSettings = new StructureSettings(Optional.of(StructureSettings.c), Maps.newHashMap((Map)ImmutableMap.of(StructureGenerator.r, (Object)((StructureSettingsFeature)StructureSettings.b.get(StructureGenerator.r)))));
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(structureSettings, biomeRegistry);
        flatLevelGeneratorSettings.f = () -> biomeRegistry.d(Biomes.b);
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(1, Blocks.z));
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(2, Blocks.j));
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(1, Blocks.i));
        flatLevelGeneratorSettings.h();
        return flatLevelGeneratorSettings;
    }
}

