/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorGravity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenFeatureDefinedStructurePoolTemplate {
    private static final Logger c = LogManager.getLogger();
    private static final int d = Integer.MIN_VALUE;
    public static final Codec<WorldGenFeatureDefinedStructurePoolTemplate> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("name").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::b), (App)MinecraftKey.a.fieldOf("fallback").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::a), (App)Codec.mapPair((MapCodec)WorldGenFeatureDefinedStructurePoolStructure.e.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.f)).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolTemplate::new));
    public static final Codec<Supplier<WorldGenFeatureDefinedStructurePoolTemplate>> b = RegistryFileCodec.a(IRegistry.aQ, a);
    private final MinecraftKey e;
    private final List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> f;
    private final List<WorldGenFeatureDefinedStructurePoolStructure> g;
    private final MinecraftKey h;
    private int i = Integer.MIN_VALUE;

    public WorldGenFeatureDefinedStructurePoolTemplate(MinecraftKey id, MinecraftKey terminatorsId, List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> elementCounts) {
        this.e = id;
        this.f = elementCounts;
        this.g = Lists.newArrayList();
        for (Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer> pair : elementCounts) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = (WorldGenFeatureDefinedStructurePoolStructure)pair.getFirst();
            for (int i2 = 0; i2 < (Integer)pair.getSecond(); ++i2) {
                this.g.add(structurePoolElement);
            }
        }
        this.h = terminatorsId;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate(MinecraftKey id, MinecraftKey terminatorsId, List<Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>> elementCounts, Matching projection) {
        this.e = id;
        this.f = Lists.newArrayList();
        this.g = Lists.newArrayList();
        for (Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer> pair : elementCounts) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = (WorldGenFeatureDefinedStructurePoolStructure)((Function)pair.getFirst()).apply(projection);
            this.f.add((Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>)Pair.of((Object)structurePoolElement, (Object)((Integer)pair.getSecond())));
            for (int i2 = 0; i2 < (Integer)pair.getSecond(); ++i2) {
                this.g.add(structurePoolElement);
            }
        }
        this.h = terminatorsId;
    }

    public int a(DefinedStructureManager structureManager) {
        if (this.i == Integer.MIN_VALUE) {
            this.i = this.g.stream().filter(structurePoolElement -> structurePoolElement != WorldGenFeatureDefinedStructurePoolEmpty.b).mapToInt(element -> element.a(structureManager, BlockPosition.b, EnumBlockRotation.a).d()).max().orElse(0);
        }
        return this.i;
    }

    public MinecraftKey a() {
        return this.h;
    }

    public WorldGenFeatureDefinedStructurePoolStructure a(Random random) {
        return this.g.get(random.nextInt(this.g.size()));
    }

    public List<WorldGenFeatureDefinedStructurePoolStructure> b(Random random) {
        return ImmutableList.copyOf((Object[])((WorldGenFeatureDefinedStructurePoolStructure[])ObjectArrays.shuffle((Object[])this.g.toArray(new WorldGenFeatureDefinedStructurePoolStructure[0]), (Random)random)));
    }

    public MinecraftKey b() {
        return this.e;
    }

    public int c() {
        return this.g.size();
    }

    public static final class Matching
    extends Enum<Matching>
    implements INamable {
        public static final /* enum */ Matching a = new Matching("terrain_matching", (ImmutableList<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorGravity(HeightMap.Type.a, -1)));
        public static final /* enum */ Matching b = new Matching("rigid", (ImmutableList<DefinedStructureProcessor>)ImmutableList.of());
        public static final Codec<Matching> c;
        private static final Map<String, Matching> d;
        private final String e;
        private final ImmutableList<DefinedStructureProcessor> f;
        private static final /* synthetic */ Matching[] g;

        public static Matching[] values() {
            return (Matching[])g.clone();
        }

        public static Matching valueOf(String string) {
            return Enum.valueOf(Matching.class, string);
        }

        private Matching(String id, ImmutableList<DefinedStructureProcessor> processors) {
            this.e = id;
            this.f = processors;
        }

        public String a() {
            return this.e;
        }

        public static Matching a(String id) {
            return d.get(id);
        }

        public ImmutableList<DefinedStructureProcessor> b() {
            return this.f;
        }

        @Override
        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ Matching[] d() {
            return new Matching[]{a, b};
        }

        static {
            g = Matching.d();
            c = INamable.a(Matching::values, Matching::a);
            d = Arrays.stream(Matching.values()).collect(Collectors.toMap(Matching::a, projection -> projection));
        }
    }
}

