/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCanyon;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.carver.WorldGenCaves;
import net.minecraft.world.level.levelgen.carver.WorldGenCavesHell;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldGenCarverAbstract<C extends WorldGenCarverConfiguration> {
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> a = WorldGenCarverAbstract.a("cave", new WorldGenCaves(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> b = WorldGenCarverAbstract.a("nether_cave", new WorldGenCavesHell(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CanyonCarverConfiguration> c = WorldGenCarverAbstract.a("canyon", new WorldGenCanyon(CanyonCarverConfiguration.a));
    protected static final IBlockData d = Blocks.a.n();
    protected static final IBlockData e = Blocks.lp.n();
    protected static final Fluid f = FluidTypes.c.h();
    protected static final Fluid g = FluidTypes.e.h();
    protected Set<Block> h = ImmutableSet.of((Object)Blocks.A, (Object)Blocks.b, (Object)Blocks.c, (Object)Blocks.e, (Object)Blocks.g, (Object)Blocks.j, (Object[])new Block[]{Blocks.k, Blocks.l, Blocks.i, Blocks.hf, Blocks.fS, Blocks.fT, Blocks.fU, Blocks.fV, Blocks.fW, Blocks.fX, Blocks.fY, Blocks.fZ, Blocks.ga, Blocks.gb, Blocks.gc, Blocks.gd, Blocks.ge, Blocks.gf, Blocks.gg, Blocks.gh, Blocks.az, Blocks.hU, Blocks.ec, Blocks.cK, Blocks.hh, Blocks.pN, Blocks.oM, Blocks.C, Blocks.D, Blocks.E, Blocks.oL, Blocks.c, Blocks.H, Blocks.I, Blocks.qj, Blocks.oU, Blocks.oV, Blocks.qk});
    protected Set<FluidType> i = ImmutableSet.of((Object)FluidTypes.c);
    private final Codec<WorldGenCarverWrapper<C>> j;

    private static <C extends WorldGenCarverConfiguration, F extends WorldGenCarverAbstract<C>> F a(String name, F carver) {
        return (F)IRegistry.a(IRegistry.aU, name, carver);
    }

    public WorldGenCarverAbstract(Codec<C> configCodec) {
        this.j = configCodec.fieldOf("config").xmap(this::a, WorldGenCarverWrapper::a).codec();
    }

    public WorldGenCarverWrapper<C> a(C config) {
        return new WorldGenCarverWrapper<C>(this, config);
    }

    public Codec<WorldGenCarverWrapper<C>> c() {
        return this.j;
    }

    public int d() {
        return 4;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, BiomeBase> posToBiome, Aquifer aquiferSampler, double d2, double e2, double f2, double g2, double h2, CarvingMask mask, a skipPredicate) {
        ChunkCoordIntPair chunkPos = chunk.f();
        double i2 = chunkPos.b();
        double j2 = chunkPos.c();
        double k2 = 16.0 + g2 * 2.0;
        if (Math.abs(d2 - i2) > k2 || Math.abs(f2 - j2) > k2) {
            return false;
        }
        int l2 = chunkPos.d();
        int m2 = chunkPos.e();
        int n2 = Math.max(MathHelper.b(d2 - g2) - l2 - 1, 0);
        int o2 = Math.min(MathHelper.b(d2 + g2) - l2, 15);
        int p2 = Math.max(MathHelper.b(e2 - h2) - 1, context.a() + 1);
        int q2 = chunk.y() ? 0 : 7;
        int r2 = Math.min(MathHelper.b(e2 + h2) + 1, context.a() + context.b() - 1 - q2);
        int s2 = Math.max(MathHelper.b(f2 - g2) - m2 - 1, 0);
        int t2 = Math.min(MathHelper.b(f2 + g2) - m2, 15);
        boolean bl = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        for (int u2 = n2; u2 <= o2; ++u2) {
            int v2 = chunkPos.a(u2);
            double w2 = ((double)v2 + 0.5 - d2) / g2;
            for (int x2 = s2; x2 <= t2; ++x2) {
                int y2 = chunkPos.b(x2);
                double z2 = ((double)y2 + 0.5 - f2) / g2;
                if (w2 * w2 + z2 * z2 >= 1.0) continue;
                MutableBoolean mutableBoolean = new MutableBoolean(false);
                for (int aa2 = r2; aa2 > p2; --aa2) {
                    double ab = ((double)aa2 - 0.5 - e2) / h2;
                    if (skipPredicate.shouldSkip(context, w2, ab, z2, aa2) || mask.b(u2, aa2, x2) && !WorldGenCarverAbstract.b(config)) continue;
                    mask.a(u2, aa2, x2);
                    mutableBlockPos.d(v2, aa2, y2);
                    bl |= this.a(context, config, chunk, posToBiome, mask, mutableBlockPos, mutableBlockPos2, aquiferSampler, mutableBoolean);
                }
            }
        }
        return bl;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, BiomeBase> posToBiome, CarvingMask mask, BlockPosition.MutableBlockPosition mutableBlockPos, BlockPosition.MutableBlockPosition mutableBlockPos2, Aquifer aquiferSampler, MutableBoolean mutableBoolean) {
        IBlockData blockState = chunk.a_(mutableBlockPos);
        if (blockState.a(Blocks.i) || blockState.a(Blocks.ec)) {
            mutableBoolean.setTrue();
        }
        if (!this.a(blockState) && !WorldGenCarverAbstract.b(config)) {
            return false;
        }
        IBlockData blockState2 = this.a(context, config, mutableBlockPos, aquiferSampler);
        if (blockState2 == null) {
            return false;
        }
        chunk.a(mutableBlockPos, blockState2, false);
        if (aquiferSampler.a() && !blockState2.n().c()) {
            chunk.e(mutableBlockPos);
        }
        if (mutableBoolean.isTrue()) {
            mutableBlockPos2.a((BaseBlockPosition)mutableBlockPos, EnumDirection.a);
            if (chunk.a_(mutableBlockPos2).a(Blocks.j)) {
                context.a(posToBiome, chunk, mutableBlockPos2, !blockState2.n().c()).ifPresent(state -> {
                    chunk.a(mutableBlockPos2, (IBlockData)state, false);
                    if (!state.n().c()) {
                        chunk.e(mutableBlockPos2);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private IBlockData a(CarvingContext context, C config, BlockPosition pos, Aquifer sampler) {
        if (pos.v() <= ((WorldGenCarverConfiguration)config).g.a(context)) {
            return g.g();
        }
        IBlockData blockState = sampler.a(pos.u(), pos.v(), pos.w(), 0.0, 0.0);
        if (blockState == null) {
            return WorldGenCarverAbstract.b(config) ? ((WorldGenCarverConfiguration)config).h.e() : null;
        }
        return WorldGenCarverAbstract.b(config) ? WorldGenCarverAbstract.a(config, blockState) : blockState;
    }

    private static IBlockData a(WorldGenCarverConfiguration config, IBlockData state) {
        if (state.a(Blocks.a)) {
            return config.h.b();
        }
        if (state.a(Blocks.A)) {
            IBlockData blockState = config.h.c();
            if (blockState.b(BlockProperties.C)) {
                return (IBlockData)blockState.a(BlockProperties.C, true);
            }
            return blockState;
        }
        if (state.a(Blocks.B)) {
            return config.h.d();
        }
        return state;
    }

    public abstract boolean a(CarvingContext var1, C var2, IChunkAccess var3, Function<BlockPosition, BiomeBase> var4, Random var5, Aquifer var6, ChunkCoordIntPair var7, CarvingMask var8);

    public abstract boolean a(C var1, Random var2);

    protected boolean a(IBlockData state) {
        return this.h.contains(state.b());
    }

    protected static boolean a(ChunkCoordIntPair pos, double x2, double z2, int branchIndex, int branchCount, float baseWidth) {
        double i2;
        double h2;
        double e2;
        double g2;
        double d2 = pos.b();
        double f2 = x2 - d2;
        return f2 * f2 + (g2 = z2 - (e2 = (double)pos.c())) * g2 - (h2 = (double)(branchCount - branchIndex)) * h2 <= (i2 = (double)(baseWidth + 2.0f + 16.0f)) * i2;
    }

    private static boolean b(WorldGenCarverConfiguration config) {
        return config.h.a();
    }

    public static interface a {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

