/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.QuartPos;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender a = new Blender(null, List.of(), List.of()){

        @Override
        @Override
        public TerrainInfo a(int i2, int j2, TerrainInfo terrainInfo) {
            return terrainInfo;
        }

        @Override
        @Override
        public double a(int i2, int j2, int k2, double d2) {
            return d2;
        }

        @Override
        @Override
        public BiomeResolver a(BiomeResolver biomeSupplier) {
            return biomeSupplier;
        }
    };
    private static final NoiseGeneratorNormal b = NoiseGeneratorNormal.b(new XoroshiroRandomSource(42L), RegistryGeneration.k.d(Noises.j));
    private static final int c = QuartPos.d(7) - 1;
    private static final int d = QuartPos.e(c + 3);
    private static final int e = 2;
    private static final int f = QuartPos.e(5);
    private static final double g = 10.0;
    private static final double h = 0.0;
    private static final double i = (double)BlendingData.a.v_() / 2.0;
    private static final double j = (double)BlendingData.a.u_() + i;
    private static final double k = 8.0;
    private final RegionLimitedWorldAccess l;
    private final List<c> m;
    private final List<c> n;

    public static Blender a() {
        return a;
    }

    public static Blender a(@Nullable RegionLimitedWorldAccess chunkRegion) {
        if (chunkRegion == null) {
            return a;
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ChunkCoordIntPair chunkPos = chunkRegion.a();
        for (int i2 = -d; i2 <= d; ++i2) {
            for (int j2 = -d; j2 <= d; ++j2) {
                int k2 = chunkPos.c + i2;
                int l2 = chunkPos.d + j2;
                BlendingData blendingData = BlendingData.a(chunkRegion, k2, l2);
                if (blendingData == null) continue;
                c positionedBlendingData = new c(k2, l2, blendingData);
                list.add(positionedBlendingData);
                if (i2 < -f || i2 > f || j2 < -f || j2 > f) continue;
                list2.add(positionedBlendingData);
            }
        }
        if (list.isEmpty() && list2.isEmpty()) {
            return a;
        }
        return new Blender(chunkRegion, list, list2);
    }

    Blender(RegionLimitedWorldAccess chunkRegion, List<c> list, List<c> list2) {
        this.l = chunkRegion;
        this.m = list;
        this.n = list2;
    }

    public TerrainInfo a(int i2, int j2, TerrainInfo terrainInfo) {
        int l3;
        int k3 = QuartPos.a(i2);
        double d3 = this.a(k3, 0, l3 = QuartPos.a(j2), BlendingData::a);
        if (d3 != Double.MAX_VALUE) {
            return new TerrainInfo(Blender.a(d3), 10.0, 0.0);
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(0.0);
        MutableDouble mutableDouble3 = new MutableDouble(Double.POSITIVE_INFINITY);
        for (c positionedBlendingData : this.m) {
            positionedBlendingData.c.a(QuartPos.d(positionedBlendingData.a), QuartPos.d(positionedBlendingData.b), (int k2, int l2, double d2) -> {
                double e2 = MathHelper.e((double)(k3 - k2), (double)(l3 - l2));
                if (e2 > (double)c) {
                    return;
                }
                if (e2 < mutableDouble3.doubleValue()) {
                    mutableDouble3.setValue(e2);
                }
                double f2 = 1.0 / (e2 * e2 * e2 * e2);
                mutableDouble2.add(d2 * f2);
                mutableDouble.add(f2);
            });
        }
        if (mutableDouble3.doubleValue() == Double.POSITIVE_INFINITY) {
            return terrainInfo;
        }
        double e2 = mutableDouble2.doubleValue() / mutableDouble.doubleValue();
        double f2 = MathHelper.a(mutableDouble3.doubleValue() / (double)(c + 1), 0.0, 1.0);
        f2 = 3.0 * f2 * f2 - 2.0 * f2 * f2 * f2;
        double g2 = MathHelper.d(f2, Blender.a(e2), terrainInfo.a());
        double h2 = MathHelper.d(f2, 10.0, terrainInfo.b());
        double m2 = MathHelper.d(f2, 0.0, terrainInfo.c());
        return new TerrainInfo(g2, h2, m2);
    }

    private static double a(double d2) {
        double e2 = 1.0;
        double f2 = d2 + 0.5;
        double g2 = MathHelper.c(f2, 8.0);
        return 1.0 * (32.0 * (f2 - 128.0) - 3.0 * (f2 - 120.0) * g2 + 3.0 * g2 * g2) / (128.0 * (32.0 - 3.0 * g2));
    }

    public double a(int i2, int j2, int k2, double d3) {
        int n3;
        int m3;
        int l3 = QuartPos.a(i2);
        double e2 = this.a(l3, m3 = j2 / 8, n3 = QuartPos.a(k2), BlendingData::b);
        if (e2 != Double.MAX_VALUE) {
            return e2;
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(0.0);
        MutableDouble mutableDouble3 = new MutableDouble(Double.POSITIVE_INFINITY);
        for (c positionedBlendingData : this.n) {
            positionedBlendingData.c.a(QuartPos.d(positionedBlendingData.a), QuartPos.d(positionedBlendingData.b), m3 - 1, m3 + 1, (int l2, int m2, int n2, double d2) -> {
                double e2 = MathHelper.e((double)(l3 - l2), (double)((m3 - m2) * 2), (double)(n3 - n2));
                if (e2 > 2.0) {
                    return;
                }
                if (e2 < mutableDouble3.doubleValue()) {
                    mutableDouble3.setValue(e2);
                }
                double f2 = 1.0 / (e2 * e2 * e2 * e2);
                mutableDouble2.add(d2 * f2);
                mutableDouble.add(f2);
            });
        }
        if (mutableDouble3.doubleValue() == Double.POSITIVE_INFINITY) {
            return d3;
        }
        double f2 = mutableDouble2.doubleValue() / mutableDouble.doubleValue();
        double g2 = MathHelper.a(mutableDouble3.doubleValue() / 3.0, 0.0, 1.0);
        return MathHelper.d(g2, f2, d3);
    }

    private double a(int i2, int j2, int k2, a cellValueGetter) {
        int l2 = QuartPos.e(i2);
        int m2 = QuartPos.e(k2);
        boolean bl = (i2 & 3) == 0;
        boolean bl2 = (k2 & 3) == 0;
        double d2 = this.a(cellValueGetter, l2, m2, i2, j2, k2);
        if (d2 == Double.MAX_VALUE) {
            if (bl && bl2) {
                d2 = this.a(cellValueGetter, l2 - 1, m2 - 1, i2, j2, k2);
            }
            if (d2 == Double.MAX_VALUE) {
                if (bl) {
                    d2 = this.a(cellValueGetter, l2 - 1, m2, i2, j2, k2);
                }
                if (d2 == Double.MAX_VALUE && bl2) {
                    d2 = this.a(cellValueGetter, l2, m2 - 1, i2, j2, k2);
                }
            }
        }
        return d2;
    }

    private double a(a cellValueGetter, int i2, int j2, int k2, int l2, int m2) {
        BlendingData blendingData = BlendingData.a(this.l, i2, j2);
        if (blendingData != null) {
            return cellValueGetter.get(blendingData, k2 - QuartPos.d(i2), l2, m2 - QuartPos.d(j2));
        }
        return Double.MAX_VALUE;
    }

    public BiomeResolver a(BiomeResolver biomeSupplier) {
        return (x2, y2, z2, noise) -> {
            BiomeBase biome = this.a(x2, y2, z2);
            if (biome == null) {
                return biomeSupplier.getNoiseBiome(x2, y2, z2, noise);
            }
            return biome;
        };
    }

    @Nullable
    private BiomeBase a(int x2, int y2, int z2) {
        double d2 = (double)x2 + b.a(x2, 0.0, z2) * 12.0;
        double e2 = (double)z2 + b.a(z2, x2, 0.0) * 12.0;
        MutableDouble mutableDouble = new MutableDouble(Double.POSITIVE_INFINITY);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        MutableObject mutableObject = new MutableObject();
        for (c positionedBlendingData : this.m) {
            positionedBlendingData.c.a(QuartPos.d(positionedBlendingData.a), QuartPos.d(positionedBlendingData.b), (int i2, int j2, double f2) -> {
                double g2 = MathHelper.e(d2 - (double)i2, e2 - (double)j2);
                if (g2 > (double)c) {
                    return;
                }
                if (g2 < mutableDouble.doubleValue()) {
                    mutableObject.setValue((Object)new ChunkCoordIntPair(positionedBlendingData.a, positionedBlendingData.b));
                    mutableBlockPos.d(i2, QuartPos.a(MathHelper.b(f2)), j2);
                    mutableDouble.setValue(g2);
                }
            });
        }
        if (mutableDouble.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double f3 = MathHelper.a(mutableDouble.doubleValue() / (double)(c + 1), 0.0, 1.0);
        if (f3 > 0.5) {
            return null;
        }
        IChunkAccess chunkAccess = this.l.a(((ChunkCoordIntPair)mutableObject.getValue()).c, ((ChunkCoordIntPair)mutableObject.getValue()).d);
        return chunkAccess.getNoiseBiome(Math.min(mutableBlockPos.u() & 3, 3), mutableBlockPos.v(), Math.min(mutableBlockPos.w() & 3, 3));
    }

    public static void a(RegionLimitedWorldAccess chunkRegion, IChunkAccess chunk) {
        ChunkCoordIntPair chunkPos = chunk.f();
        boolean bl = chunk.s();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), 0, chunkPos.e());
        int i2 = BlendingData.a.u_();
        int j2 = BlendingData.a.ag() - 1;
        if (bl) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int l2 = 0; l2 < 16; ++l2) {
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, i2 - 1, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, i2, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, j2, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, j2 + 1, l2));
                }
            }
        }
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (chunkRegion.a(chunkPos.c + direction.i(), chunkPos.d + direction.k()).s() == bl) continue;
            int m2 = direction == EnumDirection.f ? 15 : 0;
            int n2 = direction == EnumDirection.e ? 0 : 15;
            int o2 = direction == EnumDirection.d ? 15 : 0;
            int p2 = direction == EnumDirection.c ? 0 : 15;
            for (int q2 = m2; q2 <= n2; ++q2) {
                for (int r2 = o2; r2 <= p2; ++r2) {
                    int s2 = Math.min(j2, chunk.a(HeightMap.Type.e, q2, r2)) + 1;
                    for (int t2 = i2; t2 < s2; ++t2) {
                        Blender.a(chunk, mutableBlockPos.a(blockPos, q2, t2, r2));
                    }
                }
            }
        }
    }

    private static void a(IChunkAccess chunk, BlockPosition pos) {
        Fluid fluidState;
        IBlockData blockState = chunk.a_(pos);
        if (blockState.a(TagsBlock.I)) {
            chunk.e(pos);
        }
        if (!(fluidState = chunk.b_(pos)).c()) {
            chunk.e(pos);
        }
    }

    public static void a(GeneratorAccessSeed worldGenLevel, ProtoChunk protoChunk) {
        ChunkCoordIntPair chunkPos = protoChunk.f();
        b distanceGetter = Blender.a(protoChunk.s(), BlendingData.a(worldGenLevel, chunkPos.c, chunkPos.d, true));
        if (distanceGetter == null) {
            return;
        }
        CarvingMask.a mask = (i2, j2, k2) -> {
            double f2;
            double e2;
            double d2 = (double)i2 + 0.5 + b.a(i2, j2, k2) * 4.0;
            return distanceGetter.getDistance(d2, e2 = (double)j2 + 0.5 + b.a(j2, k2, i2) * 4.0, f2 = (double)k2 + 0.5 + b.a(k2, i2, j2) * 4.0) < 4.0;
        };
        Stream.of(WorldGenStage.Features.values()).map(protoChunk::b).forEach(carvingMask -> carvingMask.a(mask));
    }

    @Nullable
    public static b a(boolean bl, Set<EnumDirection8> set) {
        if (!bl && set.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (bl) {
            list.add(Blender.a(null));
        }
        set.forEach(direction8 -> list.add(Blender.a(direction8)));
        return (d2, e2, f2) -> {
            double g2 = Double.POSITIVE_INFINITY;
            for (b distanceGetter : list) {
                double h2 = distanceGetter.getDistance(d2, e2, f2);
                if (!(h2 < g2)) continue;
                g2 = h2;
            }
            return g2;
        };
    }

    private static b a(@Nullable EnumDirection8 direction8) {
        double d2 = 0.0;
        double e2 = 0.0;
        if (direction8 != null) {
            for (EnumDirection direction : direction8.a()) {
                d2 += (double)(direction.i() * 16);
                e2 += (double)(direction.k() * 16);
            }
        }
        double f3 = d2;
        double g3 = e2;
        return (f2, g2, h2) -> Blender.a(f2 - 8.0 - f3, g2 - j, h2 - 8.0 - g3, 8.0, i, 8.0);
    }

    private static double a(double d2, double e2, double f2, double g2, double h2, double i2) {
        double j2 = Math.abs(d2) - g2;
        double k2 = Math.abs(e2) - h2;
        double l2 = Math.abs(f2) - i2;
        return MathHelper.e(Math.max(0.0, j2), Math.max(0.0, k2), Math.max(0.0, l2));
    }

    record c(int a, int b, BlendingData c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "chunkX;chunkZ;blendingData", "a", "b", "c"}, this, object);
        }
    }

    static interface a {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public static interface b {
        public double getDistance(double var1, double var3, double var5);
    }
}

