/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class WorldGenerationContext {
    private final int a;
    private final int b;
    private final World level;

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor world) {
        this(generator, world, null);
    }

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor world, @Nullable World level) {
        this.a = Math.max(world.u_(), generator.h());
        this.b = Math.min(world.v_(), generator.f());
        this.level = level;
    }

    public int a() {
        return this.a;
    }

    public int b() {
        return this.b;
    }

    public World getWorld() {
        if (this.level == null) {
            throw new NullPointerException("WorldGenerationContext was initialized without a Level, but WorldGenerationContext#getWorld was called");
        }
        return this.level;
    }
}

