/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Material;

public class SurfaceSystem {
    private static final IBlockData a = Blocks.fS.n();
    private static final IBlockData b = Blocks.fT.n();
    private static final IBlockData c = Blocks.hf.n();
    private static final IBlockData d = Blocks.fW.n();
    private static final IBlockData e = Blocks.ge.n();
    private static final IBlockData f = Blocks.gg.n();
    private static final IBlockData g = Blocks.ga.n();
    private static final IBlockData h = Blocks.hh.n();
    private static final IBlockData i = Blocks.cM.n();
    private final IBlockData j;
    private final int k;
    private final IBlockData[] l;
    private final NoiseGeneratorNormal m;
    private final NoiseGeneratorNormal n;
    private final NoiseGeneratorNormal o;
    private final NoiseGeneratorNormal p;
    private final NoiseGeneratorNormal q;
    private final NoiseGeneratorNormal r;
    private final NoiseGeneratorNormal s;
    private final IRegistry<NoiseGeneratorNormal.a> t;
    private final Map<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal> u = new ConcurrentHashMap<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal>();
    private final Map<MinecraftKey, PositionalRandomFactory> v = new ConcurrentHashMap<MinecraftKey, PositionalRandomFactory>();
    private final PositionalRandomFactory w;
    private final NoiseGeneratorNormal x;
    private final NoiseGeneratorNormal y;

    public SurfaceSystem(IRegistry<NoiseGeneratorNormal.a> noiseRegistry, IBlockData defaultState, int seaLevel, long seed, SeededRandom.a randomProvider) {
        this.t = noiseRegistry;
        this.j = defaultState;
        this.k = seaLevel;
        this.w = randomProvider.a(seed).b();
        this.m = Noises.a(noiseRegistry, this.w, Noises.P);
        this.l = SurfaceSystem.a(this.w.a(new MinecraftKey("clay_bands")));
        this.x = Noises.a(noiseRegistry, this.w, Noises.N);
        this.y = Noises.a(noiseRegistry, this.w, Noises.O);
        this.n = Noises.a(noiseRegistry, this.w, Noises.Q);
        this.o = Noises.a(noiseRegistry, this.w, Noises.R);
        this.p = Noises.a(noiseRegistry, this.w, Noises.S);
        this.q = Noises.a(noiseRegistry, this.w, Noises.T);
        this.r = Noises.a(noiseRegistry, this.w, Noises.U);
        this.s = Noises.a(noiseRegistry, this.w, Noises.V);
    }

    protected NoiseGeneratorNormal a(ResourceKey<NoiseGeneratorNormal.a> noise) {
        return this.u.computeIfAbsent(noise, resourceKey2 -> Noises.a(this.t, this.w, noise));
    }

    public PositionalRandomFactory a(MinecraftKey id) {
        return this.v.computeIfAbsent(id, i2 -> this.w.a(id).b());
    }

    public void a(BiomeManager biomeAccess, IRegistry<BiomeBase> biomeRegistry, boolean useLegacyRandom, WorldGenerationContext context, final IChunkAccess chunk, NoiseChunk chunkNoiseSampler, SurfaceRules.o surfaceRule) {
        final BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        final ChunkCoordIntPair chunkPos = chunk.f();
        int i2 = chunkPos.d();
        int j2 = chunkPos.e();
        BlockColumn blockColumn = new BlockColumn(){

            @Override
            @Override
            public IBlockData a(int y2) {
                return chunk.a_(mutableBlockPos.q(y2));
            }

            @Override
            @Override
            public void a(int y2, IBlockData state) {
                LevelHeightAccessor levelHeightAccessor = chunk.z();
                if (y2 >= levelHeightAccessor.u_() && y2 < levelHeightAccessor.ag()) {
                    chunk.a(mutableBlockPos.q(y2), state, false);
                    if (!state.n().c()) {
                        chunk.e(mutableBlockPos);
                    }
                }
            }

            @Override
            public String toString() {
                return "ChunkBlockColumn " + chunkPos;
            }
        };
        SurfaceRules.g context2 = new SurfaceRules.g(this, chunk, chunkNoiseSampler, biomeAccess::a, biomeRegistry, context);
        SurfaceRules.u surfaceRule2 = (SurfaceRules.u)surfaceRule.apply(context2);
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                int m2 = i2 + k2;
                int n2 = j2 + l2;
                int o2 = chunk.a(HeightMap.Type.a, k2, l2) + 1;
                mutableBlockPos.p(m2).r(n2);
                BiomeBase biome = biomeAccess.a(mutableBlockPos2.d(m2, useLegacyRandom ? 0 : o2, n2));
                ResourceKey<BiomeBase> resourceKey = biomeRegistry.c(biome).orElseThrow(() -> new IllegalStateException("Unregistered biome: " + biome));
                if (resourceKey == Biomes.A) {
                    this.a(blockColumn, m2, n2, o2, chunk);
                }
                int p2 = chunk.a(HeightMap.Type.a, k2, l2) + 1;
                context2.a(m2, n2);
                int q2 = 0;
                int r2 = Integer.MIN_VALUE;
                int s2 = Integer.MAX_VALUE;
                int t2 = chunk.u_();
                for (int u2 = p2; u2 >= t2; --u2) {
                    IBlockData blockState3;
                    IBlockData blockState = blockColumn.a(u2);
                    if (blockState.g()) {
                        q2 = 0;
                        r2 = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!blockState.n().c()) {
                        if (r2 != Integer.MIN_VALUE) continue;
                        r2 = u2 + 1;
                        continue;
                    }
                    if (s2 >= u2) {
                        s2 = DimensionManager.g;
                        for (int v2 = u2 - 1; v2 >= t2 - 1; --v2) {
                            IBlockData blockState2 = blockColumn.a(v2);
                            if (this.a(blockState2)) continue;
                            s2 = v2 + 1;
                            break;
                        }
                    }
                    int w2 = u2 - s2 + 1;
                    context2.a(++q2, w2, r2, m2, u2, n2);
                    if (blockState != this.j || (blockState3 = surfaceRule2.tryApply(m2, u2, n2)) == null) continue;
                    blockColumn.a(u2, blockState3);
                }
                if (resourceKey != Biomes.U && resourceKey != Biomes.V) continue;
                this.a(context2.b(), biome, blockColumn, mutableBlockPos2, m2, n2, o2);
            }
        }
    }

    protected int a(int i2, int j2) {
        return this.a(this.x, i2, j2);
    }

    protected int b(int i2, int j2) {
        return this.a(this.y, i2, j2);
    }

    private int a(NoiseGeneratorNormal normalNoise, int i2, int j2) {
        return (int)(normalNoise.a(i2, 0.0, j2) * 2.75 + 3.0 + this.w.a(i2, 0, j2).nextDouble() * 0.25);
    }

    private boolean a(IBlockData state) {
        return !state.g() && state.n().c();
    }

    @Deprecated
    public Optional<IBlockData> a(SurfaceRules.o rule, CarvingContext context, Function<BlockPosition, BiomeBase> posToBiome, IChunkAccess chunk, NoiseChunk chunkNoiseSampler, BlockPosition pos, boolean hasFluid) {
        SurfaceRules.g context2 = new SurfaceRules.g(this, chunk, chunkNoiseSampler, posToBiome, context.c().d(IRegistry.aR), context);
        SurfaceRules.u surfaceRule = (SurfaceRules.u)rule.apply(context2);
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        context2.a(i2, k2);
        context2.a(1, 1, hasFluid ? j2 + 1 : Integer.MIN_VALUE, i2, j2, k2);
        IBlockData blockState = surfaceRule.tryApply(i2, j2, k2);
        return Optional.ofNullable(blockState);
    }

    private void a(BlockColumn column, int x2, int z2, int surfaceY, LevelHeightAccessor chunk) {
        IBlockData blockState;
        double d2 = 0.2;
        double e2 = Math.min(Math.abs(this.p.a(x2, 0.0, z2) * 8.25), this.n.a((double)x2 * 0.2, 0.0, (double)z2 * 0.2) * 15.0);
        if (e2 <= 0.0) {
            return;
        }
        double f2 = 0.75;
        double g2 = 1.5;
        double h2 = Math.abs(this.o.a((double)x2 * 0.75, 0.0, (double)z2 * 0.75) * 1.5);
        double i2 = 64.0 + Math.min(e2 * e2 * 2.5, Math.ceil(h2 * 50.0) + 24.0);
        int j2 = MathHelper.b(i2);
        if (surfaceY > j2) {
            return;
        }
        for (int k2 = j2; k2 >= chunk.u_() && !(blockState = column.a(k2)).a(this.j.b()); --k2) {
            if (!blockState.a(Blocks.A)) continue;
            return;
        }
        for (int l2 = j2; l2 >= chunk.u_() && column.a(l2).g(); --l2) {
            column.a(l2, this.j);
        }
    }

    private void a(int minY, BiomeBase biome, BlockColumn column, BlockPosition.MutableBlockPosition mutablePos, int x2, int z2, int surfaceY) {
        double k2;
        double d2 = 1.28;
        double e2 = Math.min(Math.abs(this.s.a(x2, 0.0, z2) * 8.25), this.q.a((double)x2 * 1.28, 0.0, (double)z2 * 1.28) * 15.0);
        if (e2 <= 1.8) {
            return;
        }
        double f2 = 1.17;
        double g2 = 1.5;
        double h2 = Math.abs(this.r.a((double)x2 * 1.17, 0.0, (double)z2 * 1.17) * 1.5);
        double i2 = Math.min(e2 * e2 * 1.2, Math.ceil(h2 * 40.0) + 14.0);
        if (biome.c(mutablePos.d(x2, 63, z2))) {
            i2 -= 2.0;
        }
        if (i2 > 2.0) {
            double j2 = (double)this.k - i2 - 7.0;
            i2 += (double)this.k;
        } else {
            i2 = 0.0;
            k2 = 0.0;
        }
        double l2 = i2;
        RandomSource randomSource = this.w.a(x2, 0, z2);
        int m2 = 2 + randomSource.nextInt(4);
        int n2 = this.k + 18 + randomSource.nextInt(10);
        int o2 = 0;
        for (int p2 = Math.max(surfaceY, (int)l2 + 1); p2 >= minY; --p2) {
            if (!(column.a(p2).g() && p2 < (int)l2 && randomSource.nextDouble() > 0.01) && (column.a(p2).c() != Material.j || p2 <= (int)k2 || p2 >= this.k || k2 == 0.0 || !(randomSource.nextDouble() > 0.15))) continue;
            if (o2 <= m2 && p2 > n2) {
                column.a(p2, i);
                ++o2;
                continue;
            }
            column.a(p2, h);
        }
    }

    private static IBlockData[] a(RandomSource random) {
        Object[] blockStates = new IBlockData[192];
        Arrays.fill(blockStates, c);
        for (int i2 = 0; i2 < blockStates.length; ++i2) {
            if ((i2 += random.nextInt(5) + 1) >= blockStates.length) continue;
            blockStates[i2] = b;
        }
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, d);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 2, e);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, f);
        int j2 = random.a(9, 15);
        int k2 = 0;
        for (int l2 = 0; k2 < j2 && l2 < blockStates.length; ++k2, l2 += random.nextInt(16) + 4) {
            blockStates[l2] = a;
            if (l2 - 1 > 0 && random.nextBoolean()) {
                blockStates[l2 - 1] = g;
            }
            if (l2 + 1 >= blockStates.length || !random.nextBoolean()) continue;
            blockStates[l2 + 1] = g;
        }
        return blockStates;
    }

    private static void a(RandomSource random, IBlockData[] terracottaBands, int minBandSize, IBlockData state) {
        int i2 = random.a(6, 15);
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = minBandSize + random.nextInt(3);
            int l2 = random.nextInt(terracottaBands.length);
            for (int m2 = 0; l2 + m2 < terracottaBands.length && m2 < k2; ++m2) {
                terracottaBands[l2 + m2] = state;
            }
        }
    }

    protected IBlockData a(int x2, int y2, int z2) {
        int i2 = (int)Math.round(this.m.a(x2, 0.0, z2) * 4.0);
        return this.l[(y2 + i2 + this.l.length) % this.l.length];
    }
}

