/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;

public record NoiseSettings(int b, int c, NoiseSamplingSettings d, NoiseSlider e, NoiseSlider f, int g, int h, boolean i, boolean j, boolean k, TerrainShaper l) {
    private final int b;
    private final int c;
    private final NoiseSamplingSettings d;
    private final NoiseSlider e;
    private final NoiseSlider f;
    private final int g;
    private final int h;
    private final boolean i;
    private final boolean j;
    private final boolean k;
    private final TerrainShaper l;
    public static final Codec<NoiseSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)DimensionManager.e, (int)DimensionManager.d).fieldOf("min_y").forGetter(NoiseSettings::h), (App)Codec.intRange((int)0, (int)DimensionManager.c).fieldOf("height").forGetter(NoiseSettings::i), (App)NoiseSamplingSettings.a.fieldOf("sampling").forGetter(NoiseSettings::j), (App)NoiseSlider.a.fieldOf("top_slide").forGetter(NoiseSettings::k), (App)NoiseSlider.a.fieldOf("bottom_slide").forGetter(NoiseSettings::l), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::m), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::n), (App)Codec.BOOL.optionalFieldOf("island_noise_override", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::a), (App)Codec.BOOL.optionalFieldOf("amplified", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::b), (App)Codec.BOOL.optionalFieldOf("large_biomes", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::c), (App)TerrainShaper.a.fieldOf("terrain_shaper").forGetter(NoiseSettings::o)).apply((Applicative)instance, NoiseSettings::new)).comapFlatMap(NoiseSettings::a, Function.identity());

    private static DataResult<NoiseSettings> a(NoiseSettings config) {
        if (config.h() + config.i() > DimensionManager.d + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (DimensionManager.d + 1)));
        }
        if (config.i() % 16 != 0) {
            return DataResult.error((String)"height has to be a multiple of 16");
        }
        if (config.h() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)config);
    }

    public static NoiseSettings a(int minimumY, int height, NoiseSamplingSettings sampling, NoiseSlider topSlide, NoiseSlider bottomSlide, int horizontalSize, int verticalSize, boolean islandNoiseOverride, boolean amplified, boolean largeBiomes, TerrainShaper terrainParameters) {
        NoiseSettings noiseSettings = new NoiseSettings(minimumY, height, sampling, topSlide, bottomSlide, horizontalSize, verticalSize, islandNoiseOverride, amplified, largeBiomes, terrainParameters);
        NoiseSettings.a(noiseSettings).error().ifPresent(partialResult -> {
            throw new IllegalStateException(partialResult.message());
        });
        return noiseSettings;
    }

    @Deprecated
    public boolean a() {
        return this.i;
    }

    @Deprecated
    public boolean b() {
        return this.j;
    }

    @Deprecated
    public boolean c() {
        return this.k;
    }

    public int d() {
        return QuartPos.c(this.n());
    }

    public int e() {
        return QuartPos.c(this.m());
    }

    public int f() {
        return this.i() / this.d();
    }

    public int g() {
        return MathHelper.a(this.h(), this.d());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this, object);
    }

    public int h() {
        return this.b;
    }

    public int i() {
        return this.c;
    }

    public NoiseSamplingSettings j() {
        return this.d;
    }

    public NoiseSlider k() {
        return this.e;
    }

    public NoiseSlider l() {
        return this.f;
    }

    public int m() {
        return this.g;
    }

    public int n() {
        return this.h;
    }

    public TerrainShaper o() {
        return this.l;
    }
}

